#pragma once

#include "resource.h"		// C V{

#define UNZIP32_VERSION			552
#define UNZIP32_SUB_VERSION		3

#ifndef FNAME_MAX32
#define FNAME_MAX32		512
#endif

/* \̒` */
#ifndef ARC_DECSTRACT
#define ARC_DECSTRACT

#if !defined(__BORLANDC__)
#pragma pack(1)
#else
#pragma option -a-
#endif

#if !defined(__BORLANDC__) || __BORLANDC__ >= 0x550
typedef LONGLONG	ULHA_INT64;
#else
typedef struct {
	DWORD	LowPart;
	LONG	HighPart;
} ULHA_INT64, *LPULHA_INT64;
#endif

typedef	HGLOBAL	HARC;

typedef struct {
	DWORD	dwOriginalSize;
	DWORD	dwCompressedSize;
	DWORD	dwCRC;
	UINT	uFlag;
	UINT	uOSType;
	WORD	wRatio;
	WORD	wDate;
	WORD	wTime;
	char	szFileName[FNAME_MAX32 + 1];
	char	dummy1[3];
	char	szAttribute[8];
	char	szMode[8];
} INDIVIDUALINFO, FAR *LPINDIVIDUALINFO;

typedef struct {
	DWORD 			dwFileSize;
	DWORD			dwWriteSize;
	char			szSourceFileName[FNAME_MAX32 + 1];
	char			dummy1[3];
	char			szDestFileName[FNAME_MAX32 + 1];
	char			dummy[3];
}	EXTRACTINGINFO, *LPEXTRACTINGINFO;

typedef struct {
	EXTRACTINGINFO exinfo;
	DWORD dwCompressedSize;
	DWORD dwCRC;
	UINT  uOSType;
	WORD  wRatio;
	WORD  wDate;
	WORD  wTime;
	char  szAttribute[8];
	char  szMode[8];
} EXTRACTINGINFOEX, *LPEXTRACTINGINFOEX;

#if !defined(__BORLANDC__)
#pragma pack()
#else
#pragma option -a.
#endif

#endif /* ARC_DECSTRACT */

/* EBhEbZ[W */
#ifndef WM_ARCEXTRACT
#define	WM_ARCEXTRACT			"wm_arcextract"
#define	ARCEXTRACT_BEGIN		0
#define	ARCEXTRACT_INPROCESS	1
#define	ARCEXTRACT_END			2
#define ARCEXTRACT_OPEN			3
#define ARCEXTRACT_COPY			4
typedef BOOL CALLBACK ARCHIVERPROC(HWND _hwnd, UINT _uMsg, UINT _nState, LPEXTRACTINGINFOEX _lpEis);
typedef ARCHIVERPROC *LPARCHIVERPROC;
#endif

/* API̐錾 */
#ifdef __cplusplus
extern "C" {
#endif

	/* LHA.DLL݊API */
	int   WINAPI UnZip(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize);
	WORD  WINAPI UnZipGetVersion();
	BOOL  WINAPI UnZipGetCursorMode();
	BOOL  WINAPI UnZipSetCursorMode(const BOOL _CursorMode);
	BOOL  WINAPI UnZipGetBackGroundMode();
	BOOL  WINAPI UnZipSetBackGroundMode(const BOOL _BackGroundMode);
	WORD  WINAPI UnZipGetCursorInterval();
	BOOL  WINAPI UnZipSetCursorInterval(const WORD _Interval);
	BOOL  WINAPI UnZipGetRunning();

	/* A[JCoAPI */
	BOOL  WINAPI UnZipConfigDialog(const HWND _hwnd, LPSTR _szOptionBuffer, const int _iMode);
	BOOL  WINAPI UnZipCheckArchive(LPCSTR _szFileName, const int _iMode);
	int   WINAPI UnZipGetFileCount(LPCSTR _szArcFile);
	BOOL  WINAPI UnZipQueryFunctionList(const int _iFunction);

	/* OpenArchivenAPI */
	HARC  WINAPI UnZipOpenArchive(const HWND _hwnd, LPCSTR _szFileName, const DWORD _dwMode);
	int   WINAPI UnZipCloseArchive(HARC _harc);
	int   WINAPI UnZipFindFirst(HARC _harc, LPCSTR _szWildName, INDIVIDUALINFO *_lpSubInfo);
	int   WINAPI UnZipFindNext(HARC _harc, INDIVIDUALINFO *_lpSubInfo);
	int   WINAPI UnZipGetArcFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize);
	DWORD WINAPI UnZipGetArcFileSize(HARC _harc);
	DWORD WINAPI UnZipGetArcOriginalSize(HARC _harc);
	DWORD WINAPI UnZipGetArcCompressedSize(HARC _harc);
	WORD  WINAPI UnZipGetArcRatio(HARC _harc);
	WORD  WINAPI UnZipGetArcDate(HARC _harc);
	WORD  WINAPI UnZipGetArcTime(HARC _harc);
	UINT  WINAPI UnZipGetArcOSType(HARC _harc);
	int   WINAPI UnZipIsSFXFile(HARC _harc);
	int   WINAPI UnZipGetFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize);
	DWORD WINAPI UnZipGetOriginalSize(HARC _harc);
	DWORD WINAPI UnZipGetCompressedSize(HARC _harc);
	WORD  WINAPI UnZipGetRatio(HARC _harc);
	WORD  WINAPI UnZipGetDate(HARC _harc);
	WORD  WINAPI UnZipGetTime(HARC _harc);
	DWORD WINAPI UnZipGetCRC(HARC _harc);
	int   WINAPI UnZipGetAttribute(HARC _harc);
	UINT  WINAPI UnZipGetOSType(HARC _harc);
	int   WINAPI UnZipGetMethod(HARC _harc, LPSTR _lpBuffer, const int _nSize);
	DWORD WINAPI UnZipGetWriteTime(HARC _harc);
	DWORD WINAPI UnZipGetCreateTime(HARC _harc);
	DWORD WINAPI UnZipGetAccessTime(HARC _harc);
	BOOL  WINAPI UnZipGetWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime);
//	BOOL  WINAPI UnZipGetCreateTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime);
//	BOOL  WINAPI UnZipGetAccessTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime);
	BOOL  WINAPI UnZipGetArcCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime);
	BOOL  WINAPI UnZipGetArcAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime);
	BOOL  WINAPI UnZipGetArcWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime);
	BOOL  WINAPI UnZipGetArcFileSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	BOOL  WINAPI UnZipGetArcOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	BOOL  WINAPI UnZipGetArcCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	BOOL  WINAPI UnZipGetOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	BOOL  WINAPI UnZipGetCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);

	/* SetOwnerWindownAPI */	
	BOOL WINAPI UnZipSetOwnerWindow(HWND _hwnd);
	BOOL WINAPI UnZipClearOwnerWindow();
	BOOL WINAPI UnZipSetOwnerWindowEx(HWND _hwnd, LPARCHIVERPROC _lpArcProc);
	BOOL WINAPI UnZipKillOwnerWindowEx(HWND _hwnd);

	/* 7-zip32.dllƎAPI */
	WORD WINAPI UnZipGetSubVersion();
	int  WINAPI UnZipGetArchiveType(LPCSTR _szFileName);

	/* UnZip32.DLLƎH */
	int  WINAPI UnZipCommandLine(HWND hWnd, HINSTANCE hInst, LPCSTR szCmdLine, DWORD nCmdShow);
	int  WINAPI UnZipAdd(HARC harc, LPSTR szFileName, DWORD dwMode);
	int  WINAPI UnZipMove(HARC harc, LPSTR szFileName, DWORD dwMode);
	int  WINAPI UnZipDelete(HARC harc, LPSTR szFileName, DWORD dwMode);

#ifdef __cplusplus
}
#endif



/* True Compatible API (wA[JCo`ohxƎ́A݊̍ API Qłj
	VKɎgpꍇ́Ao邾gB
	Fݍ蒆ŁA̓IɌ肵͉̂L݂̂łB
	    ӌ^v] NIFTY-Serve  FWINDC Mes #3 ցI
 */

/**/
#if !defined(CHECKARCHIVE_RAPID)
#define	CHECKARCHIVE_RAPID	0 /* ȈՌ^ij */
#define	CHECKARCHIVE_BASIC	1 /* W^iwb_[̂݁j */
#define	CHECKARCHIVE_FULLCRC	2 /* S^ibqb̃`FbN܂ށj */
#endif

/**/
#if !defined(UNPACK_CONFIG_MODE)
#define	UNPACK_CONFIG_MODE	1 /* 𓀁ijñR}h */
#define	PACK_CONFIG_MODE	2 /* ki쐬jñR}h */
#endif

/**/
#if !defined(ISARC_FUNCTION_START)
#define ISARC_FUNCTION_START			0
#define ISARC					0
#define ISARC_GET_VERSION			1
#define ISARC_GET_CURSOR_INTERVAL		2
#define ISARC_SET_CURSOR_INTERVAL		3
#define ISARC_GET_BACK_GROUND_MODE		4
#define ISARC_SET_BACK_GROUND_MODE		5
#define ISARC_GET_CURSOR_MODE			6
#define ISARC_SET_CURSOR_MODE			7
#define ISARC_GET_RUNNING			8

#define ISARC_CHECK_ARCHIVE			16
#define ISARC_CONFIG_DIALOG			17
#define ISARC_GET_FILE_COUNT			18
#define ISARC_QUERY_FUNCTION_LIST		19
#define ISARC_HOUT				20
#define ISARC_STRUCTOUT				21
#define ISARC_GET_ARC_FILE_INFO			22

#define ISARC_OPEN_ARCHIVE			23
#define ISARC_CLOSE_ARCHIVE			24
#define ISARC_FIND_FIRST			25
#define ISARC_FIND_NEXT				26
#define ISARC_EXTRACT				27
#define ISARC_ADD				28
#define ISARC_MOVE				29
#define ISARC_DELETE				30
#define ISARC_SETOWNERWINDOW			31
#define ISARC_CLEAROWNERWINDOW			32
#define ISARC_SETOWNERWINDOWEX			33
#define ISARC_KILLOWNERWINDOWEX			34

#define ISARC_GET_ARC_FILE_NAME			40
#define ISARC_GET_ARC_FILE_SIZE			41
#define ISARC_GET_ARC_ORIGINAL_SIZE		42
#define ISARC_GET_ARC_COMPRESSED_SIZE		43
#define ISARC_GET_ARC_RATIO			44
#define ISARC_GET_ARC_DATE			45
#define ISARC_GET_ARC_TIME			46
#define ISARC_GET_ARC_OS_TYPE			47
#define ISARC_GET_ARC_IS_SFX_FILE		48
#define ISARC_GET_ARC_CREATE_TIME_EX	50
#define	ISARC_GET_ARC_ACCESS_TIME_EX	51
#define	ISARC_GET_ARC_CREATE_TIME_EX2	52
#define ISARC_GET_FILE_NAME			57
#define ISARC_GET_ORIGINAL_SIZE			58
#define ISARC_GET_COMPRESSED_SIZE		59
#define ISARC_GET_RATIO				60
#define ISARC_GET_DATE				61
#define ISARC_GET_TIME				62
#define ISARC_GET_CRC				63
#define ISARC_GET_ATTRIBUTE			64
#define ISARC_GET_OS_TYPE			65
#define ISARC_GET_METHOD				66
#define ISARC_GET_WRITE_TIME			67
#define ISARC_GET_CREATE_TIME			68
#define ISARC_GET_ACCESS_TIME			69
#define ISARC_GET_WRITE_TIME_EX			70
#define ISARC_GET_CREATE_TIME_EX		71
#define ISARC_GET_ACCESS_TIME_EX		72
#define ISARC_SET_ENUM_MEMBERS_PROC		80
#define ISARC_CLEAR_ENUM_MEMBERS_PROC	81

#define ISARC_FUNCTION_END			81
#endif	/* ISARC_FUNCTION_START */




#define	WM_ARCEXTRACT	"wm_arcextract"

#define	ARCEXTRACT_BEGIN	0	/* Yt@C̏̊Jn */
#define	ARCEXTRACT_INPROCESS	1	/* Yt@C̓WJ */
#define	ARCEXTRACT_END		2	/* IA֘AJ */
/* ȉ UNZIP ł͎gpĂȂ */
#define ARCEXTRACT_OPEN			3	/* Yɂ̏̊Jn */
#define ARCEXTRACT_COPY			4	/* [Nt@C̏߂ */

typedef BOOL CALLBACK ARCHIVERPROC(HWND hWnd,UINT uMsg,UINT nState,LPEXTRACTINGINFOEX lpEis);
typedef ARCHIVERPROC *LPARCHIVERPROC;

/* DMZIP32.DLL Ƃ̌݊̂߂ɂ܂B
   UNZIP32.DLL ̃o[WԂ܂AUNZIP32.DLL ߂ɁA0x2000 
   ZĂ܂iUnZipGetVersion() + 0x2000jB
 */

/* MODE (for OpenArchive) */
#define M_INIT_FILE_USE			0x00000001L
#define M_REGARDLESS_INIT_FILE	0x00000002L
#define M_NOT_USE_TIME_STAMP	0x00000008L
#define M_EXTRACT_REPLACE_FILE	0x00000010L
#define M_EXTRACT_NEW_FILE		0x00000020L
#define M_EXTRACT_UPDATE_FILE	0x00000040L
#define M_CHECK_ALL_PATH		0x00000100L
#define M_CHECK_FILENAME_ONLY	0x00000200L
#define M_USE_DRIVE_LETTER		0x00001000L
#define M_NOT_USE_DRIVE_LETTER	0x00002000L
#define M_INQUIRE_DIRECTORY		0x00004000L
#define M_NOT_INQUIRE_DIRECTORY 0x00008000L
#define M_INQUIRE_WRITE			0x00010000L
#define M_NOT_INQUIRE_WRITE		0x00020000L
#define M_REGARD_E_COMMAND		0x00100000L
#define M_REGARD_X_COMMAND		0x00200000L
#define M_ERROR_MESSAGE_ON		0x00400000L
#define M_ERROR_MESSAGE_OFF		0x00800000L
#define M_BAR_WINDOW_ON			0x01000000L
#define M_BAR_WINDOW_OFF		0x02000000L
#define M_RECOVERY_ON			0x08000000L /* jwb_̓ǂݔ΂ */

#define EXTRACT_FOUND_FILE		0x40000000L
#define EXTRACT_NAMED_FILE		0x80000000L



#ifndef FA_RDONLY
/* Attribute */
#define FA_RDONLY       0x01            /* Read only attribute */
#define FA_HIDDEN       0x02            /* Hidden file */
#define FA_SYSTEM       0x04            /* System file */
#define FA_LABEL        0x08            /* Volume label */
#define FA_DIREC        0x10            /* Directory */
#define FA_ARCH         0x20            /* Archive */
#endif
#define FA_ENCRYPTED    0x40            /* Encripted by password */


#define ERROR_START			0x8000

/* WARNING */
#define ERROR_DISK_SPACE		0x8005
#define ERROR_READ_ONLY			0x8006
#define ERROR_USER_SKIP			0x8007
#define ERROR_UNKNOWN_TYPE		0x8008
#define ERROR_METHOD			0x8009
#define ERROR_PASSWORD_FILE		0x800A
#define ERROR_VERSION			0x800B
#define ERROR_FILE_CRC			0x800C
#define ERROR_FILE_OPEN			0x800D
#define ERROR_MORE_FRESH		0x800E
#define ERROR_NOT_EXIST			0x800F
#define ERROR_ALREADY_EXIST		0x8010

#define ERROR_TOO_MANY_FILES		0x8011

/* ERROR */
//#define ERROR_DIRECTORY			0x8012
#define ERROR_MAKEDIRECTORY		0x8012
#define ERROR_CANNOT_WRITE		0x8013
#define ERROR_HUFFMAN_CODE		0x8014
#define ERROR_COMMENT_HEADER		0x8015
#define ERROR_HEADER_CRC		0x8016
#define ERROR_HEADER_BROKEN		0x8017
#define ERROR_ARCHIVE_FILE_OPEN		0x8018
//#define ERROR_ARC_FILE_OPEN		ERROR_ARCHIVE_FILE_OPEN	
#define ERROR_NOT_ARC_FILE		0x8019
//#define ERROR_NOT_ARCHIVE_FILE		ERROR_NOT_ARC_FILE
#define ERROR_CANNOT_READ		0x801A
#define ERROR_FILE_STYLE		0x801B
#define ERROR_COMMAND_NAME		0x801C
#define ERROR_MORE_HEAP_MEMORY		0x801D
#define ERROR_ENOUGH_MEMORY		0x801E
#if !defined(ERROR_ALREADY_RUNNING)
#define ERROR_ALREADY_RUNNING		0x801F
#endif
#define ERROR_USER_CANCEL		0x8020

#define ERROR_HARC_ISNOT_OPENED	0x8021
#define ERROR_NOT_SEARCH_MODE	0x8022
#define ERROR_NOT_SUPPORT		0x8023
#define ERROR_TIME_STAMP		0x8024

//#define ERROR_NULL_POINTER		0x8025
//#define ERROR_ILLEGAL_PARAMETER		0x8026
#define ERROR_TMP_OPEN			0x8025
#define ERROR_LONG_FILE_NAME	0x8026
#define ERROR_ARC_READ_ONLY		0x8027
#define ERROR_SAME_NAME_FILE	0x8028
#define ERROR_NOT_FIND_ARC_FILE 0x8029
#define ERROR_RESPONSE_READ		0x802A
#define ERROR_NOT_FILENAME		0x802B

#define ERROR_END	ERROR_NOT_FILENAME

// Ɍ`
#ifndef ARCHIVETYPE_ZIP
#define ARCHIVETYPE_ZIP		1
#define ARCHIVETYPE_7Z		2
#endif /* ARCHIVETYPE_ZIP */

// IWi\[Xlist.c玝ĂB
// includeƁA₱Ȃ\̂ŁB
int ratio(unsigned long uc, unsigned long c);

#ifdef __cplusplus
extern "C" {
#endif
	BOOL initUnZip32();
	void closeUnZip32();
#ifdef __cplusplus
}
#endif
HINSTANCE hLib;
