#include "stdafx.h"
#include ".\unzip32.h"

typedef int   (WINAPI *LPSEVENZIP)(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize);
typedef WORD  (WINAPI *LPSEVENZIP_GET_VERSION)();
typedef BOOL  (WINAPI *LPSEVENZIP_GET_CURSOR_MODE)();
typedef BOOL  (WINAPI *LPSEVENZIP_SET_CURSOR_MODE)(const BOOL _CursorMode);
typedef BOOL  (WINAPI *LPSEVENZIP_GET_BACK_GROUND_MODE)();
typedef BOOL  (WINAPI *LPSEVENZIP_SET_BACK_GROUND_MODE)(const BOOL _BackGroundMode);
typedef WORD  (WINAPI *LPSEVENZIP_GET_CURSOR_INTERVAL)();
typedef BOOL  (WINAPI *LPSEVENZIP_SET_CURSOR_INTERVAL)(const WORD _Interval);
typedef BOOL  (WINAPI *LPSEVENZIP_GET_RUNNING)();

typedef	BOOL  (WINAPI *LPSEVENZIP_CONFIG_DIALOG)(const HWND _hwnd, LPSTR _szOptionBuffer, const int _iMode);
typedef	BOOL  (WINAPI *LPSEVENZIP_CHECK_ARCHIVE)(LPCSTR _szFileName, const int _iMode);
typedef	int   (WINAPI *LPSEVENZIP_GET_FILE_COUNT)(LPCSTR _szArcFile);
typedef	BOOL  (WINAPI *LPSEVENZIP_QUERY_FUNCTION_LIST)(const int _iFunction);

typedef	HARC  (WINAPI *LPSEVENZIP_OPEN_ARCHIVE)(const HWND _hwnd, LPCSTR _szFileName, const DWORD _dwMode);
typedef	int   (WINAPI *LPSEVENZIP_CLOSE_ARCHIVE)(HARC _harc);
typedef	int   (WINAPI *LPSEVENZIP_FIND_FIRST)(HARC _harc, LPCSTR _szWildName, INDIVIDUALINFO *_lpSubInfo);
typedef	int   (WINAPI *LPSEVENZIP_FIND_NEXT)(HARC _harc, INDIVIDUALINFO *_lpSubInfo);
typedef	int   (WINAPI *LPSEVENZIP_GET_ARC_FILE_NAME)(HARC _harc, LPSTR _lpBuffer, const int _nSize);
typedef	DWORD (WINAPI *LPSEVENZIP_GET_ARC_FILE_SIZE)(HARC _harc);
typedef	DWORD (WINAPI *LPSEVENZIP_GET_ARC_ORIGINAL_SIZE)(HARC _harc);
typedef	DWORD (WINAPI *LPSEVENZIP_GET_ARC_COMPRESSED_SIZE)(HARC _harc);
typedef	WORD  (WINAPI *LPSEVENZIP_GET_ARC_RATIO)(HARC _harc);
typedef	WORD  (WINAPI *LPSEVENZIP_GET_ARC_DATE)(HARC _harc);
typedef	WORD  (WINAPI *LPSEVENZIP_GET_ARC_TIME)(HARC _harc);
typedef	UINT  (WINAPI *LPSEVENZIP_GET_ARC_OSTYPE)(HARC _harc);
typedef	int   (WINAPI *LPSEVENZIP_IS_SFX_FILE)(HARC _harc);
typedef	int   (WINAPI *LPSEVENZIP_GET_FILE_NAME)(HARC _harc, LPSTR _lpBuffer, const int _nSize);
typedef	DWORD (WINAPI *LPSEVENZIP_GET_ORIGINAL_SIZE)(HARC _harc);
typedef	DWORD (WINAPI *LPSEVENZIP_GET_COMPRESSED_SIZE)(HARC _harc);
typedef	WORD  (WINAPI *LPSEVENZIP_GET_RATIO)(HARC _harc);
typedef	WORD  (WINAPI *LPSEVENZIP_GET_DATE)(HARC _harc);
typedef	WORD  (WINAPI *LPSEVENZIP_GET_TIME)(HARC _harc);
typedef	DWORD (WINAPI *LPSEVENZIP_GET_CRC)(HARC _harc);
typedef	int   (WINAPI *LPSEVENZIP_GET_ATTRIBUTE)(HARC _harc);
typedef	UINT  (WINAPI *LPSEVENZIP_GET_OSTYPE)(HARC _harc);
typedef	int   (WINAPI *LPSEVENZIP_GET_METHOD)(HARC _harc, LPSTR _lpBuffer, const int _nSize);
typedef	DWORD (WINAPI *LPSEVENZIP_GET_WRITE_TIME)(HARC _harc);

typedef	BOOL  (WINAPI *LPSEVENZIP_GET_WRITE_TIME_EX)(HARC _harc, FILETIME *_lpftLastWriteTime);

typedef	BOOL  (WINAPI *LPSEVENZIP_GET_ARC_CREATE_TIME_EX)(HARC _harc, FILETIME *_lpftCreationTime);
typedef	BOOL  (WINAPI *LPSEVENZIP_GET_ARC_ACCESS_TIME_EX)(HARC _harc, FILETIME *_lpftLastAccessTime);
typedef	BOOL  (WINAPI *LPSEVENZIP_GET_ARC_WRITE_TIME_EX)(HARC _harc, FILETIME *_lpftLastWriteTime);
typedef	BOOL  (WINAPI *LPSEVENZIP_GET_ARC_FILE_SIZE_EX)(HARC _harc, ULHA_INT64 *_lpllSize);
typedef	BOOL  (WINAPI *LPSEVENZIP_GET_ARC_ORIGINAL_SIZE_EX)(HARC _harc, ULHA_INT64 *_lpllSize);
typedef	BOOL  (WINAPI *LPSEVENZIP_GET_ARC_COMPRESSED_SIZE_EX)(HARC _harc, ULHA_INT64 *_lpllSize);
typedef	BOOL  (WINAPI *LPSEVENZIP_GET_ORIGINAL_SIZE_EX)(HARC _harc, ULHA_INT64 *_lpllSize);
typedef	BOOL  (WINAPI *LPSEVENZIP_GET_COMPRESSED_SIZE_EX)(HARC _harc, ULHA_INT64 *_lpllSize);

typedef	BOOL  (WINAPI *LPSEVENZIP_SET_OWNER_WINDOW)(HWND _hwnd);
typedef	BOOL  (WINAPI *LPSEVENZIP_CLEAR_OWNER_WINDOW)();
typedef	BOOL  (WINAPI *LPSEVENZIP_SET_OWNER_WINDOW_EX)(HWND _hwnd, LPARCHIVERPROC _lpArcProc);
typedef	BOOL  (WINAPI *LPSEVENZIP_KILL_OWNER_WINDOW_EX)(HWND _hwnd);

typedef	WORD  (WINAPI *LPSEVENZIP_GET_SUB_VERSION)();
typedef	int   (WINAPI *LPSEVENZIP_GET_ARCHIVE_TYPE)(LPCSTR _szFileName);
typedef	BOOL  (WINAPI *LPSEVENZIP_SET_UNICODE_MODE)(BOOL _bUnicode);

LPSEVENZIP   lpSevenZip;
LPSEVENZIP_GET_VERSION lpSevenZipGetVersion;
LPSEVENZIP_GET_CURSOR_MODE lpSevenZipGetCursorMode;
LPSEVENZIP_SET_CURSOR_MODE lpSevenZipSetCursorMode;
LPSEVENZIP_GET_BACK_GROUND_MODE lpSevenZipGetBackGroundMode;
LPSEVENZIP_SET_BACK_GROUND_MODE lpSevenZipSetBackGroundMode;
LPSEVENZIP_GET_CURSOR_INTERVAL lpSevenZipGetCursorInterval;
LPSEVENZIP_SET_CURSOR_INTERVAL lpSevenZipSetCursorInterval;
LPSEVENZIP_GET_RUNNING lpSevenZipGetRunning;

LPSEVENZIP_CONFIG_DIALOG lpSevenZipConfigDialog;
LPSEVENZIP_CHECK_ARCHIVE lpSevenZipCheckArchive;
LPSEVENZIP_GET_FILE_COUNT lpSevenZipGetFileCount;
LPSEVENZIP_QUERY_FUNCTION_LIST lpSevenZipQueryFunctionList;

LPSEVENZIP_OPEN_ARCHIVE lpSevenZipOpenArchive;
LPSEVENZIP_CLOSE_ARCHIVE lpSevenZipCloseArchive;
LPSEVENZIP_FIND_FIRST lpSevenZipFindFirst;
LPSEVENZIP_FIND_NEXT lpSevenZipFindNext;
LPSEVENZIP_GET_ARC_FILE_NAME lpSevenZipGetArcFileName;
LPSEVENZIP_GET_ARC_FILE_SIZE lpSevenZipGetArcFileSize;
LPSEVENZIP_GET_ARC_ORIGINAL_SIZE lpSevenZipGetArcOriginalSize;
LPSEVENZIP_GET_ARC_COMPRESSED_SIZE lpSevenZipGetArcCompressedSize;
LPSEVENZIP_GET_ARC_RATIO lpSevenZipGetArcRatio;
LPSEVENZIP_GET_ARC_DATE lpSevenZipGetArcDate;
LPSEVENZIP_GET_ARC_TIME lpSevenZipGetArcTime;
LPSEVENZIP_GET_ARC_OSTYPE lpSevenZipGetArcOSType;
LPSEVENZIP_IS_SFX_FILE lpSevenZipIsSFXFile;
LPSEVENZIP_GET_FILE_NAME lpSevenZipGetFileName;
LPSEVENZIP_GET_ORIGINAL_SIZE lpSevenZipGetOriginalSize;
LPSEVENZIP_GET_COMPRESSED_SIZE lpSevenZipGetCompressedSize;
LPSEVENZIP_GET_RATIO lpSevenZipGetRatio;
LPSEVENZIP_GET_DATE lpSevenZipGetDate;
LPSEVENZIP_GET_TIME lpSevenZipGetTime;
LPSEVENZIP_GET_CRC lpSevenZipGetCRC;
LPSEVENZIP_GET_ATTRIBUTE lpSevenZipGetAttribute;
LPSEVENZIP_GET_OSTYPE lpSevenZipGetOSType;
LPSEVENZIP_GET_METHOD lpSevenZipGetMethod;
LPSEVENZIP_GET_WRITE_TIME lpSevenZipGetWriteTime;
LPSEVENZIP_GET_WRITE_TIME_EX lpSevenZipGetWriteTimeEx;
LPSEVENZIP_GET_ARC_CREATE_TIME_EX lpSevenZipGetArcCreateTimeEx;
LPSEVENZIP_GET_ARC_ACCESS_TIME_EX lpSevenZipGetArcAccessTimeEx;
LPSEVENZIP_GET_ARC_WRITE_TIME_EX lpSevenZipGetArcWriteTimeEx;
LPSEVENZIP_GET_ARC_FILE_SIZE_EX lpSevenZipGetArcFileSizeEx;
LPSEVENZIP_GET_ARC_ORIGINAL_SIZE_EX lpSevenZipGetArcOriginalSizeEx;
LPSEVENZIP_GET_ARC_COMPRESSED_SIZE_EX lpSevenZipGetArcCompressedSizeEx;
LPSEVENZIP_GET_ORIGINAL_SIZE_EX lpSevenZipGetOriginalSizeEx;
LPSEVENZIP_GET_COMPRESSED_SIZE_EX lpSevenZipGetCompressedSizeEx;
LPSEVENZIP_SET_OWNER_WINDOW lpSevenZipSetOwnerWindow;
LPSEVENZIP_CLEAR_OWNER_WINDOW lpSevenZipClearOwnerWindow;
LPSEVENZIP_SET_OWNER_WINDOW_EX lpSevenZipSetOwnerWindowEx;
LPSEVENZIP_KILL_OWNER_WINDOW_EX lpSevenZipKillOwnerWindowEx;
LPSEVENZIP_GET_SUB_VERSION lpSevenZipGetSubVersion;
LPSEVENZIP_GET_ARCHIVE_TYPE lpSevenZipGetArchiveType;
// LPSEVENZIP_SET_UNICODE_MODE lpSevenZipSetUniCodeMode;

BOOL initUnZip32()
{
	if (hLib != NULL) {
		// Ƀ[hĂB
		return TRUE;
	}
	hLib = ::LoadLibrary("7-zip32.DLL");
	if (hLib == NULL) {
		// G[
		::MessageBox(NULL, "not found '7-zip32.DLL'...", "UnZip32.DLL", MB_OK | MB_ICONSTOP);
		return FALSE;
	}
	lpSevenZip = (LPSEVENZIP)GetProcAddress(hLib, "SevenZip");
	lpSevenZipGetVersion = (LPSEVENZIP_GET_VERSION)GetProcAddress(hLib, "SevenZipGetVersion");
	lpSevenZipGetCursorMode = (LPSEVENZIP_GET_CURSOR_MODE)GetProcAddress(hLib, "SevenZipGetCursorMode");
	lpSevenZipSetCursorMode = (LPSEVENZIP_SET_CURSOR_MODE)GetProcAddress(hLib, "SevenZipSetCursorMode");
	lpSevenZipGetBackGroundMode = (LPSEVENZIP_GET_BACK_GROUND_MODE)GetProcAddress(hLib, "SevenZipGetBackGroundMode");
	lpSevenZipSetBackGroundMode = (LPSEVENZIP_SET_BACK_GROUND_MODE)GetProcAddress(hLib, "SevenZipSetBackGroundMode");
	lpSevenZipGetCursorInterval = (LPSEVENZIP_GET_CURSOR_INTERVAL)GetProcAddress(hLib, "SevenZipGetCursorInterval");
	lpSevenZipSetCursorInterval = (LPSEVENZIP_SET_CURSOR_INTERVAL)GetProcAddress(hLib, "SevenZipSetCursorInterval");
	lpSevenZipGetRunning = (LPSEVENZIP_GET_RUNNING)GetProcAddress(hLib, "SevenZipGetRunning");
	
	lpSevenZipConfigDialog = (LPSEVENZIP_CONFIG_DIALOG)GetProcAddress(hLib, "SevenZipConfigDialog");
	lpSevenZipCheckArchive = (LPSEVENZIP_CHECK_ARCHIVE)GetProcAddress(hLib, "SevenZipCheckArchive");
	lpSevenZipGetFileCount = (LPSEVENZIP_GET_FILE_COUNT)GetProcAddress(hLib, "SevenZipGetFileCount");
	lpSevenZipQueryFunctionList = (LPSEVENZIP_QUERY_FUNCTION_LIST)GetProcAddress(hLib, "SevenZipQueryFunctionList");

	lpSevenZipOpenArchive = (LPSEVENZIP_OPEN_ARCHIVE)GetProcAddress(hLib, "SevenZipOpenArchive");
	lpSevenZipCloseArchive = (LPSEVENZIP_CLOSE_ARCHIVE)GetProcAddress(hLib, "SevenZipCloseArchive");
	lpSevenZipFindFirst = (LPSEVENZIP_FIND_FIRST)GetProcAddress(hLib, "SevenZipFindFirst");
	lpSevenZipFindNext = (LPSEVENZIP_FIND_NEXT)GetProcAddress(hLib, "SevenZipFindNext");
	lpSevenZipGetArcFileName = (LPSEVENZIP_GET_ARC_FILE_NAME)GetProcAddress(hLib, "SevenZipGetArcFileName");
	lpSevenZipGetArcFileSize = (LPSEVENZIP_GET_ARC_FILE_SIZE)GetProcAddress(hLib, "SevenZipGetArcFileSize");
	lpSevenZipGetArcOriginalSize = (LPSEVENZIP_GET_ARC_ORIGINAL_SIZE)GetProcAddress(hLib, "SevenZipGetArcOriginalSize");
	lpSevenZipGetArcCompressedSize = (LPSEVENZIP_GET_ARC_COMPRESSED_SIZE)GetProcAddress(hLib, "SevenZipGetArcCompressedSize");
	lpSevenZipGetArcRatio = (LPSEVENZIP_GET_ARC_RATIO)GetProcAddress(hLib, "SevenZipGetArcRatio");
	lpSevenZipGetArcDate = (LPSEVENZIP_GET_ARC_DATE)GetProcAddress(hLib, "SevenZipGetArcDate");
	lpSevenZipGetArcTime = (LPSEVENZIP_GET_ARC_TIME)GetProcAddress(hLib, "SevenZipGetArcTime");
	lpSevenZipGetArcOSType = (LPSEVENZIP_GET_ARC_OSTYPE)GetProcAddress(hLib, "SevenZipGetArcOSType");
	lpSevenZipIsSFXFile = (LPSEVENZIP_IS_SFX_FILE)GetProcAddress(hLib, "SevenZipIsSFXFile");
	lpSevenZipGetFileName = (LPSEVENZIP_GET_FILE_NAME)GetProcAddress(hLib, "SevenZipGetFileName");
	lpSevenZipGetOriginalSize = (LPSEVENZIP_GET_ORIGINAL_SIZE)GetProcAddress(hLib, "SevenZipGetOriginalSize");
	lpSevenZipGetCompressedSize = (LPSEVENZIP_GET_COMPRESSED_SIZE)GetProcAddress(hLib, "SevenZipGetCompressedSize");
	lpSevenZipGetRatio = (LPSEVENZIP_GET_RATIO)GetProcAddress(hLib, "SevenZipGetRatio");
	lpSevenZipGetDate = (LPSEVENZIP_GET_DATE)GetProcAddress(hLib, "SevenZipGetDate");
	lpSevenZipGetTime = (LPSEVENZIP_GET_TIME)GetProcAddress(hLib, "SevenZipGetTime");
	lpSevenZipGetCRC = (LPSEVENZIP_GET_CRC)GetProcAddress(hLib, "SevenZipGetCRC");
	lpSevenZipGetAttribute = (LPSEVENZIP_GET_ATTRIBUTE)GetProcAddress(hLib, "SevenZipGetAttribute");
	lpSevenZipGetOSType = (LPSEVENZIP_GET_OSTYPE)GetProcAddress(hLib, "SevenZipGetOSType");
	lpSevenZipGetMethod = (LPSEVENZIP_GET_METHOD)GetProcAddress(hLib, "SevenZipGetMethod");
	lpSevenZipGetWriteTime = (LPSEVENZIP_GET_WRITE_TIME)GetProcAddress(hLib, "SevenZipGetWriteTime");
	lpSevenZipGetWriteTimeEx = (LPSEVENZIP_GET_WRITE_TIME_EX)GetProcAddress(hLib, "SevenZipGetWriteTimeEx");
	lpSevenZipGetArcCreateTimeEx = (LPSEVENZIP_GET_ARC_CREATE_TIME_EX)GetProcAddress(hLib, "SevenZipGetArcCreateTimeEx");
	lpSevenZipGetArcAccessTimeEx = (LPSEVENZIP_GET_ARC_ACCESS_TIME_EX)GetProcAddress(hLib, "SevenZipGetArcAccessTimeEx");
	lpSevenZipGetArcWriteTimeEx = (LPSEVENZIP_GET_ARC_WRITE_TIME_EX)GetProcAddress(hLib, "SevenZipGetArcWriteTimeEx");
	lpSevenZipGetArcFileSizeEx = (LPSEVENZIP_GET_ARC_FILE_SIZE_EX)GetProcAddress(hLib, "SevenZipGetArcFileSizeEx");
	lpSevenZipGetArcOriginalSizeEx = (LPSEVENZIP_GET_ARC_ORIGINAL_SIZE_EX)GetProcAddress(hLib, "SevenZipGetArcOriginalSizeEx");
	lpSevenZipGetArcCompressedSizeEx = (LPSEVENZIP_GET_ARC_COMPRESSED_SIZE_EX)GetProcAddress(hLib, "SevenZipGetArcCompressedSizeEx");
	lpSevenZipGetOriginalSizeEx = (LPSEVENZIP_GET_ORIGINAL_SIZE_EX)GetProcAddress(hLib, "SevenZipGetOriginalSizeEx");
	lpSevenZipGetCompressedSizeEx = (LPSEVENZIP_GET_COMPRESSED_SIZE_EX)GetProcAddress(hLib, "SevenZipGetCompressedSizeEx");
	lpSevenZipSetOwnerWindow = (LPSEVENZIP_SET_OWNER_WINDOW)GetProcAddress(hLib, "SevenZipSetOwnerWindow");
	lpSevenZipClearOwnerWindow = (LPSEVENZIP_CLEAR_OWNER_WINDOW)GetProcAddress(hLib, "SevenZipClearOwnerWindow");
	lpSevenZipSetOwnerWindowEx = (LPSEVENZIP_SET_OWNER_WINDOW_EX)GetProcAddress(hLib, "SevenZipSetOwnerWindowEx");
	lpSevenZipKillOwnerWindowEx = (LPSEVENZIP_KILL_OWNER_WINDOW_EX)GetProcAddress(hLib, "SevenZipKillOwnerWindowEx");
	lpSevenZipGetSubVersion = (LPSEVENZIP_GET_SUB_VERSION)GetProcAddress(hLib, "SevenZipGetSubVersion");
	lpSevenZipGetArchiveType = (LPSEVENZIP_GET_ARCHIVE_TYPE)GetProcAddress(hLib, "SevenZipGetArchiveType");
//	lpSevenZipSetUniCodeMode = (LPSEVENZIP_SET_UNICODE_MODE)GetProcAddress(hLib, "SevenZipSetUnicodeMode");

	if (lpSevenZip == NULL ||
		lpSevenZipGetVersion == NULL ||
		lpSevenZipGetCursorMode == NULL ||
		lpSevenZipSetCursorMode == NULL ||
		lpSevenZipGetBackGroundMode == NULL ||
		lpSevenZipSetBackGroundMode == NULL ||
		lpSevenZipGetCursorInterval == NULL ||
		lpSevenZipSetCursorInterval == NULL ||
		lpSevenZipGetRunning == NULL ||

		lpSevenZipConfigDialog == NULL ||
		lpSevenZipCheckArchive == NULL ||
		lpSevenZipGetFileCount == NULL ||
		lpSevenZipQueryFunctionList == NULL
		) {
		// G[
		FreeLibrary(hLib);
		hLib = NULL;
		return FALSE;
	}

	return TRUE;
}

void closeUnZip32()
{
	if (hLib != NULL) {
		FreeLibrary(hLib);
		hLib = NULL;
	}
	return;
}

/**
 * k^𓀂s܂B
 */
int WINAPI UnZip(const HWND hWnd, LPCSTR szCmdLine, LPSTR szOutput, const DWORD dwSize)
{
	CString strCmdLine = szCmdLine;
	CStringList argv;
	int iStartPos = 0;
	int i;
	BOOL bQuote = FALSE;
	
	ATLTRACE("strCmdLine: %s\n", strCmdLine);

	if (!initUnZip32()) {
		return ERROR_NOT_FILENAME;
	}
	// nꂽR}hCAp[^ƂCStringList֊i[B
	
	// Ő󔒂菜B
	strCmdLine.TrimLeft();
	strCmdLine.TrimRight();
	// ̍Ōɋ󔒂B
	strCmdLine += " ";
	for (i = 0; i < strCmdLine.GetLength(); i++) {
		switch (strCmdLine.GetAt(i)) {
		case '\"':
			// ɁAIWił́Ap󔒁A^uAsȊOɂ
			// u"hoge fuga""aaa"v̂悤ȃ_uNI[gň͂񂾕ӎB
			if (bQuote) {
				CString strArgv = ((LPCTSTR)strCmdLine.Mid(iStartPos, i - iStartPos + 1));
				strArgv.TrimRight();
				if (strArgv.GetLength() > 0) {
					argv.AddTail(strArgv);
				}
				iStartPos = i + 1;
			}
			bQuote = !bQuote;
			break;
		case ' ':
		case '\t':
		case '\n':
			if (!bQuote) {
				CString strArgv = ((LPCTSTR)strCmdLine.Mid(iStartPos, i - iStartPos));
				strArgv.TrimRight();
				if (strArgv.GetLength() > 0) {
					argv.AddTail(strArgv);
				}
				iStartPos = i + 1;
			}
			break;
		default:
			break;
		}
	}
#ifdef _DEBUG
	for (i = 0; i < (int)argv.GetCount(); i++) {
		ATLTRACE("argv: %s\n", argv.GetAt(argv.FindIndex(i)));
	}
#endif

	// p[^̕]
	// 7-zip32.dll̃R}hCɑgւB

	CString strCommand = "x ";
	CString strZipOption;
	CString strOption;
	CString strZipFile;
	CString strEtc;
	BOOL bReverse = FALSE;
	CString strPass;
	BOOL bUseRegZipFile = TRUE;

	for (i = 0; i < (int)argv.GetCount(); i++) {
		CString strArgv = argv.GetAt(argv.FindIndex(i));  
		switch (strArgv.GetAt(0)) {
		case '-':
			if (strArgv.GetAt(1) == '-') {
				// ߔے
				bReverse = TRUE;
				strZipOption = strArgv.Mid(2);
			} else {
				bReverse = FALSE;
				strZipOption = strArgv.Mid(1);	
			}

			switch (strZipOption.GetAt(0)) {
			case 'c':	// Ƀt@C̕\
						// ɂPȏ̃t@C𓀂āA\܂B
						// ۂ̕\́AUnZip()  szOutput ɑ΂ĂȂ܂B
						// t@C̏o͂܂B
				goto command_err_part;
				break;
			case 'f':	// łɑ݂t@Ĉ݃Abvf[g܂B
						// ɂPȏ̃t@CJgfBNg܂͎w肳ꂽ
						// fBNgɉ𓀂܂B
						// AVK쐬͂A𓀃t@Ct@CVꍇ
						// A㏑܂B
				goto command_err_part;
				break;
			case 'l':	// ɂ̓ëꗗ\ (kg`̏)
						// ɂ̓ëꗗ\iszOutput ɑ΂ój܂B

						// -lv ɂ̓ëꗗ\ (UNZIP W̏)
						// ɂ̓ëꗗ\iszOutput ɑ΂ój܂B
				strCommand = "l ";
				break;
			case 'p':	// Ƀt@C̕\iê݁j
						// ɂPȏ̃t@C𓀂āA\܂B
						// ۂ̕\́AUnZip()  szOutput ɑ΂ĂȂ܂B
						// -c ƈقȂAt@C̏o͂͂܂B
				goto command_err_part;
				break;
			case 't':	// ɂ̐eXg
						// Iꂽt@C̓e CRC leXg܂B
						// t@Ce̊mFɂ 32 rbg CRC gĂ܂B
				strCommand = "t ";
				break;
			case 'u':	// łɑ݂t@C̃Abvf[gB
						// ɂPȏ̃t@CJgfBNg܂͎w肳ꂽ
						// fBNgɉ𓀂܂B
						// 𓀃t@Ct@CVꍇA㏑܂B܂
						// t@C݂Ȃꍇɂ͐VK쐬܂B
				strCommand = "x ";
				// t@C݂ƁASĖ₢킹邯ǁAG[oȂ܂H
				break;
			case 'v':	// ɂ̓ëꗗ\ (UNZIP W̃t)
						// ɂ̓ëꗗ\iszOutput ɑ΂ój܂B
				strCommand = "l ";
				break;
			case 'x':	// ɂ̃t@C (default)
						// ɂPȏ̃t@CJgfBNg܂͎w肳ꂽ
						// fBNgɉ𓀂܂B
						// 𓀌ʂ̕񍐏́AW
						//	file_name method to new_file_name
						// łBfile_name ͏ɒ̃t@CAnew_file_name ͉𓀌
						// ۂ̃t@CitpXjłB
						// ܂Amethod ͈kɂ
						//	"Extracting"A"UnShrinking"A"Expanding"A"Exploding"A"Inflating"
						// ̂ꂩƂȂ܂B

						// -xv ɂ̃t@C𓀁iUNZIP ̕W`j
						// -x Ɠlɉ𓀂܂B
						// A𓀌ʂ̕񍐏́AƂƂUNZIP ̕W`ŁA
						//	method: new_file_name
						// ƂȂ܂Bꂼ̈Ӗ -x ƓłB
				strCommand = "x ";
				break;
			case 'z':	// Rg̕\
						// ɂɕtꂽRg\܂B
				goto command_err_part;
				break;
			case 'Z':	// Rg̕\
						// ɂɕtꂽRg𓀂ɐ旧āAMessageBox() ŕ\܂B
				goto command_err_part;
				break;
			
			case 'a':	// MS-DOS ̃eLXg`iCR+LF ŉsjɕϊ܂B
						// ́Ãt@C Mac ̃eLXg`iCR ŉsjA܂
						// Unix/VMS ̃eLXg`iLF ŉs) ̏ꍇ̂ݗLłB
				break;
			case 'C':	// K\ő啶ƏʂȂ (default)
				break;	
			case 'i':   // 𓀏󋵂̕\_CAOo (default)
						// ֎~ɂ --i Ǝw肵ĂB
				if (bReverse) {
					strOption += "-hide ";
				}
				break;
			case 'j':	// ɒ̃fBNgKw̋L^𖳎AׂẴt@Cw
						// fBNgɓWJ܂B
				if (bReverse) {
					strCommand = "x ";
				} else {
					strCommand = "e ";
				}
				break;
			case 'n':	// łɃt@C݂΁A㏑ȂB
				strOption += "-aos ";
				break;
			case 'o':	// łɃt@C݂ĂA[U[ɖ₢킹邱ƂȂ㏑B
				strOption += "-aoa ";
				break;
			case 'P':	// $$$ Ít@Cɑ΂āA$$$ pX[hƂĎgpB
						// Í̓t@CɈقȂ\܂AŎwł̂
						// SĂɋʂłPłB
				strPass = strZipOption.Mid(1);
				strOption += "-p";
				strOption += strPass;
				strOption += " ";
				break;
			case 'q':	// o邾]vȏ͕\ȂB
						// -qq ɁuÂv
						// -qd UnZip() ̕ԂlƂāAXLbvt@CԂB
						//	 iWł̓G[Ȃ΃XLbvɊւ炸OԂjB
						//	 ̃IvV  Ver 0.98ȑÕo[Wɂ͎Ă܂B
						//	 ͂ȂƎv܂Ao΃o[W`FbN̏A
						//	 gpB
						
						//iVer 5.41ȍ~ǉFȉ̃IvVɂ -- ɂu]v͎gȂŉj

						//-qeddd wtH_iт̊KwjȊOւ̉𓀂ɑ΂x (default)
						//-qsp0  ()
						//-qedde LɉA΃pXi"../"܂߁jw͖ŌxΏۂɂ
						//-qsp1  ()
						//         FhCũ[g͏ɎwtH_OƓɈ܂B

						//-qeedd -qsp Ŏw肵spXɑ΂Čx\đI (default)
						//-qsq0  ()
						//-qeede -qsp Ŏw肵spXɑ΂Čx\iXLbvÎݑIj
						//-qsq1  ()
						//-qeeed -qsp Ŏw肵spXɑ΂ĖŋۂiG[Ij
						//-qsq2  ()

						//-qUdde Ver 5.40 ɂUnZipSetOwnerWindowEx()̃R[obN֐̖߂l
						//        oO邪A{̓iTRUE ŏpAFALSE Œ~jɂ
						//       iUNZIP32.API t@CQƁj
						//-qc0   ()
						//-qUddd LŁAFALSEŏpATRUE Œ~Ƃ (default)
						//-qc1   ()

				//-qUdee 𓀃t@CwɐK\gȂB
				//-qr0   ()
				if (strZipOption.Compare("qUdee") == 0 || strZipOption.Compare("qr0") == 0) {
					bUseRegZipFile = FALSE;
				}
				//-qUded 𓀃t@Cw𐳋K\Ƃď (default)
				//-qr1   ()
				if (strZipOption.Compare("qUded") == 0 || strZipOption.Compare("qr1") == 0) {
					bUseRegZipFile = TRUE;
				}
				break;
			case 's':	// t@Cɋ󔒂Ă̂܂܏ (default)
				break;
			case 'U':	// t@C啶̂܂܂ɂBiUNZIP.DLL ł͖Ӗł ^_^j
				break;
			case 'V':	// VMS ̃t@CEo[Wԍ̂܂܎c (default)
						// it@C ;## ̌`ŕtĂ܂B܂AMacintosh  Info(?)
						// ľ`ŕۑĂꍇ܂j
				break;
			case 'X':	// iVMS pɗ\Bj
				break;
			default:	
				goto command_err_part;
				break;
			}
			bReverse = FALSE;
			break;
		default:
			// ChJ[h̎dl7-zip32.dlĺu*v̂
			if (strArgv.Compare("*.*") == 0) {
				strEtc += "* ";	
			} else {
				// t@C؂u/vu\v֕ϊ
				strArgv.Replace("/", "\\");
				CString strNoQuote = strArgv;
				strNoQuote.TrimLeft('"');
				strNoQuote.TrimRight('"');
				if (strNoQuote.GetAt(strNoQuote.GetLength() - 1) == '\\') {  
					// Ō̕\ŏI
					strOption += "-o";
					strOption += strArgv;
					strOption += " ";
				} else if (strNoQuote.GetAt(0) == '@') {
					// X|Xt@C

					// IWił̃R}hĆAK\T|[gĂA
					// u[v܂ރt@ĆAK\Ɖ߂ׁAvO
					// ł́A΍􂵂nĂB7-zip32.dll̃R}hC
					// ͐K\T|[gĂȂ̂ŁA{̃t@Cɖ߂Ă
					// KvB
					// IWiłɂȎdl΁AX|Xt@CJ
					// Kv񂾂ǂ...B
					CAtlFile f;
					if (SUCCEEDED(f.Create(strNoQuote.Mid(1), GENERIC_READ | GENERIC_WRITE, 0, OPEN_EXISTING))) {
						ULONGLONG length;
						if (SUCCEEDED(f.GetSize(length))) {
							if (length < INT_MAX) {
								TCHAR* buffer = new TCHAR[(DWORD)(length + 1)];
								if (SUCCEEDED(f.Read(buffer, (DWORD)length))) {
									buffer[length] = '\0';
									CString strBuffer = buffer;
									strBuffer.Replace("[[]", "[");
									strBuffer.Replace("/", "\\"); 
									f.Seek(0, FILE_BEGIN);
									f.SetSize(0);
									f.Write(strBuffer, strBuffer.GetLength());
									f.Flush(); 
								}
							}
						}
					}
					strEtc += (strArgv + " ");
				} else {
					if (strZipFile.GetLength() == 0) {
						if (bUseRegZipFile) {
							strArgv.Replace("[[]", "["); 
						}
						strArgv.Replace("/", "\\"); 
						strZipFile = strArgv;
						strZipFile += " ";
					} else {
						// IWił̃R}hĆAK\T|[gĂA
						// u[v܂ރt@ĆAK\Ɖ߂ׁAvO
						// ł́A΍􂵂nĂB7-zip32.dll̃R}hC
						// ͐K\T|[gĂȂ̂ŁA{̃t@Cɖ߂Ă
						// KvB
						strArgv.Replace("[[]", "["); 
						strArgv.Replace("/", "\\"); 
						strEtc += (strArgv + " ");
					}
				}
			}
			break;
		}
	}
	strOption += "-- ";
	strCmdLine = strCommand + strOption + strZipFile + strEtc;
	strCmdLine.TrimRight(); 
#ifdef _DEBUG
	ATLTRACE("strCmdLine = '%s'", strCmdLine);
#endif
	// SevenZippɑgւR}hnB
	return (*lpSevenZip)(hWnd, strCmdLine, szOutput, dwSize);

command_err_part:
	if (dwSize > 0) {
		CString strMsg = "Sorry, this command or option is not supported by 'Fake of UnZip32.DLL'.";
		_tcscpy(szOutput, strMsg);
	}
	return ERROR_COMMAND_NAME;
}
/**
 * wt@CT|[gĂA[JCot@CƂĐ
 * Ԃ܂B
 */
BOOL WINAPI UnZipCheckArchive(LPCSTR szFileName, const int iMode)
{
	// CheckArchiveƁA7zȃt@COKɂȂ̂ŁA
	// SevenZipGetArchiveTypeZIPt@Cǂ̃`FbNB
	if (!initUnZip32()) {
		return FALSE;
	}
	BOOL bResult;
	CString strFileName = szFileName;
	strFileName.TrimLeft("\"");
	strFileName.TrimRight("\"");
	bResult = (*lpSevenZipCheckArchive)(strFileName, iMode);
	if (bResult) {
		int iResult = (*lpSevenZipGetArchiveType)(strFileName);
		if (iResult != ARCHIVETYPE_ZIP) {
			bResult = FALSE;
		}
	}
	return bResult;
}
/**
 * k^𓀂̃IvVw_CAO̕\BUnZip() ɓnR}h
 * ̃IvVΘbIɐݒ肷Kv鎞ɌĂяoĂB
 */
BOOL WINAPI UnZipConfigDialog(const HWND hwnd, LPSTR szOption, const int iMode)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// 7-zip32.dllł́Ao[W̃_CAÔ݁B
	// UUnZip32.DLLIWĩ_CAOłǂǁA
	// ł΂ȂB
	return (*lpSevenZipConfigDialog)(hwnd, szOption, iMode);
}
/**
 * UNZIP32.DLL ݂̌̃o[WԂ܂B
 */
WORD WINAPI UnZipGetVersion(VOID)
{
	// Ǝ̃o[WԂǂH
//	return SevenZipGetVersion();
	return UNZIP32_VERSION;

}
/**
 *  UNZIP32.DLL 쒆ۂ𓾂܂B
 * AvP[V͕Kk^𓀓̃t@CANZX𔺂`oh
 * sOɂ́Aɂs\`FbNKv܂B
 */
BOOL WINAPI UnZipGetRunning(VOID)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipGetRunning)();
}
/**
 * UNZIP32.DLL obNOEh[hۂ𓾂܂B
 */
BOOL WINAPI UnZipGetBackGroundMode(VOID)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipGetBackGroundMode)();
}
/**
 * UNZIP32.DLL ̃obNOEh[hݒ肵܂B
 * obNOEhŎsȂk^𓀂̑x͑ł̏
 * ^XNL܂B
 * Win32 ̊̏ꍇ͔obNOEhłL܂̂ŁAFALSE
 * ݒŗǂł傤B
 */
BOOL WINAPI UnZipSetBackGroundMode(const BOOL bBackGroundMode)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipSetBackGroundMode)(bBackGroundMode);
}
/**
 * UNZIP32.DLL ̓쒆ɃJ[\\郂[hۂ𓾂܂B
 */
BOOL WINAPI UnZipGetCursorMode(VOID)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipGetCursorMode)();
}
/**
 * UNZIP32.DLL ̓쒆ɃJ[\\郂[hۂݒ肵܂B
 * FALSE ɐݒ肵ꍇ́AUNZIP32.DLL ͂̃J[\
 * s܂B
 */
BOOL WINAPI UnZipSetCursorMode(const BOOL bCursorMode)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipSetCursorMode)(bCursorMode);
}
/**
 * J[\̉]x𓾂܂B
 * ƌ̂{̋@\łAUNZIP32.DLL ł͎̍ŐĂ
 * 悤ɊgĂ܂B
 */
WORD WINAPI UnZipGetCursorInterval(VOID)
{
	if (!initUnZip32()) {
		return -1;
	}
	return (*lpSevenZipGetCursorInterval)();
}
/**
 * J[\̉]xݒ肵܂B
 * AUNZIP32.DLL ̓쒆ɂ͕ύXł܂B
 */
BOOL WINAPI UnZipSetCursorInterval(const WORD wInterval)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipSetCursorInterval)(wInterval);
}
/**
 * w肳ꂽɃt@CɊi[Ăt@C𓾂܂B
 */
int WINAPI UnZipGetFileCount(LPCSTR szArcFile)
{
	if (!initUnZip32()) {
		return -1;
	}
	// szArcFileɁu"vtt@CnĂAv̂ŁA
	// OɃJbgB(LHUT32Ή)
	// 7-zip32.dlĺu"vtȂH
	CString strArcFile = szArcFile;
	strArcFile.TrimLeft("\"");
	strArcFile.TrimRight("\"");
	return (*lpSevenZipGetFileCount)(strArcFile);
}
/**
 * w肳ꂽ API  UNZIP32.DLL Ŏgp\ǂ𓾂܂B
 * AvP[V͖ړI̋@\iAPIjLł邩ǂAO
 * `FbN悤ɂĂB
 */
BOOL WINAPI UnZipQueryFunctionList(const int iFunction)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// 󋵂ɂēƎɕԂǂH
	// 7-zip32.dll̑SĂAPIΗǂ...B
	return (*lpSevenZipQueryFunctionList)(iFunction);
}
/**
 * wt@C UNZIP32.DLL ɗLȏɃt@CǂׁA
 * Lł΃I[vAӂ̐linhjԂ܂B
 * Ȍ̏Ƀt@Cւ̃ANZX͂̃nhłȂ܂B
 * ANZXI鎞 UnZipCloseArchive ֐Ă΂Ȃ
 * Ȃ܂B
 */
HARC WINAPI UnZipOpenArchive(const HWND hWnd, LPCSTR szFileName, const DWORD dwMode)
{
	if (!initUnZip32()) {
		return NULL;
	}
	// szFileNameɁu"vtt@CnĂAv̂ŁA
	// OɃJbgB(LHUT32Ή)
	// 7-zip32.dlĺu"vtȂH
	// ̃t@CnAvɂ͂グ...B
	CString strFileName = szFileName;
	strFileName.TrimLeft("\"");
	strFileName.TrimRight("\"");
	return (*lpSevenZipOpenArchive)(hWnd, strFileName, 0);
}
/**
 * UnZipOpenArchive() Ŋtnh܂B
 */
int WINAPI UnZipCloseArchive(HARC harc)
{
	if (!initUnZip32()) {
		return -1;
	}
	return (*lpSevenZipCloseArchive)(harc);
}
/**
 * ŏ̊i[t@C̏𓾂܂B
 */
int WINAPI UnZipFindFirst(HARC harc,LPCSTR szWildName,INDIVIDUALINFO *lpSubInfo)
{
	if (!initUnZip32()) {
		return -1;
	}
	CString strWildName = szWildName;
	if (strWildName.Compare("*.*") == 0) {
		strWildName = "*";
	}
	int iResult = (*lpSevenZipFindFirst)(harc, strWildName, lpSubInfo);
	CString strFileName = lpSubInfo->szFileName ; 
	strFileName.Replace("\\", "/");
	_tcscpy(lpSubInfo->szFileName, strFileName);

	CString strMode = lpSubInfo->szMode;
	if (strMode.Compare("Store") == 0) {
		strMode = "Stored";
		_tcscpy(lpSubInfo->szMode, strMode);
	}

	lpSubInfo->wRatio = UnZipGetRatio(harc);

	return iResult;
}
/**
 * O UnZipFindFirst() ܂ UnZipFindNext() ̎̊i[t@C
 * 𓾂܂B
 */
int WINAPI UnZipFindNext(HARC harc,INDIVIDUALINFO *lpSubInfo)
{
	if (!initUnZip32()) {
		return -1;
	}
	int iResult = (*lpSevenZipFindNext)(harc, lpSubInfo);
	CString strFileName = lpSubInfo->szFileName ; 
	strFileName.Replace("\\", "/");
	_tcscpy(lpSubInfo->szFileName , strFileName);

	CString strMode = lpSubInfo->szMode;
	if (strMode.Compare("Store") == 0) {
		strMode = "Stored";
		_tcscpy(lpSubInfo->szMode, strMode);
	}

	lpSubInfo->wRatio = UnZipGetRatio(harc);

	return iResult;
}
/**
 * w肳ꂽt@C𓀂܂B
 */
int WINAPI UnZipExtract(HARC harc,LPCSTR szFileName,LPCSTR szDirName,DWORD dwMode)
{
	// Ɏs
	return 1;
}
/**
 * Ƀt@C𓾂܂B
 */
int WINAPI UnZipGetArcFileName(HARC harc,LPSTR lpBuffer,const int nSize)
{
	if (!initUnZip32()) {
		return -1;
	}
	return (*lpSevenZipGetArcFileName)(harc, lpBuffer, nSize);
}
/**
 * Ƀt@C̃TCY𓾂܂B
 */
DWORD WINAPI UnZipGetArcFileSize(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	return (*lpSevenZipGetArcFileSize)(harc);
}
/**
 * _܂ł̌iUnZipFindFirst()  UnZipFindNext() j
 * }b`t@Ći𓀌́jTCY̍v𓾂܂B
 * UnZipFindNext() ̌Ił́AɃt@Č
 * vSt@C̍vlƂȂ܂B
 */
DWORD WINAPI UnZipGetArcOriginalSize(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	return (*lpSevenZipGetArcOriginalSize)(harc);
}
/**
 * Ƀ}b`t@C̈kTCY̍v𓾂܂B
 * ̑ڍׂ UnZipGetArcOriginalSize() ɏ܂B
 */
DWORD WINAPI UnZipGetArcCompressedSize(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	return (*lpSevenZipGetArcCompressedSize)(harc);
}
/**
 * Ƀ}b`t@C̑Ŝ̈k𓾂܂B
 * ̑ڍׂ UnZipGetArcOriginalSize() ɏ܂B
 */
WORD WINAPI UnZipGetArcRatio(HARC harc)
{
	if (!initUnZip32()) {
		return (WORD)-1;
	}
//	return SevenZipGetArcRatio(harc);
	// IWiłRatióADLLratioƂ͈ႢA
	// ukČTCYvɑ΂郌[gB
	// Ȃ̂ŁAɈkĂt@CɊւẮA
	// }CiXɂȂ\邪AԋplWORDȂ̂
	// dlIɖ肪邪Aɏ[ɕyĂ܂݂
	// ǂ悤Ȃ...B
	// IWił̍҂̏clist.cratio\bh
	// ݂̑Ă̂ŁÃWbNgāA
	// IWiłƑSlԂ悤ɂB
	DWORD dwOriginalSize = (*lpSevenZipGetArcOriginalSize)(harc);
	DWORD dwCompressedSize = (*lpSevenZipGetArcCompressedSize)(harc);

	int iResult = ratio(dwOriginalSize, dwCompressedSize);
	if (iResult < 0) {
		iResult = 0;
	}
	return (WORD)iResult;
}
/**
 * Ƀt@C̓t𓾂܂B
 */
WORD WINAPI UnZipGetArcDate(HARC harc)
{
	if (!initUnZip32()) {
		return (WORD)-1;
	}
	return (*lpSevenZipGetArcDate)(harc);
}
/**
 * Ƀt@C̎𓾂܂B
 */
WORD WINAPI UnZipGetArcTime(HARC harc)
{
	if (!initUnZip32()) {
		return (WORD)-1;
	}
	return (*lpSevenZipGetArcTime)(harc);
}
/**
 * Ƀt@C쐬Ɏgpꂽnr̎ނ𓾂܂B
 */
UINT WINAPI UnZipGetArcOSType(HARC harc)
{
	if (!initUnZip32()) {
		return (UINT)-1;
	}
	return (*lpSevenZipGetArcOSType)(harc);
}
/**
 * Ƀt@Cȉ𓀃t@Cǂ𒲂ׂ܂B
 */
int WINAPI UnZipIsSFXFile(HARC harc)
{
	if (!initUnZip32()) {
		return -1;
	}
	return (*lpSevenZipIsSFXFile)(harc);
}
/**
 * i[t@C̃t@C𓾂܂B
 */
int WINAPI UnZipGetFileName(HARC harc, LPSTR lpBuffer, const int nSize)
{
	if (!initUnZip32()) {
		return -1;
	}
	// fBNg̋؂蕶IWił́u/vgpB
	// 7-zip32.dlĺu\vԂĂ̂ŁAAvP[V
	// Ȃ悤ɕϊB
	int iResult = (*lpSevenZipGetFileName)(harc, lpBuffer, nSize);
	CString strFileName = lpBuffer;
	strFileName.Replace("\\", "/");
	_tcscpy(lpBuffer, strFileName);
	return iResult;
}
/**
 * i[t@Ći𓀌́jTCY𓾂܂B
 */
DWORD WINAPI UnZipGetOriginalSize(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	return (*lpSevenZipGetOriginalSize)(harc);
}
/**
 * i[t@C̈kTCY𓾂܂B
 */
DWORD WINAPI UnZipGetCompressedSize(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	return (*lpSevenZipGetCompressedSize)(harc);
}
/**
 * i[t@C̈k𓾂܂B
 */
WORD WINAPI UnZipGetRatio(HARC harc)
{
	if (!initUnZip32()) {
		return (WORD)-1;
	}
//	return SevenZipGetRatio(harc);
	// UnZipGetArcRatio\bh̃RgQ
	DWORD dwOriginalSize = (*lpSevenZipGetOriginalSize)(harc);
	DWORD dwCompressedSize = (*lpSevenZipGetCompressedSize)(harc);

	int iResult = ratio(dwOriginalSize, dwCompressedSize);
	if (iResult < 0) {
		iResult = 0;
	}
	return (WORD)iResult;
}
/**
 * i[t@C̓t𓾂܂B
 */
WORD WINAPI UnZipGetDate(HARC harc)
{
	if (!initUnZip32()) {
		return (WORD)-1;
	}
	return (*lpSevenZipGetDate)(harc);
}
/**
 * i[t@C̎𓾂܂B
 */
WORD WINAPI UnZipGetTime(HARC harc)
{
	if (!initUnZip32()) {
		return (WORD)-1;
	}
	return (*lpSevenZipGetTime)(harc);
}
/**
 * i[t@C̍ŏIXV𓾂܂B
 */
DWORD WINAPI UnZipGetWriteTime(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	return (*lpSevenZipGetWriteTime)(harc);
}
/**
 * i[t@C̍쐬𓾂܂B
 */
DWORD WINAPI UnZipGetCreateTime(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	// 7-zip32.dllɂ͊YAPIB
//	return SevenZipGetCreateTime(harc);
	return (*lpSevenZipGetWriteTime)(harc);
}
/**
 * i[t@C̎QƓ𓾂܂B
 */
DWORD WINAPI UnZipGetAccessTime(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	// 7-zip32.dllɂ͊YAPIB
//	return SevenZipGetAccessTime(harc);
	return (*lpSevenZipGetWriteTime)(harc);
}
/**
 * i[t@C̃`FbNR[hibqb`FbNTj𓾂܂B
 */
DWORD WINAPI UnZipGetCRC(HARC harc)
{
	if (!initUnZip32()) {
		return (DWORD)-1;
	}
	return (*lpSevenZipGetCRC)(harc);
}
/**
 * i[t@C̑𓾂܂B
 */
int WINAPI UnZipGetAttribute(HARC harc)
{
	if (!initUnZip32()) {
		return -1;
	}
	return (*lpSevenZipGetAttribute)(harc);
}
/**
 * i[t@C쐬ꂽnr𓾂܂B
 */
UINT WINAPI UnZipGetOSType(HARC harc)
{
	if (!initUnZip32()) {
		return (UINT)-1;
	}
	return (*lpSevenZipGetOSType)(harc);
}
/**
 * i[t@C̈k@𓾂܂B
 */
int WINAPI UnZipGetMethod(HARC harc,LPSTR lpBuffer,const int nSize)
{
	if (!initUnZip32()) {
		return -1;
	}
	return (*lpSevenZipGetMethod)(harc, lpBuffer, nSize);
}
/**
 * obt@։𓀂܂B
 */
//int WINAPI UnZipExtractMem(const HWND hWnd, LPCSTR szCmdLine,
//						   LPBYTE szBuffer, const DWORD dwSize, time_t *lpTime,
//						   LPWORD lpwAttr, LPDWORD lpdwWriteSize)
//{
//	// 7-zip32.dllɂ͊YAPIB
//	return 1;
//}
/**
 * UNZIP32.DLL ̃bZ[W̑MEBhEݒ肵܂B
 * UNZIP32.DLL ͂Ŏw肳ꂽEBhEɉ𓀏󋵓m点
 * bZ[W𑗐M܂B
 */
BOOL WINAPI UnZipSetOwnerWindow(const HWND hwnd)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipSetOwnerWindow)(hwnd);
}
/**
 * UnZipSetOwnerWindow() Őݒ肵EBhE̐ݒ܂B
 */
BOOL WINAPI UnZipClearOwnerWindow(VOID)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipClearOwnerWindow)();
}
/**
 * UNZIP32.DLL ̉𓀏󋵂󂯎邽߂̃R[obN֐̎ws
 * ܂BlpArcProc  NULL w肷 hWnd Ŏw肵EBhE
 *  bZ[W𑗏o܂iUnZipSetOwnerWindow(hWnd)ƓjB
 */
BOOL WINAPI UnZipSetOwnerWindowEx(HWND hWnd, LPARCHIVERPROC lpArcProc)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipSetOwnerWindowEx)(hWnd, lpArcProc);
}
/**
 * UnZipSetOwnerWindowEx() Őݒ肵EBhE̐ݒ܂B
 */
BOOL WINAPI UnZipKillOwnerWindowEx(HWND hWnd)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	return (*lpSevenZipKillOwnerWindowEx)(hWnd);
}
/**
 *
 */
BOOL WINAPI UnZipGetArcCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetArcCreateTimeEx)(_harc, _lpftCreationTime);
}
/**
 *
 */
BOOL WINAPI UnZipGetArcAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetArcAccessTimeEx)(_harc, _lpftLastAccessTime);
}
/**
 *
 */
BOOL WINAPI UnZipGetArcWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetArcWriteTimeEx)(_harc, _lpftLastWriteTime);
}
/**
 *
 */
BOOL WINAPI UnZipGetArcFileSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetArcFileSizeEx)(_harc, _lpllSize);
}
/**
 *
 */
BOOL WINAPI UnZipGetArcOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetArcOriginalSizeEx)(_harc, _lpllSize);
}
/**
 *
 */
BOOL WINAPI UnZipGetArcCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetArcCompressedSizeEx)(_harc, _lpllSize);
}
/**
 *
 */
BOOL WINAPI UnZipGetOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetOriginalSizeEx)(_harc, _lpllSize);
}
/**
 *
 */
BOOL WINAPI UnZipGetCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	if (!initUnZip32()) {
		return FALSE;
	}
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
	return (*lpSevenZipGetCompressedSizeEx)(_harc, _lpllSize);
}
/**
 *
 */
WORD WINAPI UnZipGetSubVersion()
{
	// UnZip32.DLLɂ͖A7-zip32.DLLɂ͂API
//	return SevenZipGetSubVersion();
	return UNZIP32_SUB_VERSION;
}
/**
 *
 */
int WINAPI UnZipCommandLine(HWND hWnd,HINSTANCE hInst,LPCSTR szCmdLine,DWORD nCmdShow)
{
	// UnZip32.DLLɂ邪A7-zip32.DLLɂ͖API
	// Ɏs
	return 1;
}
/**
 *
 */
int WINAPI UnZipAdd(HARC harc,LPSTR szFileName,DWORD dwMode)
{
	// UnZip32.DLLɂ邪A7-zip32.DLLɂ͖API
	// Ɏs
	return 1;
}
/**
 *
 */
int WINAPI UnZipMove(HARC harc,LPSTR szFileName,DWORD dwMode)
{
	// UnZip32.DLLɂ邪A7-zip32.DLLɂ͖API
	// Ɏs
	return 1;
}
/**
 *
 */
int WINAPI UnZipDelete(HARC harc,LPSTR szFileName,DWORD dwMode)
{
	// UnZip32.DLLɂ邪A7-zip32.DLLɂ͖API
	// Ɏs
	return 1;
}
/********************/
/* Function ratio() */    /* also used by ZipInfo routines */
/********************/
// list.c̃Rsy
int ratio(unsigned long uc, unsigned long c)
{
    long denom;

    if (uc == 0)
        return 0;
    if (uc > 2000000L) {    /* risk signed overflow if multiply numerator */
        denom = uc / 1000L;
        return ((uc >= c) ?
            (int) ((uc-c + (denom>>1)) / denom) :
          -((int) ((c-uc + (denom>>1)) / denom)));
    } else {             /* ^^^^^^^^ rounding */
        denom = uc;
        return ((uc >= c) ?
            (int) ((1000L*(uc-c) + (denom>>1)) / denom) :
          -((int) ((1000L*(c-uc) + (denom>>1)) / denom)));
    }                            /* ^^^^^^^^ rounding */
}
