/*
	Utility functions, classes for Tar32.dll
		by Yoshioka Tsuneo(QWF00133@nifty.ne.jp)
*/
/*	
	̃t@C̗pF
		̃\[Xt@C̗p͈؂܂B
		\[ẌꕔASpA񏤗pȂǖړI
		Ȃ̃vOŎRɎgpł܂B
		pubNEhCE\tgEFAƓlɈ܂B
	
	vO}̗v](ł͂܂)F
		\[XɉPׂ_΂m点B
		\[XR[hɃoOꍇ͕񍐂ĂB
		Ȃǂ܂狳ĂB
		fГIȏł\łB
		̃t@C𗘗pꍇ͂ȂׂĂB
*/
/*
	LICENSE of this file:
		There is no restriction for using this file.
		You can use this file in your software for any purpose.
		In other words, you can use this file as Public Domain Software.

	RECOMMENDATION for Programmer(not restriction):
		If you find points to improve code, please report me.
		If you find bug in source code, please report me.
		If you fixed bug, please teach me.
		I want any trivial information.
		If you use this file, please report me.
*/

#pragma once

class CTar32Exception{
public:
	CTar32Exception(const char *str, int code){
		m_str = str;
		m_code = code;
	};
	std::string m_str;
	int m_code;
};

/* Tar32.DLL Global Critical Section */
void Tar32InitializeCriticalSection();
void Tar32DeleteCriticalSection();
void Tar32EnterCriticalSection();
void Tar32LeaveCriticalSection();


// time_t to CommonArchive-Time(?) converter
WORD GetARCDate(time_t ti);
WORD GetARCTime(time_t ti);
DWORD GetARCAttribute(int st_mode);
void GetARCAttribute(int st_mode, char *buf, int buflen);
bool GetARCMethod(int archive_type, char *buf, int buf_len);

// convert time_t(64bit) to FILETIME
void TimetToFileTime(time_t t, LPFILETIME pft);
