// wincur.cpp - Windows Cursor Control Class
//
// Copyright (C) 1999 Hiroyuki Shimada. All rights reserved.

#include "wincur.h"

namespace shimaden {

TWinCursor::TWinCursor(HWND hwnd, HINSTANCE hinst, bool recover)
	: f_hwnd(hwnd), f_hinst(hinst), f_recover(recover)
// 
//     hwnd   : EBhEEnh
//     hinst  : AvP[VECX^X̃nh
//              ̈ӖɂĂ LoadCursor WIN32 API ̃wvQƂ̂
//     recover: fXgN^sɁAJ[\Ԃɖ߂ǂ
// ߂l
//     Ȃ
{
	f_hCurs = 0;
}

TWinCursor::~TWinCursor()
{
	if(f_hCurs) {
		if(f_recover) {
			::SetClassLong(f_hwnd, GCL_HCURSOR,
				reinterpret_cast<LONG>(f_hCurs));
		}
	}
}

HCURSOR TWinCursor::SetCursor(LPCTSTR cursor)
// J[\ cursor ɕύX
// 
//     cursor: J[\܂̓J[\E\[Xʎq
//             ̈Ӗ LoadCursor WIN32 API ̃wvQƂ̂
// ߂l
//     s: 0
//     : ȑÕJ[\̃nh
{
	HCURSOR hCurs;
	HCURSOR ret;

	hCurs = ::LoadCursor(f_hinst, cursor); // J[\̃nh[h
	if(hCurs) {
		if(f_hCurs == 0)
			f_hCurs = hCurs;
		ret = reinterpret_cast<HCURSOR>(::SetClassLong(f_hwnd, GCL_HCURSOR,
			reinterpret_cast<LONG>(hCurs)));
	} else {
		ret = 0;
	}

	return ret;
}

HCURSOR TWinCursor::GetCursor()
// ݂̃J[\̃nhԂ
// ߂l
//     s: 0
//     : ݂̃J[\̃nh
{
	return reinterpret_cast<HCURSOR>(::GetClassLong(f_hwnd, GCL_HCURSOR));
}


} // namespace shimaden
