#include "ai_8.h"

unsigned char	encode_8[]= {
	0x23, 0x25, 0x26, 0x27, 0x29, 0x2b, 0x2c, 0x3f,
	0x2f, 0x32, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
	0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x41, 0x42, 0x43,
	0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4b, 0x4c,
	0x4e, 0x4f, 0x52, 0x54, 0x55, 0x56, 0x57, 0x58,
	0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x61, 0x62,
	0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a,
	0x6b, 0x6c, 0x6d, 0x6e, 0x70, 0x71, 0x72, 0x73,
	0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7c, 0xa1,
	0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9,
	0xaa, 0xab, 0xac, 0xae, 0xaf, 0xb0, 0xb1, 0xb2,
	0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb,
	0xbc, 0xbd, 0xbe, 0xc0, 0xc1, 0xc2, 0xc3, 0xc4,
	0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc,
	0xce, 0xcf, 0xd0, 0xd1, 0xd2, 0xd4, 0xd5, 0xd6,
	0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde
};

unsigned char	fstchar_8[]= {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x00, 0xff, 0x01, 0x02, 0x03,
	0xff, 0x04, 0xff, 0x05, 0x06, 0xff, 0xff, 0x08,
	0xff, 0xff, 0x09, 0xff, 0x0a, 0x0b, 0x0c, 0x0d,
	0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x07,
	0xff, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b,
	0x1c, 0x1d, 0xff, 0x1e, 0x1f, 0xff, 0x20, 0x21,
	0xff, 0xff, 0x22, 0xff, 0x23, 0x24, 0x25, 0x26,
	0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0xff,
	0xff, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34,
	0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0xff,
	0x3c, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0xff,
	0x43, 0x44, 0x45, 0xff, 0x46, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d,
	0x4e, 0x4f, 0x50, 0x51, 0x52, 0xff, 0x53, 0x54,
	0x55, 0x56, 0x57, 0xff, 0x58, 0x59, 0x5a, 0x5b,
	0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0xff,
	0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a,
	0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0xff, 0x70, 0x71,
	0x72, 0x73, 0x74, 0xff, 0x75, 0x76, 0x77, 0x78,
	0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

unsigned int
encline_8(unsigned char *str, unsigned char *ptr, unsigned int len)
{
	unsigned int	i;

	for(len += (unsigned int)ptr, ptr--, i= 0; (unsigned int)ptr < len; i++ ) {
		unsigned int	code, bit;

		switch( bit = i & 7 ) {
		case 0:
			code= *++ptr;
			break;
		default:
			code = *ptr >> (8-bit);
			code|= *++ptr << bit;
			break;
		case 7:
			code= *ptr >> 1;
		}
		*str++= encode_8[code&0x7f];
	}
	*str= '\0';

	return 0; /* ̒l */
}

unsigned int
decline_8(unsigned char *buf, unsigned char *ptr, unsigned int len)
{
	unsigned int	i;
	unsigned char	*str= buf-1;
	for( i= 0 ; i< len ; i++ ){
		unsigned int	code, bit;
		if( (code= fstchar_8[*ptr++]) != 0xff ){
			switch( bit= i&7 ){
			case 0:
				*++str= code;
				break;
			default:
				*str++ |= code<<(8-bit);
				*str    = code>>bit;
				break;
			case 7:
				*str |= code<<1;
			}
		}else
			return	0;
	}
	return	str-buf;
}
