///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// U_SYSTEM.CPP = Utility group / SYSTEM utility functions.
///////////////////////////////////////////////////////////////////////////////

#include	"u_util.h"

//get_exec_dir split directory from Meltice's full path.
char *get_exec_dir(char *path, int pathlen)
{
	char *p, *r;
	static char lpstrAppName[MAX_PATH]; // for argv[0].

	GetModuleFileName(NULL, lpstrAppName, MAX_PATH);
	p = lpstrAppName;
	r = lpstrAppName + MAX_PATH - 1;    // argv[0] last char.
	while(*p != '\0'){
		if(IsDBCSLeadByte((BYTE)*p) == TRUE){
			p++;
		}else if(*p == '\\'){
			r = p;
		}
		p++;
	}
	*r = '\0';

	lstrcpyn( path, lpstrAppName, pathlen );
	path_add_backslash(path);
	return path;
}

//-----------------------------------------------------------------------------
// void get_special_folder_path
//
//  outdir  : SpecialFolder Path. (need MAX_PATH length.)
//  nFolder : SpecialFolder Name. 
//				CSIDL_DESKTOP   -> desktop
//				CSIDL_PERSONAL  -> My Documents
char *get_win_special_folder_path(char *outdir, const int nFolder)
{
	*outdir = '\0';
	ITEMIDLIST *rootiil;
	char SpecialFolder[MAX_PATH];
	SHGetSpecialFolderLocation(NULL,nFolder,&rootiil); //for DESKTOP...
	if(!rootiil){ *outdir='\0';	return outdir;}
	SHGetPathFromIDList(rootiil,SpecialFolder);

	lstrcpyn(outdir, SpecialFolder, MAX_PATH);
	path_add_backslash(outdir);
	return outdir;
}


//-----------------------------------------------------------------------------
// get_long_path_name_95( const char *short_path, char *long_path)
//
//  Convert filename / short_path -> long_path.
//  
bool get_long_path_name_95( const char *short_path, char *long_path)
{
	WCHAR			wcshort_path[MAX_PATH+1];
	ULONG			chEaten;
	ITEMIDLIST		*pidl;
	IShellFolder	*pshf;
	IMalloc			*pMalloc;

	if ( NOERROR == SHGetMalloc( &pMalloc ) )
	{
		if ( NOERROR == SHGetDesktopFolder( &pshf ) )
		{
			MultiByteToWideChar( CP_ACP, 0, short_path, -1, wcshort_path, MAX_PATH ); 
			if ( NOERROR == pshf->ParseDisplayName( NULL, NULL, wcshort_path, &chEaten, &pidl, NULL ) ) // get pidl
			{
				if ( SHGetPathFromIDList( pidl, long_path ) ) // get path from pidl
				{
					pMalloc->Free( pidl );
					pshf->Release();
					pMalloc->Release();
					return TRUE; // success
				}
				pMalloc->Free( pidl );
			}
			pshf->Release();
		}
		pMalloc->Release();
	}
	 return FALSE; // fail.
}



// original: http://www.kh.rim.or.jp/~maruoka/Builder/TIPS/tips32.html
// 2000/01/26.
//////////////////////////////////////////////////////////////////////////
//SHBrowseForFolder() at BrowseFolder() internal use this func.
int CALLBACK CallbackProc(HWND Wnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	char Path[_MAX_PATH];

	//code
	*Path = '\0';
	switch (uMsg)
	{
	  case BFFM_SELCHANGED:
		if(SHGetPathFromIDList((LPITEMIDLIST)lParam, Path)){
			SendMessage(Wnd, BFFM_SETSTATUSTEXT, (LONG)TRUE, (LONG)Path);
		}
		break;
	  case BFFM_INITIALIZED: //init.
		SendMessage(Wnd, BFFM_SETSELECTION, (LONG)TRUE, (LONG)lpData);
		SendMessage(Wnd, BFFM_SETSTATUSTEXT, (LONG)TRUE, (LONG)lpData);
		break;
	}
	return 0;
}


//////////////////////////////////////////////////////////////////////////
// Folder Select Dialog.
// (default:desktop)
//
// original: http://www.kh.rim.or.jp/~maruoka/Builder/TIPS/tips32.html
int browse_folder(HWND hWnd, char* Directory, char* Prompt)
{
	IMalloc*		ppmem;
	LPSTR			lpbuffer;
	LPCITEMIDLIST	pidlBrowse;
	BROWSEINFO		BrowseInfo;
	HWND			ActiveWindow;
	int				Result = FALSE;

	path_remove_backslash(Directory);
	
	if ( SHGetMalloc(&ppmem) == NOERROR )
	{
		lpbuffer = (char*)ppmem->Alloc(MAX_PATH);
		if ( lpbuffer == NULL)
		{
			ppmem->Release();
			return FALSE;
		}

		//not exist dir then choice desktop.
		DWORD fa;
		fa = GetFileAttributes(Directory);
		if( fa & FILE_ATTRIBUTE_DIRECTORY)
		{
			; //Folder, No exec.
		}else{ //not Folder.
			get_win_special_folder_path(Directory, CSIDL_DESKTOP);
		}

		// Set BrowseInfo
		BrowseInfo.hwndOwner   = hWnd;
		BrowseInfo.pidlRoot        = NULL;
		BrowseInfo.pszDisplayName  = lpbuffer;
		BrowseInfo.lpszTitle       = Prompt;
		BrowseInfo.ulFlags         = BIF_RETURNONLYFSDIRS | BIF_RETURNFSANCESTORS | BIF_DONTGOBELOWDOMAIN| BIF_STATUSTEXT;
		BrowseInfo.lpfn            = (BFFCALLBACK)CallbackProc;
		BrowseInfo.lParam          = (LONG)Directory;
		ActiveWindow = GetActiveWindow();

		pidlBrowse = SHBrowseForFolder(&BrowseInfo);//point :-)

		SetActiveWindow(ActiveWindow);
		if (pidlBrowse != NULL)
		{
			if ( SHGetPathFromIDList(pidlBrowse, lpbuffer) == TRUE)
			{
				lstrcpyn( Directory, lpbuffer, MAX_PATH);
				Result = TRUE;
			} else {
				*Directory = '\0';
			}
			ppmem->Free((void*)pidlBrowse);
		}
		ppmem->Free(lpbuffer);
	}
	ppmem->Release();

	path_add_backslash(Directory);

	return Result;
}


//-----------------------------------------------------------------------------
// output_log function.
//
// logfile <- "MELTICE.LOG" ,etc... (to Desktop folder)
// logline <- save log.
//
void output_log(const char *logfile, const char *logline)
{
	HANDLE hnd; 
	unsigned long lpdw;

	char *logpath = new char[MAX_PATH];
	char *str = new char[lstrlen(logline)+8];
	lstrcpy(str,logline);
	lstrcat(str,"\r\n");
	
	get_win_special_folder_path(logpath, CSIDL_DESKTOP);
	path_add_backslash(logpath);
	lstrcat(logpath,logfile);
	hnd = CreateFile(logpath,GENERIC_WRITE,FILE_SHARE_WRITE,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hnd != INVALID_HANDLE_VALUE ){
		SetFilePointer(hnd,0,NULL,FILE_END);
		WriteFile(hnd,str,lstrlen(str),&lpdw,NULL);
		CloseHandle(hnd);
	}

	delete [] str;
	delete [] logpath;
}
