///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// D_RECIPE.CPP = Do group / RECIPE -compress and decompress management-
///////////////////////////////////////////////////////////////////////////////

#include	<windows.h>
#include	"..\cfg\c_config.h"
#include	".\d_do.h"
#include	"..\..\utl\u_util.h"

#include	".\di_doit.h" // for jack32.dll @ mydestdir();


#ifdef	MELTICE
//default output path(outpath) + archive filename(infile)
//     ===> final output path! (for unpack)
static void mkdestdir(char *outpath, const char *infile)
{
	if(ardll_check_archive(infile) == MODE_JAK) return;
	
	char *pathbuf = new char[MAX_PATH+1];

	path_add_backslash(outpath);
	//---vvv--- C:\temp\archiv~1.zip -> C:\temp\archive100.zip
	get_long_path_name_95(infile, pathbuf);
	//---vvv--- C:\temp\archive100.zip -> archive100.zip
	lstrcpyn(pathbuf, get_filename(pathbuf), MAX_PATH);
	//---vvv--- archive100.zip -> archive100
	//          archive100.tar.gz -> archive100 
	cut_exp_from_filename(pathbuf);
	//          (for tar.gz and tar.bz2)
	if(lstrlen(pathbuf)>4)
	{
		char *subexpbuf = new char[lstrlen(pathbuf)+1]; // for ***[.tar].gz
		lstrcpy(subexpbuf,pathbuf);
		if(lstrcmp(CharLower(subexpbuf+(lstrlen(subexpbuf)-4)),".tar")==0)
			cut_exp_from_filename(pathbuf); // ***.tar.??? -> ***.tar -> ***
		delete [] subexpbuf;
	}

	//---vvv--- archive100 -> archive (when enable optmdir settings)
	if( get_ncutdir(0) == true ) cut_num_from_noexp_filename(pathbuf);
	//---vvv--- "  archive  " -> "archive" (cut space code...)
	trim_from_filename(pathbuf);
	//---vvv--- disable double make folder(when enable optmdir settings)
	if( get_optmdir(0) == true )
	{
		if( chk_singledir(infile,NULL,0) == true) *pathbuf='\0';
	}
	//---vvv--- nomkdir=1 then "archive100" -> ""
	if( get_nomkdir(0) == true )
	{
		*pathbuf='\0';
	}

	lstrcat(outpath,pathbuf);
	path_add_backslash(outpath);

	delete [] pathbuf;
}

//for Unpack func...
static void recipe_unpack(const HWND hDlg, const char *filename)
{
	char *outpath = new char[MAX_PATH+1];

	if(get_samedir(0) == false) // unpack to destdir.
	{
		get_destdir(outpath, MAX_PATH, 0);
	}else{						//unpack to samedir.
		lstrcpyn(outpath, filename, MAX_PATH);
		get_dirname(outpath);
	}
	// Make Output Folder Path -Final- for unpack.
	mkdestdir(outpath, filename);

	////// Let's cooking! for melt -means unpack-.
	cook_melt(hDlg, filename,outpath);

	delete [] outpath;
}
#endif

//for pack func...
static void recipe_pack(const HWND hDlg, const char *filenames, const char *basedir)
{
	////// Let's cooking! for frost -means pack-.
	cook_frost(hDlg, filenames,basedir);
}

// Recipe - D_RECIPE.CPP main.
// return -> 0=Err. 1=UnPack 2=Pack.
// dropfile <- Filename for "File draged to dialog "
// dropfiles <- Filename for "ALLFILES draged to dialog "
int recipe(const HWND hDlg, const char *dropfile, const char *dropfiles)
{
	int i=1;
	int j;
	int ret=0;
	bool PackFlag=false; //for Pack.
	bool LoopFlag=true; // for DnD

	char *filename = new char[MAX_PATH+1];
	char *packfiles = new char[(MAX_PATH+1)*256]; *packfiles='\0';
	char *packbasedir= new char[(MAX_PATH+1)*256];*packbasedir='\0';


	if(dropfiles!=NULL) LoopFlag = false;
	
	while(LoopFlag)
	{
		if(__argc <= 1)
		{
			i++;
			lstrcpyn(filename, dropfile, MAX_PATH);
			LoopFlag=false;
		}else if(i < __argc){
			lstrcpyn(filename, __argv[i], MAX_PATH);
			i++;
		}else{
			break; //end while.
		}

		DWORD fa;
		fa = GetFileAttributes(filename);
		if(fa == 0xFFFFFFFF){ //Not Found...
			if(get_writelog()==true)
			{
				char *logbuf = new char[MAX_PATH * 5];
				wsprintf(logbuf, "\r\n%s : [NG] This file was not found.",filename);
#ifdef	MELTICE
				output_log("MELTICE.LOG",logbuf);
#endif
#ifdef	FROSTICE
				output_log("FROSTICE.LOG",logbuf);
#endif
				delete [] logbuf;
			}
			ret=0;
		}else if(fa & FILE_ATTRIBUTE_DIRECTORY){ //Folder.
			PackFlag=true;
			ret=2;
		}else{ // etc... (file?)
			char *buf=new char[MAX_PATH];
			lstrcpy(buf,filename);
#ifdef	MELTICE
		//////unpack code
			if( ispackexp(get_expname(buf)) == true )
			{
				ret=1;
				recipe_unpack(hDlg, filename);
		//////pack code ...?
			}else{ 
#endif
				ret=2;
				PackFlag=true;
#ifdef	MELTICE
			}
#endif
			delete [] buf;
		}
		if(i==2 && PackFlag==true) break;
	}
	//Filename operatefor Pack
	if(i==2 && PackFlag==true && dropfile==NULL && dropfiles == NULL) // 1 round only
	{
	/// BaseDir
		get_long_path_name_95(__argv[1], filename);
		lstrcat(packbasedir,"\"");
		lstrcat(packbasedir,get_dirname(filename));
		lstrcat(packbasedir,"\" ");
		

	/// PackFiles
		for(j=1; j< __argc; j++)
		{
			get_long_path_name_95(__argv[j], filename);
			lstrcat(packfiles,"\"");
			lstrcat(packfiles,get_filename(filename));
			if(GetFileAttributes(__argv[j])& FILE_ATTRIBUTE_DIRECTORY)
				lstrcat(packfiles,"\\*");
			lstrcat(packfiles,"\" ");
		}
		recipe_pack(hDlg, packfiles,packbasedir);
		ret = 2;
	}else if(dropfiles != NULL) // 1 round only
	{
		//Split string for recipe_pack..
		lstrcpy(packbasedir,dropfiles);
		for(j=1;j<=lstrlen(dropfiles)-1;j++)
		{
			if(*(packbasedir+j) == '\"')
			{
				*(packbasedir+j+1) = '\0';
				lstrcpy(packfiles,packbasedir+j+2);
				break;
			}
		}
		recipe_pack(hDlg, packfiles,packbasedir);
		ret = 2;
	}

	delete [] packbasedir;
	delete [] packfiles;
	delete [] filename;
	return ret;
}

