///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// D_COOKFL.CPP = Do group / COOK FiLe -for file processing-
///////////////////////////////////////////////////////////////////////////////

#include	<windows.h>
#include	<shlobj.h>

#include	".\di_doit.h"
#include	"..\cfg\c_config.h"
#include	"..\..\utl\u_util.h"

#include	"..\dlg\w_window.h" //Config Window Call (VerInfo.)

#ifdef	MELTICE

//File Header check for DLL (MXD easy check)
static bool check_dll_mxd(const char *FileName)
{
	char *fnbuf = new char[MAX_PATH];
	wsprintf(fnbuf,"%s",FileName);
	fnbuf = get_filename(fnbuf);
	fnbuf = get_expname(fnbuf);
	fnbuf = CharLower(fnbuf);

	if(lstrcmp("mxd",fnbuf) != 0 )
		return false; //exp chk.

	HANDLE chkmxdfil = CreateFile( FileName, GENERIC_READ, FILE_SHARE_READ,
		NULL, OPEN_EXISTING, NULL, NULL );
	if(chkmxdfil == INVALID_HANDLE_VALUE) return false; //Can't open.
	char buf[6]; DWORD dwDummy;
	ReadFile(chkmxdfil, buf, 3, &dwDummy, NULL); buf[2]='\0';
	CloseHandle(chkmxdfil);


	if(lstrcmp("MZ",buf) == 0 ){ //header check ok!
		return true;
	}else{
		return false;
	}
}

static int check_archive(const char *filename)
{
	int mode;

	//Common archiver project DLL Use setting.
	if(get_noardll(0)==false) 
		mode = ardll_check_archive(filename);
	//Common archiver's project not use! (for debug)
	else mode = 0;

	if(mode == 0){
		mode = clmpi_check_archive(filename);
		if(mode != 0) mode += MXDMODE;
		//can't process archiver dll and mxd... (DLL?)
		else if(check_dll_mxd(filename) == true) mode = MODE_DLL;
	}

	char *logbuf = new char[MAX_PATH * 5];
	if(get_writelog()==true && mode != 0)
	{
		char expbuf[10][20] = {"","LHa archive","Zip archive","Zip/7z archive","MS Cabinet archive","Tape ARchive (TAR)","Gza and Bza archive","YZ1 archive","jack form ripped"};
		if(mode <= 8 ) wsprintf(logbuf, "\r\n%s : [OK] This file has been recognized to be %s.",filename, expbuf[mode]);
		else wsprintf(logbuf,"\r\n%s : [OK] This file has recognized form by mxd plug-in.",filename);
		output_log("MELTICE.LOG",logbuf);
	}else{
		wsprintf(logbuf, "\r\n%s : [NG] This file has not been recognized.",filename);
		if(get_writelog()==true)
			output_log("MELTICE.LOG",logbuf);
	}
	delete [] logbuf;

	return mode;
}

bool chk_singledir(const char *filename, char *sgdir, int sdlen)
{
	if(ardll_check_archive_in_singledir(filename,sgdir,sdlen) == true)
	{
		return true;
	}else if( clmpi_check_archive_in_singledir(filename,sgdir,sdlen) == true)
	{
		return true;
	}else{
		return false;
	}
}

//////////////////////////////////////////////////////////////////////////
// Open Folder by Explorer/etc.
bool open_folder(const char *outputdir, int sw)
{
	if( sw !=0) return 0;

	DWORD fa;

	char *original_current_dir = new char[MAX_PATH*10];
	GetCurrentDirectory(MAX_PATH*10, original_current_dir);
	if(SetCurrentDirectory(outputdir) == false)
	{
		delete [] original_current_dir;
		return false;
	}
	SetCurrentDirectory(original_current_dir);
	delete [] original_current_dir;

	fa = GetFileAttributes(outputdir);
	if(fa & FILE_ATTRIBUTE_DIRECTORY){ //Folder.
		char *buf = new char[MAX_PATH*4+1];
		char *opdircmd = new char[MAX_PATH+1]; // Open Folder Path.
		char *opdiropt = new char[MAX_PATH+1]; // Open Folder Options.
		get_opdirex(opdircmd, MAX_PATH, sw);
		get_opdiropt(opdiropt, MAX_PATH, sw);
		wsprintf(buf,"%s \"%s\"", opdiropt, outputdir);

		//WinExec(buf, SW_SHOW);
		ShellExecute(NULL, "open", opdircmd, buf, outputdir, SW_SHOW);

		delete [] opdiropt;
		delete [] opdircmd;
		delete [] buf;
		return true;
	}else{
		//open error...
		return false;
	}
}

void cook_melt(const HWND hDlg, const char *filename, const char *outputdir)
{
	int lookfile = check_archive(filename);
	bool opendir_flag = false;
	bool delfile_flag = false;
	if (lookfile == MODE_NOT_SUPPORT) // Broken archive file or not support file.
	{
		return; // melt(uncompress) error.
	}else{
		if(lookfile == MODE_DLL)
		{
			w_mpicll_cnfdlg(hDlg, filename,0); // MXD Config. (VerInfo)
		}else if(lookfile > MXDMODE)	// MXD.
		{
			//noerr
			if( clmpi_melt(filename,outputdir,lookfile-MXDMODE) == true)
			{
				//noerr and OpenDir settings.
				if(get_opendir(0) == true)
				{
					opendir_flag = true;
				}

				//noerr and DelArFl settings
				if(get_delarfl(0) == true)
				{
					delfile_flag = true;
				}
			}
		}else{				 // Archiver DLL.
			int ret = ardll_melt(hDlg,filename,outputdir,lookfile);
			//noerr
			if( ret >= 0 && ret <= 0x8000)
			{
				//noerr and OpenDir settings.
				if(get_opendir(0) == true)
				{
					opendir_flag = true;
				}

				//noerr and DelArFl settings
				if(get_delarfl(0) == true)
				{
					delfile_flag = true;
				}
			}
		}

		if(opendir_flag == true)
		{
			//Optimized Dir disabled.
			if( get_optmdir(0) == false )
			{
				open_folder(outputdir, 0);
			//Optimized Dir enabled.
			}else{
				char *sgdir = new char[MAX_PATH+1];// Check SingleDir Buf.
				init_newchr(sgdir,MAX_PATH+1);		//sgdir init.
				if(chk_singledir(filename,sgdir,MAX_PATH) ==false)
				{
					open_folder(outputdir, 0);
				}else{
					char *opendir= new char[MAX_PATH+1]; 
					init_newchr(opendir,MAX_PATH+1);
					  lstrcpyn(opendir,outputdir,MAX_PATH);
					  path_add_backslash(opendir);
					  lstrcat(opendir,sgdir);
					  open_folder(opendir, 0);
					delete [] opendir;
				}
				delete [] sgdir;
			}
		}
		if(delfile_flag == true)
		{
			DeleteFile(filename);

			if(get_writelog()==true)
			{
				char *logbuf = new char[MAX_PATH * 5];
				wsprintf(logbuf, "\r\n%s : [Del] This file is deleted.",filename);
				output_log("MELTICE.LOG",logbuf);
				delete [] logbuf;
			}
		}
	}
}
#endif

void cook_frost(const HWND, const char *filenames, const char *basedir)
{
	clmpi_get_version(1); get_findmxd();//dummy!

	char *tmpbuf = new char[MAX_PATH];

//	MessageBox(0,tmpbuf,"Pack MXD (argv/drop) $$$",0);
	clmpi_frost(filenames, basedir,get_matchmxdnum(get_packmxd(tmpbuf)));
	delete [] tmpbuf;
}
