///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// DI_DOIT.H = DoIt group / declarations for prototype functions.
//          (DI_*****.CPP need this header file.)
///////////////////////////////////////////////////////////////////////////////

//----- for Common archiver's project DLL API ---------------------------------
//by UNLHA32.H by Micco.
#define FNAME_MAX32		512
typedef	HGLOBAL	HARC;
typedef struct {
	DWORD 			dwOriginalSize;		/* original file size */
 	DWORD 			dwCompressedSize;	/* packed file size  */
	DWORD			dwCRC;				/* check sum for packed file */
	UINT			uFlag;				/* processing result */
	UINT			uOSType;			/* OS (Win32, DOS,etc...) */
	WORD			wRatio;				/* Pack Ratio */
	WORD			wDate;				/* Date(DOS) for packed file */
	WORD 			wTime;				/* Time(DOS) for packed file */
	char			szFileName[FNAME_MAX32 + 1];	/* archive file name */
	char			dummy1[3];
	char			szAttribute[8];		/* attribute for packed file */
	char			szMode[8];			/* mode for packed file */
}	INDIVIDUALINFO, *LPINDIVIDUALINFO;


// for OpenArchive
/* MODE (for UnarjOpenArchive) */
#define M_INIT_FILE_USE			0x00000001L	/* use registry setting  */
#define M_REGARDLESS_INIT_FILE	0x00000002L	/* not use registry setting */
#define M_NO_BACKGROUND_MODE	0x00000004L	/* disable background execute */
#define M_NOT_USE_TIME_STAMP	0x00000008L
#define M_EXTRACT_REPLACE_FILE	0x00000010L
#define M_EXTRACT_NEW_FILE		0x00000020L
#define M_EXTRACT_UPDATE_FILE	0x00000040L
#define M_CHECK_ALL_PATH		0x00000100L	/* check fullpath */
#define M_CHECK_FILENAME_ONLY	0x00000200L	/* check filename only */
#define M_CHECK_DISK_SIZE		0x00000400L
#define M_REGARDLESS_DISK_SIZE	0x00000800L
#define M_USE_DRIVE_LETTER		0x00001000L	/* use drive name */
#define M_NOT_USE_DRIVE_LETTER	0x00002000L	/* not use drive name */
#define M_INQUIRE_DIRECTORY		0x00004000L
#define M_NOT_INQUIRE_DIRECTORY 0x00008000L
#define M_INQUIRE_WRITE			0x00010000L
#define M_NOT_INQUIRE_WRITE		0x00020000L
#define M_CHECK_READONLY		0x00040000L
#define M_REGARDLESS_READONLY	0x00080000L
#define M_REGARD_E_COMMAND		0x00100000L
#define M_REGARD_X_COMMAND		0x00200000L
#define M_ERROR_MESSAGE_ON		0x00400000L	/* enable error message */
#define M_ERROR_MESSAGE_OFF		0x00800000L	/* disable error message */
#define M_BAR_WINDOW_ON			0x01000000L
#define M_BAR_WINDOW_OFF		0x02000000L
#define M_CHECK_PATH			0x04000000L
#define M_RECOVERY_ON			0x08000000L /* broken header recovery */

#define M_MAKE_INDEX_FILE		0x10000000L
#define M_NOT_MAKE_INDEX_FILE	0x20000000L
#define EXTRACT_FOUND_FILE		0x40000000L	/* unpack for found file */
#define EXTRACT_NAMED_FILE		0x80000000L	/* unpack for named file */




//----- for Meltice.  ------------------------------------------------
#define MODE_NOT_SUPPORT	0
#define MODE_LZH	1
#define MODE_ZIP	2
#define MODE_7ZIP	3
#define MODE_CAB	4
#define MODE_TAR	5
#define MODE_BGA	6
#define MODE_YZ1	7
#define MODE_RAR	8
#define MODE_XAC	9
#define MODE_JAK	10

#define MXDMODE		100
#define MODE_DLL	10000

//-----------------------------------------------------------------------------
//for DI_ARDLL.CPP
extern int ardll_get_version(int mode);
extern int ardll_get_subversion(int mode);
extern int ardll_check_archive(const char *filename);
extern int ardll_melt(const HWND hDlg, const char *filename,const char *outputdir,int mode);
extern bool ardll_check_archive_in_singledir(const char *filename, char *singledir, int sdlen);
extern bool config_dialog(const HWND hDlg, int mode);

//-----------------------------------------------------------------------------
//for DI_CLMPI.CPP

extern int get_findmxd(void);
extern char *get_mxdfilename(char *filenamebuf,int mode);

extern int clmpi_get_version(int mode);
extern int clmpi_check_archive(const char *filename);
extern bool clmpi_check_archive_in_singledir	(const char *filename, char *singledir, int sdlen);
extern bool clmpi_melt(const char *filename,const char *outputdir,int mode);
extern bool clmpi_frost(const char *filenames,const char *basedir, int mode);
extern int get_matchmxdnum(const char *mxdname);


