///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// DI_CLMPI.CPP = DoIt group / CalL Meltice Plug-ins.
///////////////////////////////////////////////////////////////////////////////

#include 	<windows.h>
#include	<shlobj.h>
#include	".\di_doit.h"
#include	"..\..\utl\u_util.h"

#include	"..\cfg\c_config.h" // for only debug option "WriteLog"

//This Meltice use MXD Protocol Version.
#define 	MXD_PROTOCOL_VER	2000

// DLL for Meltice eXtending (= MPI/Meltice Plug-Ins) settings...

// MAX MXD Files = 8.
#define		SUPPORT_MXD_NUM	8
static HINSTANCE  hInstMxd[SUPPORT_MXD_NUM+1];
//dll chk...
static char dllname[SUPPORT_MXD_NUM+1][MAX_PATH];


//Mxd File Find...
// return num -> MXD Files (-1 = error, 0= none, 1...= 1-n.)
static bool NoFindMxdFile=false;
static int MaxMxdFiles = 0;

static int FindMxdFile(void)
{
	if(NoFindMxdFile==true) return -1;
	NoFindMxdFile=true; //
	char *buf = new char[MAX_PATH*4];
	int i=0;
	get_exec_dir(buf, MAX_PATH);
	wsprintf(buf,"%s*.mxd", buf);

	WIN32_FIND_DATA  *mxd_findfile = new WIN32_FIND_DATA;
	HANDLE	hFndfst = FindFirstFile(buf, mxd_findfile);
	if(  hFndfst!= INVALID_HANDLE_VALUE )
	{
		 i=1;wsprintf(dllname[i], "%s", (*mxd_findfile).cFileName);

		while(FindNextFile(hFndfst,mxd_findfile))
		{
			i++;
			wsprintf(dllname[i], "%s", (*mxd_findfile).cFileName);
			if( i >= SUPPORT_MXD_NUM ) break; //MXD_MAX!
			
		}
//		FindClose(mxd_findfile);
	}

	delete [] buf;
	return i;

}

// load MXD
//   return true  -> DLL load success!
//   return false -> DLL load failed.
static bool load_mxd(int mode)
{
	int iBuf = FindMxdFile();
	if( iBuf > 0 )	MaxMxdFiles = iBuf;

	if(mode <= 0) return false;
	hInstMxd[mode] =  LoadLibrary( dllname[mode] );
	if(hInstMxd[mode] == NULL) return false;
	return true;
}

static bool check_archive(const char * filename, int mode)
{
	if(mode <= 0) return false;

	typedef bool (WINAPI *PCHKARCFUNC)(const char *);

	if( load_mxd(mode) == true){
		PCHKARCFUNC ChkArc = (PCHKARCFUNC)GetProcAddress(hInstMxd[mode], "MxdCheckArchive");
		if(ChkArc != NULL && clmpi_get_version(mode) !=0 ) // API function ready...
		{
			return (*ChkArc)(filename);
		}
	}
	return false;
}

static bool check_archive_in_singledir
	(const char *filename, char *singledir, int sdlen, int mode)
{
	if(mode <= 0) return false;

	typedef bool (WINAPI *PCHKARCISDFUNC)(const char *, char *, int);

	if( load_mxd(mode) == true){
		PCHKARCISDFUNC ChkArc = (PCHKARCISDFUNC)GetProcAddress(hInstMxd[mode], "MxdCheckArchiveInSingleDir");
		if(ChkArc != NULL && clmpi_get_version(mode) !=0 ) // API function ready...
		{
			return (*ChkArc)(filename,singledir,sdlen);
		}
	}
	return false;
}

int clmpi_get_version(int mode)
{
	typedef int (WINAPI *PGETVERFUNC)();
	if(mode <= 0) return 0;

	if( load_mxd(mode) == true){
		PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstMxd[mode], "MxdGetVersion");
		PGETVERFUNC GetProtocolVer = (PGETVERFUNC)GetProcAddress(hInstMxd[mode], "MxdGetProtocolVersion");
		if(GetVer != NULL && GetProtocolVer != NULL) // API function ready...
		{
			if( (*GetProtocolVer)() == MXD_PROTOCOL_VER)
				return (int)(*GetVer)();
			else return 0;
		}
	}
	return 0;
}

int clmpi_check_archive(const char *filename)
{
	int iBuf = FindMxdFile();
	if( iBuf > 0 )	MaxMxdFiles = iBuf;
	if(MaxMxdFiles >= 1)
	{
		for (int i=1; i<= MaxMxdFiles; i++)
			if( check_archive(filename, i) == true) return i;
	}
	return 0;
}

bool clmpi_check_archive_in_singledir
	(const char *filename, char *singledir, int sdlen)
{
	int iBuf = FindMxdFile();
	if( iBuf > 0 )	MaxMxdFiles = iBuf;
	if(MaxMxdFiles >= 1)
	{
		for (int i=1; i< MaxMxdFiles; i++)
			if( check_archive_in_singledir(filename,singledir,sdlen, i) == true) return true;
	}
	return false;
}

bool clmpi_melt(const char *filename,const char *outputdir,int mode)
{
	if(mode <= 0) return false;
	bool ret;
	typedef bool (WINAPI *PARCRUNFUNC)(const char *,const char *);
	
	if( load_mxd(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstMxd[mode], "MxdUnpackArchive");
		if(ArcRun != NULL && clmpi_get_version(mode) !=0 ) // API function ready...
		{
			ret = (*ArcRun)(filename,outputdir);
			if(get_writelog()==true)
			{
				char *logbuf = new char[MAX_PATH * 5];
				if(ret == true)
					wsprintf(logbuf, "%s : [OK] Meltice succeeded in processing of this file.",filename);
				else
					wsprintf(logbuf, "%s : [NG] Meltice failed in processing of this file. (0x%x)",filename,ret);
				output_log("MELTICE.LOG",logbuf);
				delete [] logbuf;
			}
			return ret;
		}
	}
	return false;
}

bool clmpi_frost(const char *filenames,const char *basedir, int mode)
{
	if(mode <= 0) return false;
	//debug code.
//	MessageBox(0,filenames,"Pack Execute! (argv/drop) $$$",0);
//	MessageBox(0,basedir,"Pack BaseDir (argv/drop) $$$",0);
//	MessageBox(0,dllname[mode],"PackMXD (argv/drop) $$$",0);

	typedef bool (WINAPI *PARCRUNFUNC)(const char *,const char *);
	
	if( load_mxd(mode) == true){
		PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstMxd[mode], "MxdPackArchive");
		if(ArcRun != NULL && clmpi_get_version(mode) !=0 ) // API function ready...
		{
			return (*ArcRun)(filenames,basedir);
		}
	}
	return false;
}


//mxd files...
// return num -> max MXD files.
int get_findmxd(void)
{
	return MaxMxdFiles;
}

char *get_mxdfilename(char *filenamebuf,int mode)
{
	if(mode > 0 && mode < SUPPORT_MXD_NUM+1)
	{
		wsprintf(filenamebuf, "%s",dllname[mode]);
	}
	return filenamebuf;
}
//
//
// ex. get_matchmxdnum("hogehoge.mxd");
//  mxdname <- mxd filename.
//  ret -> -1: Not Found. 1-8=(int mode) matched.
//
int get_matchmxdnum(const char *mxdname)
{
	char *buf=new char[MAX_PATH];
	char *mxdn=new char[MAX_PATH];
	
	lstrcpy(mxdn,mxdname);
	CharLower(mxdn);

	if(mxdname==NULL || lstrcmp(mxdname,"")==0) return -1;
	for(int i=1; i<=SUPPORT_MXD_NUM;i++)
	{
		get_mxdfilename(buf,i);
		CharLower(buf);
		if(lstrcmp(buf,mxdn)==0)
		{
			delete [] mxdn;delete [] buf;
			return i;  //match!
		}
	}
	delete [] mxdn;delete [] buf;
	return -1; //no match.
}

