///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// DI_ARDLL.CPP = DoIt group / for common ARchiver project's DLL functions.
///////////////////////////////////////////////////////////////////////////////

#include 	<windows.h>
#include	<shlobj.h>
#include	".\di_doit.h"
#include	"..\..\utl\u_util.h"

#include	"..\cfg\c_config.h" // for only debug option "NoArDll" and "WriteLog"

//-----------------------------------------------------------------------------
// for Common Archiver Project DLL settings...
#define		SUPPORT_DLL_NUM 	10
#define		APISTR_MAXLEN			32
HINSTANCE  hInstDll[SUPPORT_DLL_NUM+1];

//dll chk...
static char dllname[SUPPORT_DLL_NUM+1][16] = 
{	"",
	"UNLHA32.DLL",
	"UNZIP32.DLL",
	"7-ZIP32.DLL",
	"CAB32.DLL",
	"TAR32.DLL",
	"BGA32.DLL",
	"YZ1.DLL",
	"UNRAR32.DLL",
	"XACRETT.DLL",
	"JACK32.DLL"
};

static char getver_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaGetVersion",
	"UnZipGetVersion", 
	"SevenZipGetVersion",
	"CabGetVersion",
	"TarGetVersion",
	"BgaGetVersion",
	"Yz1GetVersion",
	"UnrarGetVersion",
	"XacRettGetVersion",
	"JackGetVersion"
};

static char getsubver_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaGetSubVersion",
	"UnZipGetSubVersion", 
	"SevenZipGetSubVersion",
	"",
	"",
	"",
	"",
	"",
	"XacRettGetSubVersion",
	""
};

//archive chk...
static char chkarc_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaCheckArchive",
	"UnZipCheckArchive",
	"SevenZipCheckArchive",
	"CabCheckArchive", 
	"TarCheckArchive", 
	"BgaCheckArchive", 
	"Yz1CheckArchive", 
	"UnrarCheckArchive", 
	"XacRettCheckArchive", 
	"JackCheckArchive"
};

static int chkarc_mode[SUPPORT_DLL_NUM+1] = {0, 4, 0, 0, 1, 0, 0, 0, 2, 0, 0};


//DLL ConfigDialog...
static char cfgdlg_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = {
	"",
	"UnlhaConfigDialog",
	"UnZipConfigDialog",
	"SevenZipConfigDialog",
	"CabConfigDialog",
	"TarConfigDialog",
	"BgaConfigDialog",
	"Yz1ConfigDialog",
	"UnrarConfigDialog",
	"",
	"JackConfigDialog"
};


//open_archive...
static char opnarc_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaOpenArchive",
	"UnZipOpenArchive",
	"SevenZipOpenArchive",
	"CabOpenArchive", 
	"TarOpenArchive", 
	"BgaOpenArchive", 
	"Yz1OpenArchive", 
	"UnrarOpenArchive", 
	"XacRettOpenArchive", 
	"JackOpenArchive"
};

static char clsarc_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaCloseArchive",
	"UnZipCloseArchive",
	"SevenZipCloseArchive",
	"CabCloseArchive", 
	"TarCloseArchive", 
	"BgaCloseArchive", 
	"Yz1CloseArchive", 
	"UnrarCloseArchive", 
	"XacRettCloseArchive", 
	"JackCloseArchive"
};

static char find1st_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaFindFirst",
	"UnZipFindFirst",
	"SevenZipFindFirst",
	"CabFindFirst", 
	"TarFindFirst", 
	"BgaFindFirst", 
	"Yz1FindFirst", 
	"UnrarFindFirst", 
	"XacRettFindFirst", 
	"JackFindFirst"
};

static char findnext_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] =
{
	"",
	"UnlhaFindNext",
	"UnZipFindNext",
	"SevenZipFindNext",
	"CabFindNext", 
	"TarFindNext", 
	"BgaFindNext", 
	"Yz1FindNext", 
	"UnrarFindNext", 
	"XacRettFindNext", 
	"JackFindNext"
};

static char getfilename_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"UnlhaGetFileName",
	"UnZipGetFileName",
	"SevenZipGetFileName",
	"CabGetFileName",
	"TarGetFileName", 
	"BgaGetFileName",		//can't use...
	"Yz1GetFileName", 
	"UnrarGetFileName", 
	"XacRettGetFileName",	//can't use... 
	""
};

// processing...
static char arcrun_api[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = 
{
	"",
	"Unlha",
	"UnZip",
	"SevenZip", 
	"Cab", 
	"Tar", 
	"Bga", 
	"Yz1", 
	"Unrar", 
	"XacRett", 
	"JackCombine"
};

static char arcrun_melt_cmd[SUPPORT_DLL_NUM+1][APISTR_MAXLEN] = {
	"",
	"x -jf0 -jsp1 -a1 ",
	"-x -qedde -qUdee ", 
	"x ", 
	"-x ", 
	"-x -f ", 
	"x -a -r ", 
	"x ", 
	"-x ", 
	"x ", 
	""
};

#ifdef	MELTICE
static char dllerr_msg[80][24] = {			//24:errmsg_length / 80:0x4e+1
	"ERROR_START",				//0x8000
	"",							//0x8001
	"",							//0x8002
	"",							//0x8003
	"",							//0x8004
	"ERROR_DISK_SPACE",			//0x8005
	"ERROR_READ_ONLY",			//0x8006
	"ERROR_USER_SKIP",			//0x8007
	"ERROR_UNKNOWN_TYPE",		//0x8008
	"ERROR_METHOD",				//0x8009
	"ERROR_PASSWORD_FILE2",		//0x800A
	"ERROR_VERSION",			//0x800B
	"ERROR_FILE_CRC",			//0x800C
	"ERROR_FILE_OPEN",			//0x800D
	"ERROR_MORE_FRESH",			//0x800E
	"ERROR_NOT_EXIST",			//0x800F
	"ERROR_ALREADY_EXIST",		//0x8010
	"ERROR_TOO_MANY_FILES",		//0x8011
	"ERROR_MAKEDIRECTORY",		//0x8012
	"ERROR_CANNOT_WRITE",		//0x8013
	"ERROR_HUFFMAN_CODE",		//0x8014
	"ERROR_COMMENT_HEADER",		//0x8015
	"ERROR_HEADR_CRC",			//0x8016
	"ERROR_HEADER_BROKEN",		//0x8017
	"ERROR_ARC_FILE_OPEN",		//0x8018
	"ERROR_NOT_ARC_FILE",		//0x8019
	"ERROR_CANNOT_READ",		//0x801A
	"ERROR_FILE_STYLE",			//0x801B
	"ERROR_COMMAND_NAME",		//0x801C
	"ERROR_MORE_HEAP_MEMORY",	//0x801D
	"ERROR_ENOUGH_MEMORY",		//0x801E
	"ERROR_ALREADY_RUNNING",	//0x801F
	"ERROR_USER_CANCEL",		//0x8020
	"ERROR_HARC_ISNOT_OPENED",	//0x8021
	"ERROR_NOT_SEARCH_MODE",	//0x8022
	"ERROR_NOT_SUPPORT",		//0x8023
	"ERROR_TIME_STAMP",			//0x8024
	"ERROR_TMP_OPEN",			//0x8025
	"ERROR_LONG_FILE_NAME",		//0x8026
	"ERROR_ARC_READ_ONLY",		//0x8027
	"ERROR_SAME_NAME_FILE",		//0x8028
	"ERROR_NOT_FIND_ARC_FILE",	//0x8029
	"ERROR_RESPONSE_READ",		//0x802A
	"ERROR_NOT_FILENAME",		//0x802B
	"ERROR_TMP_COPY",			//0x802C
	"ERROR_EOF",				//0x802D
	"ERROR_ADD_TO_LARC",		//0x802E
	"ERROR_TMP_BACK_SPACE",		//0x802F
	"ERROR_SHARING",			//0x8030
	"ERROR_NOT_FIND_FILE",		//0x8031
	"ERROR_LOG_FILE",			//0x8032
	"ERROR_NO_DEVICE",			//0x8033
	"ERROR_GET_ATTRIBUTES",		//0x8034
	"ERROR_SET_ATTRIBUTES",		//0x8035
	"ERROR_GET_INFORMATION",	//0x8036
	"ERROR_GET_POINT",			//0x8037
	"ERROR_SET_POINT",			//0x8038
	"ERROR_CONVERT_TIME",		//0x8039
	"ERROR_GET_TIME",			//0x803a
	"ERROR_SET_TIME",			//0x803b
	"ERROR_CLOSE_FILE",			//0x803c
	"ERROR_HEAP_MEMORY",		//0x803d
	"ERROR_HANDLE",				//0x803e
	"ERROR_TIME_STAMP_RANGE",	//0x803f
	"ERROR_MAKE_ARCHIVE",		//0x8040
	"ERROR_NOT_CONFIRM_NAME",	//0x8041
	"ERROR_UNEXPECTED_EOF",		//0x8042
	"ERROR_INVALID_END_MARK",	//0x8043
	"ERROR_INVOLVED_LZH",		//0x8044
	"ERROR_NO_END_MARK",		//0x8045
	"ERROR_HDR_INVALID_SIZE",	//0x8046
	"ERROR_UNKNOWN_LEVEL",		//0x8047
	"ERROR_BROKEN_DATA",		//0x8048
	"ERROR_INVALID_PATH",		//0x8049
	"ERROR_TOO_BIG",			//0x804a
	"ERROR_EXECUTABLE_FILE",	//0x804b
	"ERROR_INVALID_VALUE",		//0x804c
	"ERROR_HDR_EXPLOIT",		//0x804d
	"ERROR_HDR_NO_CRC",			//0x804e
	"ERROR_HDR_NO_NAME"			//0x804f
};

void get_dllerr_msg(char *errmsg,int errcode)
{
	if(errcode >= 0x8000 && errcode <= 0x804f)
		lstrcpyn(errmsg,dllerr_msg[errcode-0x8000],64);
	else
		lstrcpyn(errmsg,"UNKNOWN",64);
	
}
#endif

// load Common Archiver's Project DLL
//   return true  -> DLL load success!
//   return false -> DLL load failed.
static bool load_dll(int mode)
{
	if(mode == 0) return false;
	if(get_noardll(0) == true) return false;
	if(hInstDll[mode] != NULL) return true;

	hInstDll[mode] =  LoadLibrary( dllname[mode] );
	if(hInstDll[mode] == NULL) return false;
	return true;
}

// unload Common Archiver's Project DLL
//   return true  -> DLL unload success!
//   return false -> DLL unload failed.
static bool unload_dll(int mode)
{
	if(mode == 0) return false;
	if(get_noardll(0) == true) return false;

	if(FreeLibrary( hInstDll[mode] ) == TRUE)
	{
		hInstDll[mode] = NULL;
		return true;
	}
	return false;
}

// Call archiver DLL config dialog.
//   hDlg     <- HWND hDlg.
//   mode     <- MODE_ZIP, etc...
bool config_dialog(const HWND hDlg, int mode)
{
	typedef bool (WINAPI *PCNFDLGFUNC)(const HWND,LPSTR,const int);
	static char dummybuf[1024];

	if( load_dll(mode) == true){
		PCNFDLGFUNC CfgDlg = (PCNFDLGFUNC)GetProcAddress(hInstDll[mode], cfgdlg_api[mode]);
		if(CfgDlg != NULL) // API function ready...
		{
			return (*CfgDlg)(hDlg,dummybuf, 1);
		}
	}
	return false;
}


// check archive.
//   filename <- input filename for check.
//   mode     <- MODE_ZIP, etc...
//   return true  -> archive file.
//   return false -> etc file.
static bool check_archive(const char * filename, int mode)
{
	typedef bool (WINAPI *PCHKARCFUNC)(LPCSTR,const int);

	if( load_dll(mode) == true){
		PCHKARCFUNC ChkArc = (PCHKARCFUNC)GetProcAddress(hInstDll[mode], chkarc_api[mode]);
		if(ChkArc != NULL) // API function ready...
		{
			return (*ChkArc)(filename,chkarc_mode[mode]);
		}
	}
	return false;
}

// Common Archiver's Project DLL versions.
// Ver.1.34 -> return 134.
int ardll_get_version(int mode)
{
	typedef WORD (WINAPI *PGETVERFUNC)();

	if( load_dll(mode) == true){
		PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll[mode], getver_api[mode]);
		if(GetVer != NULL) // API function ready...
		{
			return (int)(*GetVer)();
		}
		unload_dll(mode);
	}
	return 0;
}

// Common Archiver's Project DLL versions.
// Ver.1.34.2.3 -> return 203.
int ardll_get_subversion(int mode)
{
	typedef WORD (WINAPI *PGETVERFUNC)();

	if( load_dll(mode) == true){
		PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll[mode], getsubver_api[mode]);
		if(GetVer != NULL) // API function ready...
		{
			return (int)(*GetVer)();
		}
		unload_dll(mode);
	}
	return 0;
}

int ardll_check_archive(const char *filename)
{
	//BugFix: TAR32.DLL v0.53 & 0-1byte file check -> Integer Divide by Zero.
	//(0-2byte file isn't archive file!)
	HANDLE chkarcfil = CreateFile( filename, GENERIC_READ, FILE_SHARE_READ,
		NULL, OPEN_EXISTING, NULL, NULL );
	if(GetFileSize(chkarcfil, NULL) <= 2) { CloseHandle(chkarcfil); return 0; }
	CloseHandle(chkarcfil);

	int chkfast; //.??? -> 1st check archive.
	char *str = new char[lstrlen(filename)+1]; lstrcpy(str,filename);
	lstrcpy(str,CharLower(get_expname(get_filename(str))));
	
	if(lstrcmp(str,"lzh")==0||lstrcmp(str,"lzs")==0||lstrcmp(str,"lha")==0)
		chkfast=MODE_LZH;
	else if(lstrcmp(str,"zip")==0||lstrcmp(str,"jar")==0)
		chkfast=MODE_7ZIP;
	else if(lstrcmp(str,"7z")==0)
		chkfast=MODE_7ZIP;
	else if(lstrcmp(str,"cab")==0)
		chkfast=MODE_CAB;
	else if(lstrcmp(str,"tar")==0||lstrcmp(str,"tgz")==0 ||lstrcmp(str,"tbz")==0 || lstrcmp(str,"tlz")==0 || lstrcmp(str,"tzs")==0 || lstrcmp(str,"tzst")==0
			                     ||lstrcmp(str,"gz")==0  ||lstrcmp(str,"bz2")==0 ||lstrcmp(str,"lzma")==0 || lstrcmp(str,"zst")==0 || lstrcmp(str,"zstd")==0  )
		chkfast=MODE_TAR;
	else if(lstrcmp(str,"bza")==0||lstrcmp(str,"gza")==0)
		chkfast=MODE_BGA;
	else if(lstrcmp(str,"yz1")==0)
		chkfast=MODE_YZ1;
	else if(lstrcmp(str,"rar")==0)
		chkfast=MODE_RAR;
	else
		chkfast=MODE_JAK;
	delete [] str;

	//Check archive by Common archiver project's DLL 
	if( check_archive(filename,chkfast)   != false) return chkfast;
	if( check_archive(filename,MODE_JAK)  != false) return MODE_JAK;
	if( check_archive(filename,MODE_RAR)  != false) return MODE_RAR; 
	if( check_archive(filename,MODE_YZ1)  != false) return MODE_YZ1; 
	if( check_archive(filename,MODE_TAR)  != false) return MODE_TAR;
	if( check_archive(filename,MODE_BGA)  != false) return MODE_BGA;
	if( check_archive(filename,MODE_CAB)  != false) return MODE_CAB;
	if( check_archive(filename,MODE_7ZIP) != false) return MODE_7ZIP;
	if( check_archive(filename,MODE_ZIP)  != false) return MODE_ZIP;
	if( check_archive(filename,MODE_LZH)  != false) return MODE_LZH;
	if( check_archive(filename,MODE_XAC)  != false) return MODE_XAC; 
	return 0;
}

// unpack file from archive file.
//  hDlg      <- hWnd.
//  filename  <- archive file.
//  outputdir <- destdir.
//  mode      <- select unpack engine.
int ardll_melt(const HWND hDlg, const char *filename,const char *outputdir,int mode)
{
	int ret = FALSE;
	typedef BOOL  (WINAPI *PARCRUNFUNC)(const HWND, LPCSTR,LPSTR, const DWORD);
	typedef DWORD (WINAPI *PARCCMBFUNC)(LPCSTR, LPCSTR ); // for JACK32.DLL
char *original_current_dir = new char[MAX_PATH*10];
GetCurrentDirectory(MAX_PATH*10, original_current_dir);
	if( load_dll(mode) == true){
		if(mode != MODE_JAK)
		{
			PARCRUNFUNC ArcRun = (PARCRUNFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
			if(ArcRun != NULL) // API function ready...
			{
				char cmdbuf[MAX_PATH * 4];
				if(mode==MODE_7ZIP) //for 7-zip.dll
				{
					CreateDirectory(outputdir,NULL);
					ret = SetCurrentDirectory(outputdir);
					if(ret!=TRUE)
					{
						delete [] original_current_dir;
						return false;
					}
				}
				wsprintf(cmdbuf,"%s \"%s\" \"%s\"", arcrun_melt_cmd[mode], filename, outputdir);
				if(mode==MODE_TAR)
				{
					wsprintf(cmdbuf,"%s \"%s\" -o \"%s\"", arcrun_melt_cmd[mode], filename, outputdir);
				}
				ret = (*ArcRun)(hDlg,cmdbuf,NULL,0);
#ifdef	MELTICE
				if(get_writelog()==true)
				{
					char *logbuf = new char[MAX_PATH * 5];
					char *errormsg = new char[32]; get_dllerr_msg(errormsg,ret);

					wsprintf(logbuf, "%s : [%s cmd] <%s>",filename, dllname[mode], cmdbuf);
					output_log("MELTICE.LOG",logbuf);

					if(ret == 0)
						wsprintf(logbuf, "%s : [OK] Meltice succeeded in processing of this file.",filename);
					else if(ret > 0 && ret < 0x8000 )
						wsprintf(logbuf, "%s : [NG?] Meltice failed in processing of this file. (0x%04x files can't extracted)",filename,ret);
					else
						wsprintf(logbuf, "%s : [NG] Meltice failed in processing of this file. (0x%04x:%s)",filename,ret,errormsg);
					output_log("MELTICE.LOG",logbuf);
					delete [] errormsg;
					delete [] logbuf;
				}
#endif
			}
		}else{	//for JACK32.DLL
			PARCCMBFUNC ArcCmb = (PARCCMBFUNC)GetProcAddress(hInstDll[mode], arcrun_api[mode]);
			if(ArcCmb != NULL) // API function ready...
			{
				ret= (*ArcCmb)(filename,outputdir);

#ifdef	MELTICE
				if(get_writelog()==true)
				{
					char *logbuf = new char[MAX_PATH * 5];
					char *errormsg = new char[32]; get_dllerr_msg(errormsg,ret);
					wsprintf(logbuf, "%s : [%s API] JackCombine(\"%s\",\"%s\");",filename, dllname[mode], filename,outputdir);
					output_log("MELTICE.LOG",logbuf);

					if(ret == 0)
					{
						wsprintf(logbuf, "%s : [OK] Meltice succeeded in processing of this file.",filename);
						output_log("MELTICE.LOG",logbuf);
					}else{
						wsprintf(logbuf, "%s : [NG] Meltice failed in processing of this file. (0x%x:%s)",filename,ret,errormsg);
						output_log("MELTICE.LOG",logbuf);
					}
					delete [] errormsg;
					delete [] logbuf;
				}
#endif
			}
		}
	}

	SetCurrentDirectory(original_current_dir);
	delete [] original_current_dir;
	unload_dll(mode);
	return ret;
}

//ArchiverDLL GetFileName API call function.
//arc, buffer, size <- please see UNLHA32.DLL API.TXT > UnlhaGetFileName
//mode              <- Meltice use DLL internal number. ex:MODE_ZIP, etc...
//ivinf             <- for BGA32.DLL/XacRett.DLL only.
//return            -> GetFileName API return...
int ardll_api_getfilename(HARC arc, LPSTR buffer, const int size, const int mode,INDIVIDUALINFO ivinf)
{
	//for GetFileName API
	typedef int (WINAPI *PGFNARCFUNC)(HARC,LPSTR,const int);
	PGFNARCFUNC GfnArc = (PGFNARCFUNC)GetProcAddress(hInstDll[mode], getfilename_api[mode]);
	int ret=-1;

	if(GfnArc != NULL)
	{
		ret = (*GfnArc)(arc,buffer,size); //GetFileName
	}
	else
	{
		//for BGA32.DLL, XacRett.DLL (GetFileName can't use...)
		lstrcpy(buffer, ivinf.szFileName);
	}
	return ret;
}

//for no double make folder function.
// singledir <- if singledir return true then save singledir path.
// return true -> singledir.
// return false -> not single dir.
bool ardll_check_archive_in_singledir
	(const char *filename, char *singledir, int sdlen)
{
	int mode = ardll_check_archive(filename);
	if(mode == MODE_JAK) return true; //Jack must be SingleFile!

	if( mode != MODE_NOT_SUPPORT && load_dll(mode) == true )
	{
		//for OpenArchive API
		typedef HARC (WINAPI *POPNARCFUNC)(const HWND, LPCSTR, const DWORD);
		//for CloseArchive API
		typedef int (WINAPI *PCLSARCFUNC)(HARC);
		//for FindFirst API
		typedef int (WINAPI *PFF_ARCFUNC)(HARC, LPCSTR,INDIVIDUALINFO FAR *);
		//for FindNext API
		typedef int (WINAPI *PFN_ARCFUNC)(HARC,INDIVIDUALINFO FAR *);

		POPNARCFUNC OpnArc = (POPNARCFUNC)GetProcAddress(hInstDll[mode], opnarc_api[mode]);
		PCLSARCFUNC ClsArc = (PCLSARCFUNC)GetProcAddress(hInstDll[mode], clsarc_api[mode]);
		PFF_ARCFUNC FF_Arc = (PFF_ARCFUNC)GetProcAddress(hInstDll[mode], find1st_api[mode]);
		PFN_ARCFUNC FN_Arc = (PFN_ARCFUNC)GetProcAddress(hInstDll[mode], findnext_api[mode]);

		if(	OpnArc != NULL &&
			ClsArc != NULL &&
			FF_Arc != NULL &&
			FN_Arc != NULL  ) // API function ready...
		{
			char *buff = new char[MAX_PATH*10];   //buffer.
			char *chkbuf = new char[MAX_PATH*10]; //for check.
			bool chk = false; //chk=true  ->Singlefolder false -> not single.
			HARC arc;
			unsigned int iCnt;

			//OpenArchive
			if( mode == MODE_LZH )
			{
				arc = (*OpnArc)(NULL,filename,M_REGARDLESS_INIT_FILE|M_RECOVERY_ON);
			}else{
				arc = (*OpnArc)(NULL,filename,M_REGARDLESS_INIT_FILE);
			}

			INDIVIDUALINFO ivinf;
			int iFFRet = (*FF_Arc)(arc,"*",&ivinf); // FindFirst
			if(iFFRet != 0 && iFFRet != -1) return false; //for YZ1 with Password...
			ardll_api_getfilename(arc,buff,MAX_PATH*10,mode,ivinf);
			iCnt = 1; //FileCount = 1.
			get_1st_dirname(buff); // hogehoge/foobar/abcde.txt -> hogehoge
			lstrcpyn(chkbuf, buff,MAX_PATH*10); //chkbuf set standard for check
			while( (*FN_Arc)(arc,&ivinf) == 0 ){ // FindNext
			ardll_api_getfilename(arc,buff,MAX_PATH*10,mode,ivinf);
				iCnt++;
				get_1st_dirname(buff);
				if(lstrcmp(buff, chkbuf)==0)
				{
					lstrcpyn(singledir, buff,sdlen);
					chk = true;
				}else{
					chk=false;
					break;
				}
			}
			
			if(iCnt == 1) //for single file in archive file.
			{
				(*FF_Arc)(arc,"*",&ivinf); // FindFirst
				ardll_api_getfilename(arc,buff,MAX_PATH*10,mode,ivinf);

				//for ./dirname/file.txt or ./file.txt code.
				if( *buff='.' && 
					(*(buff+1) == '\\' || *(buff+1) == '/'))
				{
					lstrcpyn(chkbuf, (buff+2),MAX_PATH*10);
					lstrcpyn(buff,chkbuf,MAX_PATH*10);

				}

				lstrcpyn(chkbuf, buff,MAX_PATH*10); //chkbuf = Original Filename.
				get_1st_dirname(buff); // SingleFile and SingleDir : hogehoge/abcde.txt -> hogehoge
									 // SingleFile and NotSingleDir : abcde.txt -> abcde.txt
				if(lstrcmp(buff, chkbuf)!=0) // buff <> chkbuf -> singlefile &&singledir.
				{
					lstrcpyn(singledir, buff,sdlen);
					chk = true;
				}
			}

			(*ClsArc)(arc); // Close Archive

			if(lstrcmp("..", buff)==0 && chk == true)
			{
				chk = false;	//SingleDir Cancel for ".." dir only archive.
			}

			delete [] buff;
			delete [] chkbuf;

			return chk;
		}
	}

	return false;

}
