///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// W_MPICLL.CPP = Window group / for Meltice Plug-Ins window call.
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include "w_window.h"

#include	".\w_global.h"
#include	"..\cfg\c_config.h"
#include	"..\do\di_doit.h" 	// for MPIfilename
#define		MSGBUF	256

//This Meltice use MXD Protocol Version.
#define 	MXD_PROTOCOL_VER	2000

//Call MPI Dialog , need for MXD Filename.
void w_mpicll_cnfdlg(const HWND hDlg, const char *filename, const int iMode)
{
	HINSTANCE  hInstMxd = LoadLibrary(filename);
	if(hInstMxd == NULL) return;

	typedef bool (WINAPI *PCNFDLGFUNC)(const HWND, LPSTR, const int);
	typedef int (WINAPI *PGETVERFUNC)();

	PCNFDLGFUNC CnfDlg 			= (PCNFDLGFUNC)GetProcAddress(hInstMxd, "MxdConfigDialog");
	PGETVERFUNC GetProtocolVer 	= (PGETVERFUNC)GetProcAddress(hInstMxd, "MxdGetProtocolVersion");
	
	if(CnfDlg != NULL && GetProtocolVer != NULL) // API function ready...
	{
		if( (*GetProtocolVer)() == MXD_PROTOCOL_VER)
		{
			(*CnfDlg)(hDlg,NULL,iMode);
		}else{
			char *msgbuf = new char[MSGBUF];
			char *titlebuf = new char[MSGBUF];
			get_msgcfg_string(msgbuf, IDS_STR_MXDINCORRECTVER);
			get_msgcfg_string(titlebuf, IDS_STR_MXDINFOTITLE);
			
			MessageBox(hDlg,msgbuf,titlebuf,MB_ICONWARNING);
			delete [] msgbuf, titlebuf;
		}
	}
	return ;
}

//Call MPI Dialog , need for MXD number.
//mode = MXD Number
//iMode = VerInfo(-) / Extract(1) / Pack(2)
void w_mpicll_cnfdlgn(const HWND hDlg, int iMode, int mode)
{
	clmpi_get_version(1); get_findmxd();//dummy!

	char *filename = new char[MAX_PATH]; *filename='\0';
	get_mxdfilename(filename,mode);
	w_mpicll_cnfdlg(hDlg, filename,iMode);
	delete filename;
}

//Call MPI Config Name, need for MXD number.
bool w_mpicll_cnfnme(char *szbuf, const int iMode, const int iLang, const int mode)
{
	clmpi_get_version(1); get_findmxd();//dummy!

	char *filename = new char[MAX_PATH];
	get_mxdfilename(filename,mode);
	HINSTANCE  hInstMxd = LoadLibrary(filename);
	delete filename;

	if(hInstMxd == NULL) return false;

	typedef bool (WINAPI *PMXDCNFNMEFUNC)(char*, const int, const int);
	typedef int (WINAPI *PGETVERFUNC)();

	bool ret = false;
	PMXDCNFNMEFUNC CnfNme		= (PMXDCNFNMEFUNC)GetProcAddress(hInstMxd, "MxdConfigName");
	PGETVERFUNC GetProtocolVer	= (PGETVERFUNC)GetProcAddress(hInstMxd, "MxdGetProtocolVersion");

	if(GetProtocolVer == NULL)
	{
		//wsprintf(szbuf, "Err: MxdGetVer.");
		get_msgcfg_string(szbuf, IDS_STR_EXTERR_NOMXDVER);
		return ret;
	}

	if( (*GetProtocolVer)() == MXD_PROTOCOL_VER)
	{
		if(CnfNme != NULL) // API function ready...
		{
			ret = (*CnfNme)(szbuf,iMode,iLang);
		}else{
			//wsprintf(szbuf, "Err: NoName.");
			get_msgcfg_string(szbuf, IDS_STR_EXTERR_NONAME);
			ret=false;
		}
	}else{
		//wsprintf(szbuf, "Err: Incorrect Ver.");
		get_msgcfg_string(szbuf, IDS_STR_EXTERR_INCVER);
	}
	return ret;
}
