///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// W_GLOBAL.CPP = Window group / GLOBAL functions for setting dialog.
///////////////////////////////////////////////////////////////////////////////

#include	<windows.h>
#include	<windowsx.h>
#include	".\w_window.h"
#include	".\w_global.h"
#include	"..\cfg\c_config.h"
#include	"..\..\utl\u_util.h"

#include	"..\do\d_do.h" 	// for DnD file.

#define		MSGBUF	256

//CheckBox, Button, TextBox Object is enabled/disabled.
//hDlg = Dialog hWnd.
//hCnt = Control code(int). (CheckBox, Button, TextBox, etc.)
//sw   = true ->enable / false->disable.
static void ControlEnable(HWND hDlg, int iCnt, bool sw)
{
	EnableWindow(GetDlgItem(hDlg,iCnt),sw);// hRec on hDlg enable or disable from sw.
}

static int MelticeGetCodePage()
{
	if(get_autolang()==true)
		return GetACP();
	else return 9999; //dummy.

}

#ifdef	MELTICE
//UnPack DiaLoG
LRESULT CALLBACK UPDLGProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
	int i,x,y;
	char Dir[MAX_PATH+1];

	HDROP hDrop;
	UINT uFileNo;
	char szFileName[MAX_PATH+1];
	char szFileName1st[MAX_PATH+1];
	char szFileNameBuf[MAX_PATH+1];
	char *szFileNames;

	//}`j^Ή by Ver.2.2.2-2012
	static BOOL isMinusXYEnabled;

	HINSTANCE hInst = GetModuleHandle(NULL);
	
	//for AutoComplete
	typedef HRESULT (WINAPI *SHAUTOCOMPLETE)(HWND hwndEd, DWORD dwFlg);
	SHAUTOCOMPLETE SHAutoCompleteAPI;
	HANDLE hSHLWAPIDLL=NULL;
	if( get_autocmpl()== true)
	{
		hSHLWAPIDLL = LoadLibrary("SHLWAPI.DLL");
		CoInitialize(NULL);
	}
	
	switch (uMsg)
	{
		//for WM_INITDIALOG and WM_EXITSIZEMOVE.
		RECT deskrc; //desktop rc.
		RECT rc;

		//for WM_EXITSIZEMOVE.
		int margin;
		bool isautomoved;

		case WM_INITDIALOG:

			//EVtgL[̂ݔ
			if(::GetAsyncKeyState(VK_RSHIFT) & 0x8000 ){
				isMinusXYEnabled = TRUE;
			}
			else
			{
				isMinusXYEnabled = FALSE;
			}

		//////Load Dialog locate.
			SetClassLong(hDlg, GCL_HICON, (LONG)LoadIcon(hInst, "ICON_0_MAIN" ));

			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			x = get_dialog_x(); y = get_dialog_y();

			if(x == -9999) x = (deskrc.right - (rc.right-rc.left)) / 2;
			else if(isMinusXYEnabled ==FALSE)
			{
				if(x < deskrc.left) x = deskrc.left;
				else if(x > (deskrc.right - (rc.right-rc.left))) x=(deskrc.right - (rc.right-rc.left));
			}
			if(y == -9999) y = (deskrc.bottom - (rc.bottom-rc.top)) /2;
			else if(isMinusXYEnabled ==FALSE)
			{
				if(y < deskrc.top) y = deskrc.top;
				if(y > (deskrc.bottom - (rc.bottom-rc.top)))y=(deskrc.bottom - (rc.bottom-rc.top));
			}
			
			SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);

		//////Set UnPack Dir.
			get_destdir(Dir, MAX_PATH, 0);
			Static_SetText(GetDlgItem(hDlg, IDC_ED_UPDESTDIR), Dir);//Dir -> TextBox Label.
					//////Set CheckBox
			//open destination dir.
			SendMessage(GetDlgItem(hDlg, IDC_CB_UPOPENDIR), BM_SETCHECK, (WPARAM)get_opendir(0), 0L);
			//unpack to source folder
			SendMessage(GetDlgItem(hDlg, IDC_CB_UPSAMEDIR), BM_SETCHECK, (WPARAM)get_samedir(0), 0L);
			{
				//Unpack to source folder checkbox is...?
				if(IsDlgButtonChecked(hDlg, IDC_CB_UPSAMEDIR) == BST_CHECKED) {
					set_samedir(true,0);
					ControlEnable(hDlg, IDC_LABEL_OPFLD, false); // Output Folder textlabel
					ControlEnable(hDlg, IDC_ED_UPDESTDIR, false); // Output to... textbox
					ControlEnable(hDlg, IDC_BTN_UPMORE, false); // Browse...Button.
					ControlEnable(hDlg, IDC_BTN_UPOPEN, false); // Open button
				}else{
					set_samedir(false,0);
					ControlEnable(hDlg, IDC_LABEL_OPFLD, true); // Output Folder textlabel
					ControlEnable(hDlg, IDC_ED_UPDESTDIR, true); // Output to... textbox
					ControlEnable(hDlg, IDC_BTN_UPMORE, true); // Browse...Button.
					ControlEnable(hDlg, IDC_BTN_UPOPEN, true); // Open button
				}
			}

			//optmdir
			SendMessage(GetDlgItem(hDlg, IDC_CB_UPOPTDIR), BM_SETCHECK, (WPARAM)get_optmdir(0), 0L);
			if(get_nomkdir(0) != false){ ControlEnable(hDlg, IDC_CB_UPOPTDIR, false); }

		//////Read only? (if readonly then OK/Apply is disabled.)
			if( get_cfg_readonly() == true )
			{
				ControlEnable(hDlg, IDOK, false);    //OK Button is disabled.
				ControlEnable(hDlg, IDAPPLY, false); //Apply Button is disabled.
				GetDlgItemText(hDlg, IDC_GRP_UPCFG, (LPTSTR)Dir, sizeof(Dir));
				lstrcat(Dir, " (ReadOnly)");
				Static_SetText(GetDlgItem(hDlg, IDC_GRP_UPCFG), Dir);
			}

		//////Drag and Drop for Dialog.
			DragAcceptFiles(hDlg, TRUE);

		//////for AutoComplete
			if( get_autocmpl()== true && hSHLWAPIDLL != NULL)
			{
				SHAutoCompleteAPI = (SHAUTOCOMPLETE) GetProcAddress((HINSTANCE)hSHLWAPIDLL, "SHAutoComplete");
				if (SHAutoCompleteAPI)
					//SHAutoCompleteAPI(hEdit, SHACF_FILESYSTEM);
					SHAutoCompleteAPI(GetDlgItem(hDlg, IDC_ED_UPDESTDIR), 1);
				FreeLibrary((HINSTANCE)hSHLWAPIDLL);
			}

			return true;

		case WM_EXITSIZEMOVE:
			margin=10;
			isautomoved=false;

			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			if(isMinusXYEnabled ==FALSE)
			{
				x = rc.left; y = rc.top;
				if(x < deskrc.left+margin){x = deskrc.left; isautomoved = true;}
				else if(x + margin > (deskrc.right - (rc.right-rc.left))){ x=(deskrc.right - (rc.right-rc.left)); isautomoved = true;}
				if(y < deskrc.top+margin){ y = deskrc.top; isautomoved = true;}
				else if(y + margin > (deskrc.bottom - (rc.bottom-rc.top))){ y=(deskrc.bottom - (rc.bottom-rc.top)); isautomoved = true;}
				if(isautomoved==true)
				{
					SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);
				}
			}
			return true;

		case WM_DROPFILES:
			int irecipe;//recipe's answer.
			irecipe=0; 
			bool meltflag; //meltflag (unpack a archive -> true.)
			meltflag=false;
			hDrop = (HDROP)wParam;
			uFileNo = DragQueryFile((HDROP)wParam, 0xFFFFFFFF, NULL, 0);
			szFileNames = new char[MAX_PATH*(uFileNo+4)];
			*szFileNames = '\0';
			for(i = 0; i < (int)uFileNo; i++) {
				DragQueryFile(hDrop, i, szFileName, sizeof(szFileName));
				if(i==0)
				{
					lstrcpy(szFileName1st,szFileName);
					lstrcat(szFileNames, "\""); lstrcat(szFileNames, get_dirname(szFileName1st)); lstrcat(szFileNames, "\" ");
				}
				lstrcpy(szFileNameBuf,szFileName);
				lstrcat(szFileNames, "\""); lstrcat(szFileNames, get_filename(szFileNameBuf)); 
				if(GetFileAttributes(szFileNameBuf)& FILE_ATTRIBUTE_DIRECTORY)
					lstrcat(szFileNames,"\\*");
				lstrcat(szFileNames, "\" ");
				
				if( irecipe!=2 ) irecipe = recipe(hDlg, szFileName,NULL); 
				if( irecipe==1 ) meltflag= true; //Don't pack after files.
			}
			if(irecipe == 2 && meltflag==false) recipe(hDlg, NULL,szFileNames);
			
			delete [] szFileNames;
			DragFinish(hDrop);
			return FALSE;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
			////// button
				case IDOK:
					memcfg_to_inicfg(hDlg);  //save and end.
					EndDialog(hDlg, IDOK);
					break;
				case IDCANCEL:
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case IDAPPLY:
					memcfg_to_inicfg(hDlg);  //save.
					break;
				case IDC_BTN_UPOPEN:
					get_destdir(Dir, MAX_PATH, 0);
					DWORD fa;
					fa = GetFileAttributes(Dir);
					if(fa & FILE_ATTRIBUTE_DIRECTORY){ //Folder.
						char *buf = new char[MAX_PATH*4+1];
						char *opdircmd = new char[MAX_PATH+1]; // Open Folder Path.
						char *opdiropt = new char[MAX_PATH+1]; // Open Folder Options
						get_opdirex(opdircmd, MAX_PATH, 0);
						get_opdiropt(opdiropt, MAX_PATH, 0);
						wsprintf(buf,"%s \"%s\"", opdiropt, Dir);

						//WinExec(buf, SW_SHOW);
						ShellExecute(hDlg, "open", opdircmd, buf, Dir, SW_SHOW);

						delete [] opdiropt;
						delete [] opdircmd;
						delete [] buf;
					}
					break;
				case IDC_BTN_UPMORE:
					get_destdir(Dir, MAX_PATH, 0);
					{
						char *strbuf = new char[MAX_PATH];
						get_msgcfg_string(strbuf, IDS_STR_BROWSEFLD_UPK);
						i = browse_folder(hDlg, Dir, strbuf);
						delete [] strbuf;
					}
					set_destdir(Dir, MAX_PATH, 0);
					get_destdir(Dir, MAX_PATH, 0);
					if(i != 0 ){ //not cancel
						Static_SetText(GetDlgItem(hDlg, IDC_ED_UPDESTDIR), Dir);//New Dir overwrite TextBox
					}
					break;
				case IDC_BTN_INFO:
					w_show_ardllver(hDlg);
					break;
				case IDC_BTN_EXTD:
					w_show_extddlg(hDlg);
					break;
			////// EditBox
				case IDC_ED_UPDESTDIR:
					GetDlgItemText(hDlg, IDC_ED_UPDESTDIR, (LPTSTR)Dir, sizeof(Dir));
					set_destdir(Dir, MAX_PATH, 0);
					break;
			//////CheckBox
				case IDC_CB_UPOPENDIR:	
					if(IsDlgButtonChecked(hDlg, IDC_CB_UPOPENDIR) == BST_CHECKED) {
						set_opendir(true,0);
					}else{
						set_opendir(false,0);
					}
					break;
				case IDC_CB_UPSAMEDIR:	
					//Unpack to sourcefolder checkbox is...?
					if(IsDlgButtonChecked(hDlg, IDC_CB_UPSAMEDIR) == BST_CHECKED) {
						set_samedir(true,0);
						ControlEnable(hDlg, IDC_LABEL_OPFLD, false); // Output Folder textlabel
						ControlEnable(hDlg, IDC_ED_UPDESTDIR, false); // Output to... textbox
						ControlEnable(hDlg, IDC_BTN_UPMORE, false); // Browse...Button.
						ControlEnable(hDlg, IDC_BTN_UPOPEN, false); // Open button
					}else{
						set_samedir(false,0);
						ControlEnable(hDlg, IDC_LABEL_OPFLD, true); // Output Folder textlabel
						ControlEnable(hDlg, IDC_ED_UPDESTDIR, true); // Output to... textbox
						ControlEnable(hDlg, IDC_BTN_UPMORE, true); // Browse...Button.
						ControlEnable(hDlg, IDC_BTN_UPOPEN, true); // Open button
					}
					break;
				case IDC_CB_UPOPTDIR:	
					if(IsDlgButtonChecked(hDlg, IDC_CB_UPOPTDIR) == BST_CHECKED) {
						set_optmdir(true,0);
						set_ncutdir(true,0);
					}else{
						set_optmdir(false,0);
						set_ncutdir(false,0);
					}
					break;

				default:
					return FALSE;
			}
		default:
			return FALSE;

	}
}

#include	"..\do\di_doit.h" 	// for ConfigDialog.

//EXtenD configuration DiaLoG
LRESULT CALLBACK EXDLGProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
	int x,y,i;
	static int mode; //Config Dialog mode.
	UINT CodePageID = MelticeGetCodePage();

	HINSTANCE hInst = GetModuleHandle(NULL);

	
	
	switch (uMsg)
	{
		case WM_INITDIALOG:

		//////Load Dialog locate.
			RECT deskrc; //desktop rc.
			RECT rc;
			SetClassLong(hDlg, GCL_HICON, (LONG)LoadIcon(hInst, "ICON_0_MAIN" ));
			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			x = (deskrc.right - (rc.right-rc.left)) / 2;
			y = (deskrc.bottom - (rc.bottom-rc.top)) /2;
			SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);
			
		//////Config Dialog enabled when DLL/MXD exist.
			char *pbuf; char cbuf[MAX_PATH]; pbuf=cbuf;cbuf[0]='\0';
			
			for(i=1; i<=8; i++)
			{
				if( ardll_get_version(i) !=0)
				{
					ControlEnable(hDlg, IDC_RB_UNLHA+i-1, true);
				}
				*pbuf='\0';	
				if( w_mpicll_cnfnme(pbuf, 1, CodePageID,i) == true)
					ControlEnable(hDlg, IDC_RB_MXD1+i-1, true);

				if(*pbuf != '\0')
				{
					lstrcpyn(pbuf,pbuf,21);
					wsprintf(pbuf,"%s (&%d/8)",pbuf,i);
					Static_SetText(GetDlgItem(hDlg, IDC_RB_MXD1+i-1), pbuf);
				}
			}
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
			////// button
				case IDOK:
					if(mode < 100) config_dialog(hDlg,mode);
					else w_mpicll_cnfdlgn(hDlg, 1, mode-100);
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case IDCANCEL:
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case IDC_RB_UNLHA:
					mode = MODE_LZH;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_UNZIP:
					mode = MODE_ZIP;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_7ZIP:
					mode = MODE_7ZIP;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_CAB32:
					mode = MODE_CAB;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_TAR32:
					mode = MODE_TAR;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_BGA32:
					mode = MODE_BGA;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_YZ1:
					mode = MODE_YZ1;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_JACK:
					mode = MODE_JAK;
					ControlEnable(hDlg, IDOK, true);
					break;
				case IDC_RB_MXD1: case IDC_RB_MXD2: case IDC_RB_MXD3:
				case IDC_RB_MXD4: case IDC_RB_MXD5: case IDC_RB_MXD6:
				case IDC_RB_MXD7: case IDC_RB_MXD8:
					mode = LOWORD(wParam)-IDC_RB_MXD1+101; // 101-108.
					ControlEnable(hDlg, IDOK, true);
					break;
				default:
					return FALSE;
			}
		default:
			return FALSE;

	}
	return FALSE;
}
#endif
//endif MELTICE

//for Frostice Dummy func.
#ifdef	FROSTICE
LRESULT CALLBACK EXDLGProc(HWND, UINT, WPARAM, LPARAM){return FALSE;}
LRESULT CALLBACK UPDLGProc(HWND, UINT, WPARAM, LPARAM){return FALSE;}
#endif


//UnPackConFiG DiaLog.
#ifdef MELTICE
void w_show_upcfgdlg(HINSTANCE hInst)
#endif
#ifdef	FROSTICE
void w_show_upcfgdlg(HINSTANCE)
#endif
{
#ifdef MELTICE
	UINT CodePageID = MelticeGetCodePage();

	switch(CodePageID)
	{
		case IDS_STR_JPN_CODEPAGE:	//Japanese Environment.
			DialogBox(hInst, "IDD_DLG_UNPACKCFG_JPN", NULL, (DLGPROC)UPDLGProc);
			break;
		default:	//etc (US-English Dialog.)
			DialogBox(hInst, "IDD_DLG_UNPACKCFG", NULL, (DLGPROC)UPDLGProc);
	}
#endif
#ifdef	FROSTICE
	char *mxdfn = new char[MAX_PATH+1];
	char *msgcfgbuf = new char[MSGBUF]; // MessageConfig Buf.

	get_packmxd(mxdfn);
	if(LoadLibrary(mxdfn)==NULL)
	{
		char *buf = new char[MAX_PATH*2+1];
		char *tmpbuf = new char[MAX_PATH*2+1];
		get_msgcfg_string(msgcfgbuf, IDS_STR_VERSION);	
		wsprintf(buf,
			"Frostice.exe %s\n\n"
			"Copyright(C)2001-2024 AwaawaCL Project.\n\n",msgcfgbuf);

		get_msgcfg_string(msgcfgbuf, IDS_STR_FRTC_ERR_NOMXD);	
		wsprintf(tmpbuf,msgcfgbuf,mxdfn);
		lstrcat(buf,tmpbuf);
		get_msgcfg_string(msgcfgbuf, IDS_STR_FRTC_ERR_NOMXD_TITLE);	
		MessageBox(NULL,buf,msgcfgbuf,MB_ICONSTOP);
		delete [] tmpbuf;
		delete [] buf;
	}else{
		w_mpicll_cnfdlg(NULL,mxdfn, 2); //hDlg=0, filename=(mxd filename), mode=2(Pack)
	}
	delete [] msgcfgbuf;
	delete [] mxdfn;
#endif
}

//EXTenD configuration DiaLog.
void w_show_extddlg(HWND hDlg)
{
	UINT CodePageID=MelticeGetCodePage();

	HINSTANCE hInst = GetModuleHandle(NULL);

	switch(CodePageID)
	{
		case IDS_STR_JPN_CODEPAGE:	//Japanese Environment.
			DialogBox(hInst, "IDD_DLG_EXTEND_JPN", hDlg, (DLGPROC)EXDLGProc);
			break;
		default:	//etc (US-English Dialog.)
			DialogBox(hInst, "IDD_DLG_EXTEND", hDlg, (DLGPROC)EXDLGProc);
	}
}

