///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// W_DLLVER.CPP = Window group / get DLL VERsions.
///////////////////////////////////////////////////////////////////////////////

#define MIFVEREX_DLL_NAME	"MIFVEREX.DLL"	//MIFVEREX_DLL name.
#define MIFVEREX_DLL_PRTVER	2203				//MIFVEREX_DLL Protocol Ver. (Ver.2.20.3)

#include	<windows.h>

// for common Archiver prj's DLL GetVersion API.
#include	"..\do\di_doit.h"
#include	"..\cfg\c_config.h"
#include	".\w_global.h"

//get_exec_dir
#include	"..\..\utl\u_util.h"

#define		BUF_LEN	4096
#define		MSGBUF	256

bool w_show_ardllver_ex(HWND hDlg)
{
	bool ret = false;
	
	char *tmpbuf = new char[BUF_LEN];
	get_exec_dir(tmpbuf,BUF_LEN);
	lstrcpyn(tmpbuf,MIFVEREX_DLL_NAME, BUF_LEN);	
	HINSTANCE  hInstDll = LoadLibrary(tmpbuf);

	if(hInstDll!=NULL)
	{
		typedef WORD (WINAPI *PGETVERFUNC)();     //for GetVer (MveGetProtocolVer)
		typedef WORD (WINAPI *PPUTDLGFUNC)(HWND); //for PutDlg (MvePutVersionDialog)
		typedef void (WINAPI *PSETMIFFUNC)(LPCSTR);  //for SetMif (MveSetMelticeVer)
		PGETVERFUNC GetVer = (PGETVERFUNC) GetProcAddress(hInstDll, "MveGetProtocolVer");
		PPUTDLGFUNC PutDlg = (PPUTDLGFUNC) GetProcAddress(hInstDll, "MvePutVersionDialog");
		PSETMIFFUNC SetMif = (PSETMIFFUNC) GetProcAddress(hInstDll, "MveSetMelticeVer");

		if(GetVer != NULL && PutDlg != NULL && SetMif != NULL)
		{
			get_msgcfg_string(tmpbuf, IDS_STR_VERSION);
			(void)(*SetMif)(tmpbuf);
			int mve_protocol_ver = (int)(*GetVer)();
			
			if(mve_protocol_ver ==MIFVEREX_DLL_PRTVER)
			{
				(void)(*PutDlg)(hDlg);
				ret=true;
			}
		}
	}
	delete [] tmpbuf;
	return ret;
}

void w_show_ardllver(HWND hDlg)
{
	//ardllver_ex version info for Meltice Family
	if(w_show_ardllver_ex(hDlg) == true) return;
	
	//dummy.
	char *msgbuf = new char[BUF_LEN]; // Message.
	char *tmpbuf = new char[BUF_LEN]; // Temp.
	char *msgcfgbuf = new char[MSGBUF]; // MessageConfig Buf.

#if _MSC_VER >= 1940
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 20xx");
#elif _MSC_VER >= 1930
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2022");
#elif _MSC_VER >= 1920
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2019");
#elif _MSC_VER >= 1910
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2017");
#elif _MSC_VER >= 1900
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2015");
#elif _MSC_VER >= 1800
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2013");
#elif _MSC_VER >= 1700
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2012");
#elif _MSC_VER >= 1600
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2010");
#elif _MSC_VER >= 1500
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2008");
#elif _MSC_VER >= 1400
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2005");
#elif _MSC_VER >= 1310
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2003");
#elif _MSC_VER >= 1300
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 2002");
#elif _MSC_VER >= 1200
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 6.0");
#elif _MSC_VER >= 1100
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 5.0");
#elif _MSC_VER >= 1000
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ 4.0");
#elif _MSC_VER >= 800
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Visual C++ ");
#endif
#if __BORLANDC__ >= 0x552
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Borland C++");
#elif __BORLANDC__ >= 0x551
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Borland C++ 5.5.1");
#elif __BORLANDC__ >= 0x550
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Borland C++ 5.5.0");
#elif __BORLANDC__ >= 0x001
	get_msgcfg_string(msgcfgbuf, IDS_STR_BUILTINFO);
	wsprintf(tmpbuf, msgcfgbuf,"Borland C++");
#endif

	get_msgcfg_string(msgcfgbuf, IDS_STR_VERSION);
	wsprintf(msgbuf,
		"Meltice for Windows %s\n"
		"Copyright (C)2000-2024 AwaawaCL Project.\n\n"
		"  E-Mail : meltice@asaasa.tk\n"
		"  Web URL : https://asaasa.tk/awa/\n\n"
		"%s",msgcfgbuf,tmpbuf);

#ifdef	MELTICE
	int  tmpver;					// DLL Versions.
	int  tmpsubver;					// DLL SubVersions.
	static char dllname[12][16] = {"","UNLHA32.DLL","UNZIP32.DLL","7-ZIP32.DLL","CAB32.DLL","TAR32.DLL", "BGA32.DLL","YZ1.DLL", "UNRAR32.DLL", "XACRETT.DLL", "JACK32.DLL"};

	bool arcprjdll_flag = false;
	for(int i=1; i<=10; i++){
		tmpver    = ardll_get_version(i);
		tmpsubver = ardll_get_subversion(i);
		if(tmpver != 0 && get_noardll(0)==false){
			if(arcprjdll_flag == false)
			{
				get_msgcfg_string(msgcfgbuf, IDS_STR_ARCPRJMSG);
				lstrcat(msgbuf, "\n\n");
				lstrcat(msgbuf, msgcfgbuf);
				arcprjdll_flag = true;
			}
			if(tmpsubver != 0)
			{
				wsprintf(tmpbuf,"\n\t%-12s \t Ver.%d.%02d.%d.%d", dllname[i], tmpver/100, tmpver%100, tmpsubver/100,tmpsubver%100);
			}
			else
			{
				wsprintf(tmpbuf,"\n\t%-12s \t Ver.%d.%02d", dllname[i], tmpver/100, tmpver%100);
			}
			lstrcat(msgbuf, tmpbuf);
		}
	}


	clmpi_get_version(1); //dummy!
	int iGetmxd = get_findmxd();

	if(iGetmxd != 0)
	{
		get_msgcfg_string(msgcfgbuf, IDS_STR_MXDPRJMSG);
		wsprintf(tmpbuf,"\n %s",msgcfgbuf);
		wsprintf(msgbuf,"%s\n%s", msgbuf, tmpbuf);

		char *filenamebuf = new char[BUF_LEN]; // Temp.
		for(int i=1; i<=iGetmxd;i++)
		{
			tmpver = clmpi_get_version(i);
			if(tmpver >= 1) // Ver.0.00.1-...
			{
				wsprintf(tmpbuf,"\n\t%-12s \t Ver.%d.%02d.%d", 
					get_mxdfilename(filenamebuf,i), 
					tmpver/1000, (tmpver%1000)/10, tmpver%10);
				lstrcat(msgbuf, tmpbuf);
				if(i>9)
				{
					lstrcat(msgbuf, "\n\t\t:  (etc mxd files)");
					break;
				}
			}
		}
		delete [] filenamebuf;
	}
#endif
//endif MELTICE

	get_msgcfg_string(msgcfgbuf, IDS_STR_VERINF_TITLE);
	MessageBox(hDlg,msgbuf,msgcfgbuf,MB_ICONINFORMATION);
	delete [] msgcfgbuf;
	delete [] tmpbuf;
	delete [] msgbuf;
}
