///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// C_MEMSET.CPP = Config group / MEMory SETtings
///////////////////////////////////////////////////////////////////////////////

//EXE Version Ver.x.y.zz.
//(Meltice Ver.2.2.0+ = 2200 Ver.2.2.3+ = 2230  Ver.2.2.6 = 2260  Ver.2.2.6.1 = 2261)
#define		EXE_VERSIONS	2261

#include	<windows.h>

#include	".\c_config.h"
#include	"..\..\utl\u_util.h"

#define		BUF_LEN		4096
static bool cfg_readonly; //INI is ReadOnly / INI cannot Write.

//[Global] Section]
static int  versions; // ini_version
static bool autolang; // Auto switching language.
static int  dialog_x;
static int  dialog_y;
static bool writelog; // WriteLog.
static bool autocmpl; // AutoComplete.

//[UnPack], [Pack] Section
//(2000/03/25 hogehoge[1] not used, because it is design change. 
// PackSetting become nosupported by meltice.)
//
static char destdir[2][MAX_PATH+1]; // default output directory.
static bool opendir[2]; // Open directory by explorer.
static char opdirex[2][MAX_PATH+1]; // customize for Open directory program.
static char opdiropt[2][MAX_PATH+1]; // customize for Open directory program options
static bool samedir[2]; // meltice unpack archives to same dir.
static bool optmdir[2]; // output directories optimized #1. (not double make folder)
static bool ncutdir[2]; // output directories optimized #2. (Last number cutting.)
static bool nomkdir[2]; // no make directories for unpack.
static bool delarfl[2]; // delete archive file for unpack.

static bool noardll[2]; // Not use Archiver DLL (Mxd only)

static char packexp[BUF_LEN]; // ex. PackExp=lzh,zip,cab 
static char packmxd[MAX_PATH]; // For Pack Mxd files.



//-----------------------------------------------------------------------------
// void get_cfg_readonly / set_cfg_readonly
//
//  alang : true  = Read Only.
//        : false = ini file can Read and Write (Default)
//
void set_cfg_readonly(const bool ronly)
{
	cfg_readonly = ronly;
	return;
}

bool get_cfg_readonly(void)
{
	return cfg_readonly;
}



//-----------------------------------------------------------------------------
// void get_versions / set_versions / get_exeversions
void set_versions(const int ver)
{
	versions = ver;
	return;
}

int get_versions(void)
{
	return versions;
}

int get_exeversions(void)
{
	return EXE_VERSIONS;
}



//-----------------------------------------------------------------------------
// void get_autolang / set_autolang
//
//  alang : true  = Japanese and US-English Auto switch dialog.
//        : false = US-English mode only.
//
void set_autolang(const bool alang)
{
	autolang = alang;
	return;
}

bool get_autolang(void)
{
	return autolang;
}

//-----------------------------------------------------------------------------
// void get_writelog / set_writelog
//
//  wlog : true  = Processing Log for Debug.
//       : false = No output log.
//
void set_writelog(const bool wlog)
{
	writelog = wlog;
	return;
}

bool get_writelog(void)
{
	return writelog;
}

//-----------------------------------------------------------------------------
// void get_autocmpl / set_autocmpl
//
//  wlog : true  = Processing Log for Debug.
//       : false = No output log.
//
void set_autocmpl(const bool acpl)
{
	autocmpl = acpl;
	return;
}

bool get_autocmpl(void)
{
	return autocmpl;
}

//-----------------------------------------------------------------------------
// void get_dialog_x(y) / set_dialog_x(y)
void set_dialog_x(const int xpos)
{
	dialog_x = xpos;
	return;
}
void set_dialog_y(const int ypos)
{
	dialog_y = ypos;
	return;
}

int get_dialog_x(void)
{
	return dialog_x;
}

int get_dialog_y(void)
{
	return dialog_y;
}


//-----------------------------------------------------------------------------
// - char get_packexp / set_packexp
//
//    pexp  : xxx,xxx,xxx,xxx <- Exp List, look like CSV, for unpack.
//
// - bool ispackexp (Is Packedfile Exp?)
//
//    yourexp : you wants unpack exp?
//    return -> true = unpack! / false = not unpack,want pack?.
//
void set_packexp(const char *pexp)
{
	lstrcpyn(packexp,pexp, MAX_PATH*4-1);
	return;
}

char *get_packexp(char *pexp)
{
	lstrcpyn(pexp, packexp, MAX_PATH*4-1);
	CharLower(pexp);
	return pexp;
}

bool ispackexp(const char *yourexp)
{
	char *listbase	= new char[MAX_PATH+1];
	char *exp		= new char[MAX_PATH+1];
	char *buf, *list;
	bool ret = false;

	lstrcpy(exp,yourexp);
	CharLower(exp); //Abc,Def -> abc,def
		
	lstrcpy(listbase, packexp);
	CharLower(listbase); //Abc,Def -> abc,def

	if(lstrlen(listbase) == 0)
	{
		delete [] listbase;
		delete [] exp;
		return true;
	}

	list= listbase;
	buf = list;
	while(*list)
	{
		if(*list==',')
		{
			*list = '\0';
			if( lstrcmp(buf,exp) == 0)
			{
				ret = true;
				break;
			}
			list++;
			buf = list;
		}else{
			list++;
		}
	}

	//final exp chk...
	if( lstrcmp(buf,exp) == 0)
		ret = true;

	delete [] listbase;
	delete [] exp;
	return ret;
}


//-----------------------------------------------------------------------------
// - char get_packmxd / set_packmxd
//
//    pmxd  : xxxxxxxx.mxd (MXD Filename for Pack.)
//
//
void set_packmxd(const char *pmxd)
{
	lstrcpy(packmxd,pmxd);
	return;
}

char *get_packmxd(char *pmxd)
{
	lstrcpy(pmxd, packmxd);
	CharLower(pmxd);
	return pmxd;
}


//-----------------------------------------------------------------------------
// void get_destdir / set_destdir
//
//  outdir : Meltice output dir.
//  dirlen : string "output"'s length. 
//  sw     : switch. 0 = Unpack Dir. / 1 = Pack dir (reserved.)
void get_destdir(char *outdir, const int dirlen, const int sw)
{
	if(sw != 0 ) return;
	lstrcpyn(outdir, destdir[sw], dirlen);
	return;
}

void set_destdir(char *outdir, const int dirlen, const int sw)
{
	if(sw != 0 ) return;
	lstrcpyn(destdir[sw], outdir, dirlen);
	return;
}

//-----------------------------------------------------------------------------
// void get_opendir / set_opendir
//
//  opdir : true  = open dir when meltice unpacked archive files. (default)
//        : false = silence when meltice unpack file.
//  sw    : switch. 0 = Unpack Dir. / 1 = Pack dir (reserved.)
//
//
void set_opendir(const bool opdir, const int sw)
{
	if(sw != 0 ) return;
	opendir[sw] = opdir;
	return;
}

bool get_opendir(const int sw)
{
	if(sw != 0 ) return true; //default = true
	return opendir[sw];
}

//-----------------------------------------------------------------------------
// void get_opdirex / set_opdirex (Ver.2.2.1~ = From/To OpDirCm)
//
//  runcmd : command for directory open.
//  cmdlen : string "output"'s length. 
//  sw     : switch. 0 = for Unpack. / 1 = for Pack (reserved.)
void get_opdirex(char *runcmd, const int cmdlen, const int sw)
{
	if(sw != 0 ) return;
	lstrcpyn(runcmd, opdirex[sw], cmdlen);
	return;
}

void set_opdirex(const char *runcmd, const int cmdlen, const int sw)
{
	if(sw != 0 ) return;
	lstrcpyn(opdirex[sw], runcmd, cmdlen);
	return;
}

void get_opdiropt(char *runopt, const int cmdlen, const int sw)
{
	if(sw != 0 ) return;
	lstrcpyn(runopt, opdiropt[sw], cmdlen);
	return;
}

void set_opdiropt(const char *runopt, const int cmdlen, const int sw)
{
	if(sw != 0 ) return;
	lstrcpyn(opdiropt[sw], runopt, cmdlen);
	return;
}


//-----------------------------------------------------------------------------
// void get_samedir / set_samedir
//
//  opdir : true  = meltice unpack archives to same dir.
//        : false = meltice unpack archives to destdir. (default)
//  sw    : switch. 0 = Unpack Dir. / 1 = Pack dir (reserved.)
//
//
void set_samedir(const bool smdir, const int sw)
{
	if(sw != 0 ) return;
	samedir[sw] = smdir;
	return;
}

bool get_samedir(const int sw)
{
	if(sw != 0 ) return true; //default = true
	return samedir[sw];
}



//-----------------------------------------------------------------------------
// void get_optmdir / set_optmdir ( / get and set ncutdir... )
//
//  opdir : true  = optimized unpack path. (default)
//        : false = no optimized uppack path.
//  sw    : switch. 0 = Unpack Dir. / 1 = Pack dir (reserved.)
//
//
void set_optmdir(const bool opdir, const int sw)
{
	if(sw != 0 ) return;
	optmdir[sw] = opdir;
	return;
}

bool get_optmdir(const int sw)
{
	if(sw != 0 ) return true; //default = true
	return optmdir[sw];
}


void set_ncutdir(const bool ncdir, const int sw)
{
	if(sw != 0 ) return;
	ncutdir[sw] = ncdir;
	return;
}

bool get_ncutdir(const int sw)
{
	if(sw != 0 ) return true; //default = true
	return ncutdir[sw];
}

//-----------------------------------------------------------------------------
// void get_nomkdir / set_nomkdir
//
//  opdir : true  = no make directory.
//        : false = make directory or optimized directory (default)
//  sw    : switch. 0 = Unpack Dir. / 1 = Pack dir (reserved.)
//
//
void set_nomkdir(const bool nmdir, const int sw)
{
	if(sw != 0 ) return;
	nomkdir[sw] = nmdir;
	return;
}

bool get_nomkdir(const int sw)
{
	if(sw != 0 ) return false; //default = false
	return nomkdir[sw];
}

//-----------------------------------------------------------------------------
// void get_delarfl / set_delarfl
//
//  dlfil : true  = unpack and delete for archive file
//        : false = only unpack for archive file (default)
//  sw    : switch. 0 = Unpack / 1 = Pack (reserved.)
//
//
void set_delarfl(const bool dlfil, const int sw)
{
	if(sw != 0 ) return;
	delarfl[sw] = dlfil;
	return;
}

bool get_delarfl(const int sw)
{
	if(sw != 0 ) return false; //default = false
	return delarfl[sw];
}

//-----------------------------------------------------------------------------
// void get_noardll / set_noardll
//
//  nadll : true  = Not Use Archiver DLL. 
//        : false = Use Archiver DLL. (default)
//  sw    : switch. 0 = Unpack. / 1 = Pack. (reserved.)
//
//

void set_noardll(const bool nadll, const int sw)
{
	if(sw != 0 ) return;
	noardll[sw] = nadll;
	return;
}

bool get_noardll(const int sw)
{
	if(sw != 0 ) return true; //default = true
	return noardll[sw];
}

