///////////////////////////////////////////////////////////////////////////////
//
// Meltice 2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// C_INISET.CPP = Config group / INI file SETtings
///////////////////////////////////////////////////////////////////////////////

#include	<windows.h>
#include	"..\..\utl\u_util.h"
#include	".\c_config.h"

static const char cGlobalSection[8] = "Global";
static const char cUnPackSection[8] = "UnPack";
static const char cPackSection[8]   = "Pack";

//Generate user's ini filename.
void get_ini_filename(char *path,const int path_len)
{
	char ini_filename[MAX_PATH];
	get_exec_dir(path,path_len);

	char buf[256]; unsigned long buflen=255;
	if(GetUserName(buf,&buflen)){
		conv_for_bad_name(buf, '_'); //cut probrem character by usrname.
		lstrcpyn(ini_filename,buf,MAX_PATH);
		lstrcat(ini_filename,".ini");
	}else{
		lstrcpyn(ini_filename,"MELTICE.INI",MAX_PATH);
	}

	lstrcat(path,ini_filename);
	return;
}

//Check folder write permission.
// return -> true = INI can write / false = INI cannot write.
static bool ChkIniPermission(void)
{
	char inipath[MAX_PATH];
	get_ini_filename(inipath,MAX_PATH);
	HANDLE hFp;

////ini file write test.
	hFp = CreateFile(inipath,
							GENERIC_READ|GENERIC_READ,
							FILE_SHARE_WRITE,
							NULL,
							OPEN_ALWAYS,
							FILE_ATTRIBUTE_NORMAL,
							NULL);
	if(hFp == INVALID_HANDLE_VALUE )
		return false;		// No INI write permission.
	CloseHandle(hFp);

	lstrcat(inipath,".$$$");
////temp file write test.
	hFp = CreateFile(inipath,
							GENERIC_READ|GENERIC_READ,
							FILE_SHARE_WRITE,
							NULL,
							OPEN_ALWAYS,
							FILE_ATTRIBUTE_NORMAL,
							NULL);
	if(hFp == INVALID_HANDLE_VALUE )
		return false;		// No INI write permission.
	CloseHandle(hFp);
	if(DeleteFile(inipath) == false) //tmp file delete failed!
		return false;

	return true;
}

// load settings from ini file.
void inicfg_to_memcfg(void)
{
	//INI path setting...
	char *inipath = new char[MAX_PATH];

	char *buf = new char[MAX_PATH*4];
	get_ini_filename(inipath,MAX_PATH);

	DWORD dwIniAttr = GetFileAttributes(inipath);

	//for FAT and NTFS.
	if( dwIniAttr == 0xFFFFFFFF )
		set_cfg_readonly(false);	// Not Found
	else if( dwIniAttr & FILE_ATTRIBUTE_READONLY )
		set_cfg_readonly(true);		// Read Only (attribute)
	else
		set_cfg_readonly(false);	//Read/Write OK.
	//for NTFS and CD-ROM.
	if( ChkIniPermission() == false )
		set_cfg_readonly(true);	// Read Only (NTFS permission?)

	//DesktopDir...
	char *desktopdir = new char[MAX_PATH];
	get_win_special_folder_path(desktopdir, CSIDL_DESKTOP);
	path_add_backslash(desktopdir);

// [Global] Section.
	//Versions default = 2200 (Ver.2.2.0 --- 2.2.2-2012) 2230 (2.2.3-2012-)
	set_versions(GetPrivateProfileInt(cGlobalSection,"Versions",2230,inipath));

	//AutoLang(Japanese or US-English switching.), default=true.
	GetPrivateProfileString(cGlobalSection,"AutoLang","1",buf,2,inipath);
	if(*buf=='0')	set_autolang( false);	// AutoLang=0 -> false
	else 			set_autolang(  true);	// AutoLang=1 -> true

	set_dialog_x(GetPrivateProfileInt(cGlobalSection,"Dialog_X",-9999,inipath));
	set_dialog_y(GetPrivateProfileInt(cGlobalSection,"Dialog_Y",-9999,inipath));

	//WriteLog(Processing Log, for debug.), default=false.
	GetPrivateProfileString(cGlobalSection,"WriteLog","0",buf,2,inipath);
	if(*buf=='0')	set_writelog( false);	// WriteLog=0 -> false
	else 			set_writelog(  true);	// WriteLog=1 -> true

	//AutoComplete with IE5+ for DestDir, default=true.
	GetPrivateProfileString(cGlobalSection,"AutoCmpl","1",buf,2,inipath);
	if(*buf=='0')	set_autocmpl( false);	// AutoCmpl=0 -> false
	else 			set_autocmpl(  true);	// AutoCmpl=1 -> true
	if(get_versions() < 2116) //Ver.2.1.16+ AutoComplete enable now!
	{
		set_autocmpl(  true);	// AutoCmpl=1 -> true
	}


// [UnPack] Section.
	//meltdir load...
	GetPrivateProfileString(cUnPackSection,"DestDir",desktopdir,buf,MAX_PATH,inipath);
	// --- vvv ---  '//hogehoge' shortcut convert (may be etcfunc...)
	if( *buf=='/' && *(buf+1)=='/' )
	{	// shortcut, ex... '//desktop' 
		if( *(buf+2) == 'd' )
		{ //desktop shortcut.
			set_destdir(desktopdir, MAX_PATH, 0);
		}else if( *(buf+2) == 'm' )
		{ // '//mydoc' = My Documents shortcut.
			set_destdir(
				get_win_special_folder_path(buf, CSIDL_PERSONAL), 
				MAX_PATH, 0);
			//for Windows 95 without MS-Office 9x/2000
			if(*buf=='\0') set_destdir(desktopdir, MAX_PATH, 0);
		}else if( *(buf+2) == 't' )
		{ // '//temp' = temp shortcut.
			GetTempPath(MAX_PATH,buf);
			get_long_path_name_95(buf,buf); //for LFN TempPath on Windows 2000 and XP.
			path_add_backslash(buf);
			set_destdir(buf, MAX_PATH, 0);
		}else if( *(buf+2) == 'e' )
		{ // '//execdir' Meltice.exe path shortcut. 
			get_exec_dir(buf,MAX_PATH);
			set_destdir(buf, MAX_PATH, 0);
		}else // etc shortcut = '//desktop'
		{ 
			// '//???' into memory when not reserved word.
			set_destdir(desktopdir, MAX_PATH, 0);
		}
	}else{ //load path setting
	// --- ^^^ ---  '//hogehoge' shortcut convert (may be etcfunc...)
		path_remove_backslash(buf); // '\\ \\ \\ ...' Backslash heaven guard.
		path_add_backslash(buf);
		set_destdir(buf, MAX_PATH, 0);
	}

	//opendir (Open Folder when meltice unpacked archives.), default=true.
	GetPrivateProfileString(cUnPackSection,"OpenDir","1",buf,2,inipath);
	if(*buf=='0')	set_opendir( false, 0);	// Opendir=0 -> false
	else 			set_opendir(  true, 0);	// OpenDir=1 -> true

	//opdirex with Vulnerability bugfix (Meltice.exe Ver.2.1.12.80+)
	char *opdirex_fullpath = new char[MAX_PATH];	// "%WINDIR%\Explorer.exe"
	GetWindowsDirectory(opdirex_fullpath,MAX_PATH); // "%WINDIR%"              (ex. "C:\WINDOWS")
	path_add_backslash(opdirex_fullpath);           // "%WINDIR%\"             (ex. "C:\WINDOWS\")
	lstrcat(opdirex_fullpath,"Explorer.exe");       // "%WINDIR%\Explorer.exe" (ex. "C:\WINDOWS\Explorer.exe")
	GetPrivateProfileString(cUnPackSection,"OpDirCm",opdirex_fullpath,buf,MAX_PATH,inipath); //OpDirCm= Reading...
	//Meltice.exe Ver.2.1.11.79 and before ver. for "Explorer.exe Vulnerability" bugfix.
	if(lstrcmp(buf,"Explorer")==0 || lstrcmp(buf,"")==0)
	{
		lstrcpy(buf,opdirex_fullpath); // convert "Explorer" -> "%WINDIR%\Explorer.exe" 
	}
	//opdirex (customize for open folder when unpacked archives.)
	set_opdirex(buf, MAX_PATH, 0);
	delete [] opdirex_fullpath;

	GetPrivateProfileString(cUnPackSection,"OpDirOp","",buf,MAX_PATH,inipath); //OpDirOp= Reading...
	set_opdiropt(buf, MAX_PATH, 0);



	//samedir (meltice unpack archives to samedir.), default=false.
	GetPrivateProfileString(cUnPackSection,"SameDir","0",buf,2,inipath);
	if(*buf=='0')	set_samedir( false, 0);	// Samedir=0 -> false
	else 			set_samedir(  true, 0);	// SameDir=1 -> true

	//optmdir (Output directory optimized.), default=true.
	//  ... This setting for unpack only!
	GetPrivateProfileString(cUnPackSection,"OptmDir","1",buf,2,inipath);
	if(*buf=='0')	{	set_optmdir( false, 0);set_ncutdir( false, 0);	}// Optmdir=0 -> false
	else 			{	set_optmdir(  true, 0);set_ncutdir(  true, 0);	}// OptmDir=1 -> true

	//nomkdir (No make directory for unpack), default=false.
	//  ... This setting for unpack only!
	GetPrivateProfileString(cUnPackSection,"NoMkDir","0",buf,2,inipath);
	if(*buf=='0')	{	set_nomkdir( false, 0);	}	// Nomkdir=0 -> false
	else 			{	set_nomkdir(  true, 0);		// Nomkdir=1 -> true
						set_optmdir( false, 0); set_ncutdir( false, 0); } //if Nomkdir=1 then optmdir=0.

	//delarfil (delete archive file), default=false.
	GetPrivateProfileString(cUnPackSection,"DelArFl","0",buf,2,inipath);
	if(*buf=='0')	{	set_delarfl( false, 0);	}// DelArFl=0 -> false
	else 			{	set_delarfl(  true, 0);	}// DelArFl=1 -> true

	//noardll (Not use common archiver prj's dll), default=false.
	//for debug option, Hidden options.
	GetPrivateProfileString(cUnPackSection,"NoArDll","0",buf,2,inipath);
	if(*buf=='0')	set_noardll( false, 0);	// NoArDll=0 -> false
	else 			set_noardll(  true, 0);	// NoArDll=1 -> true

	//PackExp, (ex. PackExp=Lzh,Zip,Cab,Tgz,Yz1 )
#define PACKEXP_DEFAULT	"Lzh,Lzs,Lha,Zip,7z,Jar,Arj,Cab,Tar,Tgz,Gz,Tbz,Bz2,Txz,Xz,Tlz,Lzma,Zst,Zstd,Tzst,Tzs,Taz,Z,Rpm,Deb,Bza,Gza,Yz1,Gca,Ace,Rar,Imp,Zoo,Arc,Cpt,Pit,Arg,Asd,Bel,Jam,Exe,Jak,Mxd"
	GetPrivateProfileString(cUnPackSection,"PackExp",PACKEXP_DEFAULT, buf,MAX_PATH*4-1,inipath);
	//Ver.2.1.16+ Taz,Z,Rpm,Deb,Ish,etc added. 
	//Ver.2.2.2-2012-xzBeta(2.2.2.1 -> 2.2.3i) = xznǉ+ꕔgq폜
	//Ver.2.2.6+ (2.2.5 -> 2.2.6) = zstdnǉ
	//Ver.2.2.6.1+ (2.2.6 -> 2.2.6.1) = zstnǉ
	if(get_versions() < 2261) 
	{
		wsprintf(buf,PACKEXP_DEFAULT);
	}
	set_packexp(buf);

// [Pack] Section.
	GetPrivateProfileString(cPackSection,"PackMxd","Frostice.mxd",buf,MAX_PATH,inipath);
	set_packmxd(buf);

	delete [] desktopdir;
	delete [] buf;
	delete [] inipath;
}

// save settings to ini file.
void memcfg_to_inicfg(HWND hDlg)
{
	//INI path setting...
	char *inipath = new char[MAX_PATH]; // INI file
	char *pathbuf = new char[MAX_PATH]; // DestDir / DirOpEx Path.

	char *tmppath = new char[MAX_PATH*4]; // Temp Path
	char *dskpath = new char[MAX_PATH]; // Temp Path
	char *sp_path = new char[MAX_PATH]; // Temp Path

	GetTempPath(MAX_PATH,tmppath);
	get_long_path_name_95(tmppath,tmppath); //for LFN TempPath on Windows 2000 and XP.
	path_add_backslash(tmppath);
	get_win_special_folder_path(dskpath, CSIDL_DESKTOP);
	path_add_backslash(dskpath);


	get_ini_filename(inipath,MAX_PATH);


// [Global] Section.

	//Versions
    wsprintf(pathbuf,"%d",get_exeversions()); //pathbuf = not path, buffer :-P
	WritePrivateProfileString(cGlobalSection, "Versions", pathbuf, inipath);

	//AutoLanguage
	if( get_autolang() == true)
		WritePrivateProfileString(cGlobalSection, "AutoLang", "1", inipath);
	else 
		WritePrivateProfileString(cGlobalSection, "AutoLang", "0", inipath);

    RECT rc;
    GetWindowRect(hDlg, (LPRECT)&rc); //Get now window position.
    wsprintf(pathbuf,"%d",rc.left); //pathbuf = not path, buffer :-P
	WritePrivateProfileString(cGlobalSection, "Dialog_X", pathbuf, inipath);
    wsprintf(pathbuf,"%d",rc.top);
	WritePrivateProfileString(cGlobalSection, "Dialog_Y", pathbuf, inipath);

	//WriteLog
	if( get_writelog() == true)
		WritePrivateProfileString(cGlobalSection, "WriteLog", "1", inipath);
	else 
		WritePrivateProfileString(cGlobalSection, "WriteLog", "0", inipath);

	//AutoCmpl
	if( get_autocmpl() == true)
		WritePrivateProfileString(cGlobalSection, "AutoCmpl", "1", inipath);
	else 
		WritePrivateProfileString(cGlobalSection, "AutoCmpl", "0", inipath);

// [UnPack] Section.
	//meltdir save...
	get_destdir(pathbuf, MAX_PATH, 0); //get meltdir.
	path_add_backslash(pathbuf);

	if(lstrcmp(dskpath, pathbuf)==0)
	{
		WritePrivateProfileString(cUnPackSection,"DestDir","//desktop",inipath);
	}else if(lstrcmp(tmppath, pathbuf)==0)
	{ 
		WritePrivateProfileString(cUnPackSection,"DestDir","//temp",inipath);
	}else if(
		lstrcmp(get_win_special_folder_path(sp_path, CSIDL_PERSONAL), pathbuf)==0)
	{ 
		WritePrivateProfileString(cUnPackSection,"DestDir","//mydoc",inipath);
	}else if(lstrcmp(get_exec_dir(tmppath,MAX_PATH), pathbuf)==0)
	{ 
		WritePrivateProfileString(cUnPackSection,"DestDir","//execdir",inipath);
	}else
	{
		WritePrivateProfileString(cUnPackSection,"DestDir",pathbuf,inipath);
	}

	//opendir save...
	if( get_opendir(0) == true)
		WritePrivateProfileString(cUnPackSection,"OpenDir","1",inipath);
	else 
		WritePrivateProfileString(cUnPackSection,"OpenDir","0",inipath);


	//opdirex save...
	get_opdirex(pathbuf, MAX_PATH,0);
	WritePrivateProfileString(cUnPackSection,"OpDirCm",pathbuf,inipath);

	get_opdiropt(pathbuf, MAX_PATH,0);
	WritePrivateProfileString(cUnPackSection,"OpDirOp",pathbuf,inipath);

	//samedir save...
	if( get_samedir(0) == true)
		WritePrivateProfileString(cUnPackSection,"SameDir","1",inipath);
	else 
		WritePrivateProfileString(cUnPackSection,"SameDir","0",inipath);


	//optmdir save...
	if( get_optmdir(0) == true)
		WritePrivateProfileString(cUnPackSection,"OptmDir","1",inipath);
	else 
		WritePrivateProfileString(cUnPackSection,"OptmDir","0",inipath);

	//nomkdir save...
	if( get_nomkdir(0) == true)
		WritePrivateProfileString(cUnPackSection,"NoMkDir","1",inipath);
	else 
		WritePrivateProfileString(cUnPackSection,"NoMkDir","0",inipath);

	//delarfl save...
	if( get_delarfl(0) == true)
		WritePrivateProfileString(cUnPackSection,"DelArFl","1",inipath);
	else 
		WritePrivateProfileString(cUnPackSection,"DelArFl","0",inipath);

	//PackExp, (ex. PackExp=Lzh,Zip,Cab,Tgz,Yz1 )
	WritePrivateProfileString(cUnPackSection,"PackExp",get_packexp(tmppath),inipath);

// [Pack] Section.
	//PackMxd. (Default:Frostice.mxd)
/* ** Temp Comment out.
	WritePrivateProfileString(cPackSection,"PackMxd",get_packmxd(tmppath),inipath);
*/
	delete [] tmppath;
	delete [] dskpath;
	delete [] sp_path;

	delete [] pathbuf;
	delete [] inipath;
	
}
