///////////////////////////////////////////////////////////////////////////////
//
// dll for Meltice eXtenDing "MXD_SMPL.MXD"
//
//   Meltice    : Meltice 2.0.x Copyright (C)2000-2001 ardry.
//   Base Engine: None (MXD Sample.)
//
///////////////////////////////////////////////////////////////////////////////
// MXD_SMPL.CPP = Meltice Plug-ins / dll for Meltice eXtenDing  SaMPLe.
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#define EXPORT extern "C" __declspec(dllexport)

#define MXDVER				2345
	// MXD Ver.2.34.5
#define MXD_PROTOCOL_VER	2000
	// MXD Protocol Ver.2.00.0, for Meltice Beta. 2.0.0.57 or later.
#define OBJNAME				"MXDSAMPLEMxd"
	// This object is "MXDSAMPLEMxd".

//For DLL Dialog
HINSTANCE	hInstance;
HWND		hWnd; 


int WINAPI DllMain(HINSTANCE hInst, DWORD fdReason, PVOID)
{
	switch (fdReason) 
	{
		case DLL_PROCESS_ATTACH:
			hInstance = hInst;
			hWnd = (HWND) CreateFileMapping((HANDLE)0xFFFFFFFF, NULL, 
				PAGE_READWRITE, 0, 1024, OBJNAME);
			break;
		case DLL_PROCESS_DETACH:
			CloseHandle(hWnd);
			break;
		default:
			break;
	}
	return TRUE;
};
// DLL Version.
EXPORT int WINAPI MxdGetVersion(void)
{
	return MXDVER;
};

// DLL Protocol Version.
EXPORT int  WINAPI MxdGetProtocolVersion(void)
{
	return MXD_PROTOCOL_VER;
};


EXPORT bool WINAPI MxdConfigName(char *szbuf, const int iMode, const int iLang)
{
	if(iLang==932 && iMode==1) //Japanese, and Unpack settings.
	{
		lstrcpy(szbuf, "MXD R[hTv");
	}else if(iMode==1) //Japanese, and Unpack settings.
	{
		lstrcpy(szbuf, "MXD Code Sample.");
	}
	return true;
}


EXPORT bool WINAPI MxdConfigDialog(const HWND hWnd, LPSTR, const int iMode)
{
	char buf[2048];
	
	if(iMode==0)
	{
		if(GetACP()==932){ //Japanese
		wsprintf(buf, 
			"MXD_SMPL.MXD Ver.%d.%02d.%d (MXD Protocol v%d.%02d.%d)\n\n ̃o[W\̓TvłB",
			MXDVER/1000, (MXDVER%1000)/10, MXDVER%10,	// mxd ver.
			MXD_PROTOCOL_VER/1000, (MXD_PROTOCOL_VER%1000)/10, MXD_PROTOCOL_VER%10);
														// MXD Protocol ver.
		}else{
		wsprintf(buf, 
			"MXD_Smpl.mxd Ver.%d.%02d.%d (MXD Protocol v%d.%02d.%d)\n\n This is Sample Version Info.",
			MXDVER/1000, (MXDVER%1000)/10, MXDVER%10,	// mxd ver.
			MXD_PROTOCOL_VER/1000, (MXD_PROTOCOL_VER%1000)/10, MXD_PROTOCOL_VER%10);
														// MXD Protocol ver.
		}
	}else if(iMode==1)
	{
		if(GetACP()==932){ //Japanese
			wsprintf(buf, 
				"𓀐ݒp_CAO@Tv");
		}else{
			wsprintf(buf, 
				"Sample: Unpack Setting.");
		}
	}else if(iMode==2)
	{
		if(GetACP()==932){ //Japanese
			wsprintf(buf, 
				"kݒp_CAO@Tv");
		}else{
			wsprintf(buf, 
				"Sample: Pack Setting.");
		}
	}
	MessageBox(hWnd, buf,
		"MXD_SMPL.MXD Config.", 
		MB_ICONINFORMATION);
	return false; // No config...
}


//Check Archive.
EXPORT bool WINAPI MxdCheckArchive(const char * /*filename*/)
{
	return false; //Not Supported.
}

EXPORT bool  WINAPI MxdUnpackArchive(const char * /*filename*/,const char * /*outputdir*/)
{
	return false;
}

EXPORT bool WINAPI MxdPackArchive(const char * /*filenames*/,const char * /*basedir*/)
{
	return false;
}
