///////////////////////////////////////////////////////////////////////////////
//
// Frostice Core for Common Archiver Library v2.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// FW_DIALG.CPP = Frostice Window group / DIALoG func.
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <windowsx.h>

#include "..\mxd_frtc.h"
#include ".\resource.h"

//for Meltice Family version info.
#include "..\..\..\utl\u_util.h"
#define BUF_LEN				4096
#define MIFVEREX_DLL_NAME	"MIFVEREX.DLL"	//MIFVEREX_DLL name.
#define MIFVEREX_DLL_PRTVER	2203				//MIFVEREX_DLL Protocol Ver. (Ver.2.20.3)

//ComboBox
LPCTSTR combostr[] = {".lzh",".zip", ".7z", ".cab", ".tar.gz",".tar.bz2",".tar.xz",".tar.lzma",".tar.zst",".gza",".bza",".yz1"};

//CheckBox, Button, TextBox Object is enabled/disabled.
//hDlg = Dialog hWnd.
//hCnt = Control code(int). (CheckBox, Button, TextBox, etc.)
//sw   = true ->enable / false->disable.
static void ControlEnable(HWND hDlg, int iCnt, bool sw)
{
	EnableWindow(GetDlgItem(hDlg,iCnt),sw);// hRec on hDlg enable or disable from sw.
}

//CheckBox, Button, TextBox Object is visible/invisible.
//hDlg = Dialog hWnd.
//hCnt = Control code(int). (CheckBox, Button, TextBox, etc.)
//sw   = true ->visible / false->invisible.
static void ControlVisible(HWND hDlg, int iCnt, bool sw)
{
	ShowWindow(GetDlgItem(hDlg,iCnt),sw);// hRec on hDlg visible or invisible from sw.
}

//GUI util forPackLevel 
//mode = 1. lzh 2. zip 3. 7z, 4. cab ... (expmode.)
static void Change_TrackBarForArchive(HWND hDlg,int mode)
{
	int iPackLevel = get_packlvl();
	char cPackInfo[20];

	SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL),TBM_SETPOS,(WPARAM)TRUE,(LPARAM)iPackLevel);
	SendMessage(GetDlgItem(hDlg, IDC_CHK_LEVEL), BM_SETCHECK, (WPARAM)(iPackLevel!=0), 0L);
	
	//YZ1 mode.
	if(mode == MODE_YZ1)
	{
		Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), " auto");
		ControlEnable(hDlg,IDC_LB_LVINFO,false);
		ControlEnable(hDlg,IDC_SLIDER_LEVEL,false);
	}
	//zstd mode.
	else if(mode == MODE_TZS)
	{
		if(iPackLevel == 0)
			Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), " auto");
		else
		{
			switch(iPackLevel)
			{
				case 1:
					wsprintf(cPackInfo," Level %d",1);
					break;
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
					wsprintf(cPackInfo," Level %d",(iPackLevel-1)*3);
					break;
				case 8:
					wsprintf(cPackInfo," Level %d",19);
					break;
				case 9:
					wsprintf(cPackInfo," Level %d",22);
					break;
				case -1: //nocomp (disabled)
				case  0: //auto (Lv3)
				case  2: //2   = Lv3
				default:
					wsprintf(cPackInfo," Level %d",3);
				break;
			}
			Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
		}
	}
	else if(iPackLevel == 0)
	{
		Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), " auto");
	}
	else
	{
		switch(mode)
		{
			case MODE_LZH: //lzh
				if     (iPackLevel ==-1)wsprintf(cPackInfo," -lh0-");
				else if(iPackLevel ==1) wsprintf(cPackInfo," -lh1-");
				else if(iPackLevel <=4) wsprintf(cPackInfo," -lh5-");
				else if(iPackLevel >=8) wsprintf(cPackInfo," -lh? auto-");
				else wsprintf(cPackInfo," -lh%d-",iPackLevel);
				Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
				break;
			case MODE_7Z:  //7z
				switch(iPackLevel)
				{
				case -1:
					wsprintf(cPackInfo," Level %d",0);
					break;
				case 2:
				case 3:
				case 4:
					wsprintf(cPackInfo," Level %d",1);
					break;
				case 6:
					wsprintf(cPackInfo," Level %d",5);
					break;
				case 8:
					wsprintf(cPackInfo," Level %d",7);
					break;
				default:
					wsprintf(cPackInfo," Level %d",iPackLevel);
					break;
				}
				Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
				break;
			case MODE_CAB: //cab
				if     (iPackLevel ==-1) wsprintf(cPackInfo," nocomp");
				else if(iPackLevel == 1) wsprintf(cPackInfo," MSZIP");
				else if(iPackLevel >=2 && iPackLevel <= 8) wsprintf(cPackInfo," LZX/%d",iPackLevel+13);
				else wsprintf(cPackInfo," LZX/21");
				Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
				break;
			default:
				if(iPackLevel != -1)
				{
					wsprintf(cPackInfo," Level %d",iPackLevel);
				}else{
					wsprintf(cPackInfo," Level %d",0);
				}
				Static_SetText(GetDlgItem(hDlg, IDC_LB_LVINFO), cPackInfo);
		}
	}
}

//All CheckBox Enable and Disable for Archive files.
//mode = 1. lzh 2. zip 3. 7z ... (expmode.)
static void Change_ChkboxEnableForArchive(HWND hDlg,int mode)
{
	//dosname = lzh,zip,cab only.
	if(mode == MODE_LZH ||
	   mode == MODE_ZIP ||
	   mode == MODE_CAB  )
		ControlEnable(hDlg,IDC_CHK_DOSNAME,true);
	else
		ControlEnable(hDlg,IDC_CHK_DOSNAME,false);
	
	//SFX = lzh,zip,7z,cab,gza,bza,yz1
	if(mode == MODE_LZH ||
	   mode == MODE_ZIP ||
	   mode == MODE_7Z  ||
	   mode == MODE_CAB ||
	   mode == MODE_GZA ||
	   mode == MODE_BZA ||
	   mode == MODE_YZ1  )
	{
		ControlEnable(hDlg,IDC_CHK_SFX,true);
		ControlEnable(hDlg,IDC_CHK_MD5HASH,!get_withsfx());
	}else{
		ControlEnable(hDlg,IDC_CHK_SFX,false);
		ControlEnable(hDlg,IDC_CHK_MD5HASH,true);
	}
	
	//Password = zip,7z,yz1 only.
	if(mode == MODE_ZIP || 
	   (mode == MODE_7Z &&!get_withsfx())  ||
	   mode == MODE_YZ1  )
		ControlEnable(hDlg,IDC_CHK_PASSWD,true);
	else
		ControlEnable(hDlg,IDC_CHK_PASSWD,false);
		
	//Pack Level.
	if(mode == MODE_YZ1 )
	{
		ControlEnable(hDlg,IDC_CHK_LEVEL,false);
		ControlEnable(hDlg,IDC_LB_LVINFO,false);
		ControlEnable(hDlg,IDC_SLIDER_LEVEL,false);
		set_packlvl(0);
		Change_TrackBarForArchive(hDlg,mode);
	}else{
		ControlEnable(hDlg,IDC_CHK_LEVEL,true);
		if(get_packlvl() != 0)
		{
			ControlEnable(hDlg,IDC_LB_LVINFO,true);
			ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
		}
		Change_TrackBarForArchive(hDlg,mode);
	}
}

static void set_defaultpacklevel(const int expmode)
{
	switch(expmode)
	{
		case MODE_LZH: //lzh
		case MODE_7Z:  //7z
			set_packlvl(5);
			break;
		case MODE_ZIP: //zip
			set_packlvl(6);
			break;
		case MODE_CAB: //cab
			set_packlvl(1);
			break;
		case MODE_TBZ: //tar.bz2
		case MODE_BZA: //bza
			set_packlvl(9);
			break;
		case MODE_TGZ: //tar.gz
		case MODE_TXZ: //tar.xz
		case MODE_TLZ: //tar.lzma
		case MODE_GZA: //gza
			set_packlvl(6);
			break;
		case MODE_TZS: //tar.zstd
			set_packlvl(2);
			break;
	}
	return;
}

//For Meltice Family version info. Ver.2.1.16+ (mxd Ver.2.19.6+)
bool w_show_ardllver_ex(HWND hDlg)
{
	bool ret = false;
	
	char *tmpbuf = new char[BUF_LEN];
	get_exec_dir(tmpbuf,BUF_LEN);
	lstrcpyn(tmpbuf,MIFVEREX_DLL_NAME, BUF_LEN);	
	HINSTANCE  hInstDll = LoadLibrary(tmpbuf);

	if(hInstDll!=NULL)
	{
		typedef WORD (WINAPI *PGETVERFUNC)();     //for GetVer (MveGetProtocolVer)
		typedef WORD (WINAPI *PPUTDLGFUNC)(HWND); //for PutDlg (MvePutVersionDialog)
		typedef void (WINAPI *PSETMIFFUNC)(LPCSTR);  //for SetMif (MveSetMelticeVer)
		PGETVERFUNC GetVer = (PGETVERFUNC) GetProcAddress(hInstDll, "MveGetProtocolVer");
		PPUTDLGFUNC PutDlg = (PPUTDLGFUNC) GetProcAddress(hInstDll, "MvePutVersionDialog");
		PSETMIFFUNC SetMif = (PSETMIFFUNC) GetProcAddress(hInstDll, "MveSetMelticeVer");

		if(GetVer != NULL && PutDlg != NULL && SetMif != NULL)
		{
			//for Meltice.exe, disabled.
			//get_msgcfg_string(tmpbuf, IDS_STR_VERSION);
			//(void)(*SetMif)(tmpbuf);
			int mve_protocol_ver = (int)(*GetVer)();
			
			if(mve_protocol_ver ==MIFVEREX_DLL_PRTVER)
			{
				(void)(*PutDlg)(hDlg);
				ret=true;
			}
		}
	}
	delete [] tmpbuf;
	return ret;
}

//Dialog Procedure. //Config Dialog
LRESULT CALLBACK FTCCNFDLGProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
	//Dialog...
	UINT CodePage;
	if(get_autolang()==true)
		CodePage = GetACP();
	else CodePage = 9999; //dummy.

	int i;
	char dlgtitle[MAX_PATH*2+1]; //Dialog Title (ex. filename.zip - Frostice)
	char filename[MAX_PATH+1];
	static char filename_org[MAX_PATH+1]; //Original Settings.
	char dirname[MAX_PATH+1];
	static char dlgtitle_init[] = "%s%s - Frostice";
	int expmode;

	//}`j^Ή by Ver.2.2.2-2012
	static BOOL isMinusXYEnabled;

  //// for DnD...
	HDROP hDrop;
	UINT uFileNo;
	char *szFileNames;
	char szFileName[MAX_PATH+1];
	char szBaseDir[MAX_PATH+1];
	char szFileNameBuf[MAX_PATH+1];
	
	//for AutoComplete
	typedef HRESULT (WINAPI *SHAUTOCOMPLETE)(HWND hwndEd, DWORD dwFlg);
	SHAUTOCOMPLETE SHAutoCompleteAPI;
	HANDLE hSHLWAPIDLL=NULL;
	if( get_autocmpl()== true)
	{
		hSHLWAPIDLL = LoadLibrary("SHLWAPI.DLL");
		CoInitialize(NULL);
	}

	switch (uMsg)
	{
		//for WM_INITDIALOG and WM_EXITSIZEMOVE.
		RECT deskrc; //desktop rc.
		RECT rc;
		int x,y;

		//for WM_EXITSIZEMOVE.
		int margin;
		bool isautomoved;

		case WM_INITDIALOG:

			//EVtgL[̂ݔ
			if(::GetAsyncKeyState(VK_RSHIFT) & 0x8000 ){
				isMinusXYEnabled = TRUE;
			}
			else
			{
				isMinusXYEnabled = FALSE;
			}

			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			x = get_dialog_sub_x(); y = get_dialog_sub_y();
			if(x == -9999) x = (deskrc.right - (rc.right-rc.left)) / 2;
			else if(isMinusXYEnabled ==FALSE)
			{
				if(x < deskrc.left) x = deskrc.left;
				else if(x > (deskrc.right - (rc.right-rc.left))) x=(deskrc.right - (rc.right-rc.left));
			}
			if(y == -9999) y = (deskrc.bottom - (rc.bottom-rc.top)) /2;
			else if(isMinusXYEnabled ==FALSE)
			{
				if(y < deskrc.top) y = deskrc.top;
				else if(y > (deskrc.bottom - (rc.bottom-rc.top)))y=(deskrc.bottom - (rc.bottom-rc.top));
			}

			SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);

		//////Load Filename for Pack.
			SendMessage(GetDlgItem(hDlg, IDC_CHK_DOSNAME), BM_SETCHECK, (WPARAM)get_dosname(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_PASSWD), BM_SETCHECK, (WPARAM)get_withpwd(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_MD5HASH), BM_SETCHECK, (WPARAM)get_withmd5(), 0L);

			ControlEnable(hDlg,IDC_GRP_NEWFILE,true);
			get_destfile(filename,MAX_PATH);
			lstrcpy(filename_org,filename);
			
			if(lstrcmp(filename,DUMMYMSG_FOR_CONFIG)!=0) //for Pack Settings
			{
				Static_SetText(GetDlgItem(hDlg, IDC_ED_NEWFILE), filename);//filename -> TextBox Label.
				ControlEnable(hDlg,IDC_LB_NEWFILE,true);
				ControlEnable(hDlg,IDC_ED_NEWFILE,true);
			}else{ //Config Dialog
				char *str_automatic = new char[MAX_PATH+1];
				int transcode = 0;
				if(CodePage == IDS_STR_JPN_CODEPAGE)
				{
					transcode += IDS_STR_ADD_FORJPN;
				}
				LoadString(get_dll_instance(),IDS_STR_CNFFILENAME+transcode,str_automatic,MAX_PATH+1);
				Static_SetText(GetDlgItem(hDlg, IDC_ED_NEWFILE), str_automatic);//filename -> TextBox Label.
				delete [] str_automatic;
			}

			expmode = get_destexpcode();

			for (i = 0; i <= 11; i++ )
				SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_INSERTSTRING, (WPARAM)i, (LPARAM)combostr[i]);
			SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_SETCURSEL, (WPARAM)expmode-1, 0L);
			ControlEnable(hDlg,IDC_LB_EXP,true);
			ControlEnable(hDlg,IDC_COMBO_EXP,true);
			Change_ChkboxEnableForArchive(hDlg,expmode);

			//TrackBar SetRange (Min=-1(no compress);0(auto); Max=9)
			SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL), TBM_SETRANGE, (WPARAM)TRUE, (LPARAM)MAKELPARAM(-1, 9));
			SendMessage(GetDlgItem(hDlg, IDC_CHK_LEVEL), BM_SETCHECK, (WPARAM)(get_packlvl()!=0), 0L);

			if(get_packlvl()!=0 && expmode != 8)
			{
				ControlEnable(hDlg,IDC_LB_LVINFO,true);
				ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
				Change_TrackBarForArchive(hDlg,expmode);
			}

		//////Load DestDir for Pack.
			SendMessage(GetDlgItem(hDlg, IDC_CHK_OPENDIR), BM_SETCHECK, (WPARAM)get_opendir(0), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SAMEDIR), BM_SETCHECK, (WPARAM)get_samedir(0), 0L);

			ControlEnable(hDlg,IDC_GRP_DESTDIR,true);
			ControlEnable(hDlg,IDC_CHK_OPENDIR,true);
			ControlEnable(hDlg,IDC_CHK_SAMEDIR,true);
			//SameDir?
			if( get_samedir(0) == false)
			{
				ControlEnable(hDlg,IDC_LB_DESTDIR,true);
				ControlEnable(hDlg,IDC_ED_DESTDIR,true);
				ControlEnable(hDlg,IDC_BTN_BROWSE,true);
				ControlEnable(hDlg,IDC_BTN_OPEN,true);
			}
			get_destdir(dirname,MAX_PATH,0);
			Static_SetText(GetDlgItem(hDlg, IDC_ED_DESTDIR), dirname);//filename -> TextBox Label.

		//////Info. and Apply.
			ControlEnable(hDlg,IDC_BTN_INFO,true);
			if(lstrcmp(filename,DUMMYMSG_FOR_CONFIG)==0) // APPLY enable for Properties only..
				ControlEnable(hDlg,IDC_BTN_APPLY,true);

		//////SimpleGUI... (Silent mode.)
			ControlEnable(hDlg,IDC_CHK_SILENT,true);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SILENT), BM_SETCHECK, (WPARAM)get_smplgui(), 0L);

		//////Read only? (if readonly then OK/Apply is disabled.)
			if( get_cfg_readonly() == true )
			{
				if(lstrcmp(filename,DUMMYMSG_FOR_CONFIG)==0)
					ControlEnable(hDlg, IDOK, false);    //OK Button is disabled when settings dialog.
				ControlEnable(hDlg, IDC_BTN_APPLY, false); //Apply Button is disabled.
			}

		//////Drag and Drop for Dialog.
			if(lstrcmp(filename,DUMMYMSG_FOR_CONFIG)==0) //for Config Dialog
			{
				DragAcceptFiles(hDlg, TRUE);
			}
		//////for AutoComplete
			if( get_autocmpl()== true && hSHLWAPIDLL != NULL)
			{
				SHAutoCompleteAPI = (SHAUTOCOMPLETE) GetProcAddress((HINSTANCE)hSHLWAPIDLL, "SHAutoComplete");
				if (SHAutoCompleteAPI)
					//SHAutoCompleteAPI(hEdit, SHACF_FILESYSTEM);
					SHAutoCompleteAPI(GetDlgItem(hDlg, IDC_ED_DESTDIR), 1);
				FreeLibrary((HINSTANCE)hSHLWAPIDLL);
			}
			
			SetActiveWindow(hDlg);
			SetForegroundWindow(hDlg);

			return true;

		case WM_EXITSIZEMOVE:
			margin=10;
			isautomoved=false;

			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			x = rc.left; y = rc.top;

			if(isMinusXYEnabled ==FALSE)
			{
				if(x < deskrc.left+margin){x = deskrc.left; isautomoved = true;}
				else if(x + margin > (deskrc.right - (rc.right-rc.left))){ x=(deskrc.right - (rc.right-rc.left)); isautomoved = true;}
				if(y < deskrc.top+margin){ y = deskrc.top; isautomoved = true;}
				else if(y + margin > (deskrc.bottom - (rc.bottom-rc.top))){ y=(deskrc.bottom - (rc.bottom-rc.top)); isautomoved = true;}
				if(isautomoved==true)
				{
					SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);
				}
			}

			set_dialog_sub_x(x);
			set_dialog_sub_y(y);
			return true;

		case WM_DROPFILES:
			hDrop = (HDROP)wParam;
			uFileNo = DragQueryFile((HDROP)wParam, 0xFFFFFFFF, NULL, 0);
			szFileNames = new char[MAX_PATH*(uFileNo+4)];
			*szFileNames = '\0';
			for(i = 0; i < (int)uFileNo; i++) {
				DragQueryFile(hDrop, i, szFileName, sizeof(szFileName));
				if(i==0)
				{
					lstrcpy(szFileNameBuf,szFileName);
					lstrcpy(szBaseDir, "\""); lstrcat(szBaseDir, get_dirname(szFileNameBuf)); lstrcat(szBaseDir, "\" ");
				}
				lstrcpy(szFileNameBuf,szFileName);
				lstrcat(szFileNames, "\""); lstrcat(szFileNames, get_filename(szFileNameBuf)); 
				if(GetFileAttributes(szFileNameBuf)& FILE_ATTRIBUTE_DIRECTORY)
					lstrcat(szFileNames,"\\*");
				lstrcat(szFileNames, "\" ");
			}
		////// Lock Config Window and show archiving dialog...
			ShowWindow(hDlg,SW_HIDE); EnableWindow(hDlg,false); //Config Dialog hide.
			pack_archive(szFileNames,szBaseDir);
			EnableWindow(hDlg,true); ShowWindow(hDlg,SW_SHOW);//Config Dialog show.
		////// for Properties Dialog Initialization...
			set_destfile(DUMMYMSG_FOR_CONFIG,MAX_PATH);
			lstrcpy(filename_org,DUMMYMSG_FOR_CONFIG);

			SendMessage(GetDlgItem(hDlg, IDC_CHK_DOSNAME), BM_SETCHECK, (WPARAM)get_dosname(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_PASSWD), BM_SETCHECK, (WPARAM)get_withpwd(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SFX), BM_SETCHECK, (WPARAM)get_withsfx(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_MD5HASH), BM_SETCHECK, (WPARAM)get_withmd5(), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SILENT), BM_SETCHECK, (WPARAM)get_smplgui(), 0L);
			expmode = get_destexpcode();
			Change_ChkboxEnableForArchive(hDlg,expmode);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_LEVEL), BM_SETCHECK, (WPARAM)(get_packlvl()!=0), 0L);
			if(get_packlvl()!=0 && expmode != 8)
			{
				ControlEnable(hDlg,IDC_LB_LVINFO,true);
				ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
				Change_TrackBarForArchive(hDlg,expmode);
			}
			SendMessage(GetDlgItem(hDlg, IDC_CHK_OPENDIR), BM_SETCHECK, (WPARAM)get_opendir(0), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_SAMEDIR), BM_SETCHECK, (WPARAM)get_samedir(0), 0L);
			if( get_samedir(0) == false)
			{
				ControlEnable(hDlg,IDC_LB_DESTDIR,true);
				ControlEnable(hDlg,IDC_ED_DESTDIR,true);
				ControlEnable(hDlg,IDC_BTN_BROWSE,true);
				ControlEnable(hDlg,IDC_BTN_OPEN,true);
			}
			SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_SETCURSEL, (WPARAM)expmode-1, 0L);
			get_destdir(dirname,MAX_PATH,0);
			Static_SetText(GetDlgItem(hDlg, IDC_ED_DESTDIR), dirname);//filename -> TextBox Label.
			
			//DialogBox Title restore...
			{
				char *str_title = new char[MAX_PATH+1];
				int transcode = 0;
				if(CodePage == IDS_STR_JPN_CODEPAGE)
				{
					transcode += IDS_STR_ADD_FORJPN;
				}
				LoadString(get_dll_instance(),IDS_STR_CNFDIALOGTITLE+transcode,str_title,MAX_PATH+1);
				SetWindowText(hDlg,str_title);
				delete [] str_title;
			}
			return false;
		case WM_HSCROLL:
			expmode = get_destexpcode();
			set_packlvl((int)SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL),TBM_GETPOS,(WPARAM)0L,(LPARAM)0L));

			if(expmode >= MODE_TGZ && get_packlvl() == -1)
			{
				set_packlvl(0);
				SendMessage(GetDlgItem(hDlg, IDC_CHK_LEVEL), BM_SETCHECK, (WPARAM)(get_packlvl()!=0), 0L);
			}

			Change_TrackBarForArchive(hDlg,expmode);
			break;
		case WM_COMMAND:
			static int orgexpmode = get_destexpcode();
			switch (LOWORD(wParam)) {
			////// button
				case IDOK:
					if(get_smplgui()==true)
						memcfg_to_inicfg(NULL);
					else if(lstrcmp(filename_org,DUMMYMSG_FOR_CONFIG)==0) //for Config Dialog
						memcfg_to_inicfg(NULL);
						EndDialog(hDlg, IDOK); //end.
					break;
				case IDCANCEL:
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case IDC_BTN_APPLY:
					memcfg_to_inicfg(NULL);
					break;
				case IDC_BTN_INFO:
					//ardllver_ex version info for Meltice Family
					if(w_show_ardllver_ex(hDlg) == true) break;
					//Frostice.mxd version info (Classic)
					ver_info_dialog(hDlg);
					break;
				case IDC_COMBO_EXP:
					set_destexpcode((int)(DWORD)SendMessage(GetDlgItem(hDlg, IDC_COMBO_EXP), CB_GETCURSEL, 0L, 0L)+1);
					expmode = get_destexpcode();
					if(get_packlvl() != 0)
					{
						if(orgexpmode != expmode)
						{
							set_defaultpacklevel(expmode);
							orgexpmode = expmode;
						}
					}
					Change_TrackBarForArchive(hDlg,expmode);
					set_packlvl((int)SendMessage(GetDlgItem(hDlg, IDC_SLIDER_LEVEL),TBM_GETPOS,(WPARAM)0L,(LPARAM)0L));
					Change_ChkboxEnableForArchive(hDlg,expmode);
					Change_TrackBarForArchive(hDlg,expmode);
					//IDC_ED_NEWFILE must be run after IDC_COMBO_EXP...
				case IDC_ED_NEWFILE:
					if(lstrcmp(filename_org,DUMMYMSG_FOR_CONFIG)!=0) //for Pack Settings
					{
						GetDlgItemText(hDlg, IDC_ED_NEWFILE, (LPTSTR)filename, sizeof(filename));
						set_destfile(filename, MAX_PATH);
						wsprintf(dlgtitle,dlgtitle_init,filename,combostr[get_destexpcode()-1]);
						SetWindowText(hDlg,dlgtitle);
					}
					break;
				case IDC_ED_DESTDIR:
					GetDlgItemText(hDlg, IDC_ED_DESTDIR, (LPTSTR)dirname, sizeof(filename));
					if( get_samedir(0) == false)
						set_destdir(dirname, MAX_PATH,0);
					break;
				case IDC_BTN_OPEN:
					get_destdir(dirname,MAX_PATH,0);
					DWORD fa;
					fa = GetFileAttributes(dirname);
					if(fa & FILE_ATTRIBUTE_DIRECTORY){ //Folder.
						char *buf = new char[MAX_PATH*4+1];
						char *opdirpath = new char[MAX_PATH+1]; // Open Folder Path.
						char *opdiropt = new char[MAX_PATH+1]; // Open Folder Options.
						get_opdirex(opdirpath, MAX_PATH, 0);
						get_opdiropt(opdiropt, MAX_PATH, 0);
						wsprintf(buf,"%s \"%s\"", opdiropt, dirname);
						//WinExec(buf, SW_SHOW);
						ShellExecute(NULL, "open", opdirpath, buf, dirname, SW_SHOW);

						delete [] opdiropt;
						delete [] opdirpath;
						delete [] buf;
					}
					break;
				case IDC_BTN_BROWSE:
					get_destdir(dirname, MAX_PATH, 0);
					{
						char *strbuf = new char[MAX_PATH];
						{
							int transcode = 0;
							if(CodePage == IDS_STR_JPN_CODEPAGE)
							{
								transcode += IDS_STR_ADD_FORJPN;
							}
							LoadString(get_dll_instance(),IDS_STR_BROWSEFLD_PAK+transcode,strbuf,MAX_PATH);
						}
						i = browse_folder(hDlg, dirname, strbuf);
						delete [] strbuf;
					}
					set_destdir(dirname, MAX_PATH, 0);
					get_destdir(dirname, MAX_PATH, 0);
					if(i != 0 ){ //not cancel
						Static_SetText(GetDlgItem(hDlg, IDC_ED_DESTDIR), dirname);//New Dir overwrite TextBox
					}
					break;
				case IDC_CHK_SAMEDIR:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_SAMEDIR) == BST_CHECKED) {
						set_samedir(true,0);
					}else{
						set_samedir(false,0);
					}
					ControlEnable(hDlg,IDC_LB_DESTDIR,!get_samedir(0));
					ControlEnable(hDlg,IDC_ED_DESTDIR,!get_samedir(0));
					ControlEnable(hDlg,IDC_BTN_BROWSE,!get_samedir(0));
					ControlEnable(hDlg,IDC_BTN_OPEN,!get_samedir(0));
					break;
				case IDC_CHK_OPENDIR:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_OPENDIR) == BST_CHECKED) {
						set_opendir(true,0);
					}else{
						set_opendir(false,0);
					}
					break;
				case IDC_CHK_DOSNAME:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_DOSNAME) == BST_CHECKED) {
						set_dosname(true);
					}else{
						set_dosname(false);
					}
					break;
				case IDC_CHK_SFX:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_SFX) == BST_CHECKED) {
						set_withsfx(true);
					}else{
						set_withsfx(false);
					}
					Change_ChkboxEnableForArchive(hDlg,get_destexpcode());
					break;
				case IDC_CHK_PASSWD:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_PASSWD) == BST_CHECKED) {
						set_withpwd(true);
					}else{
						set_withpwd(false);
					}
					break;
				case IDC_CHK_MD5HASH:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_MD5HASH) == BST_CHECKED) {
						set_withmd5(true);
					}else{
						set_withmd5(false);
					}
					break;
				case IDC_CHK_LEVEL:
					expmode = get_destexpcode();
					if(IsDlgButtonChecked(hDlg, IDC_CHK_LEVEL) == BST_CHECKED) {
						ControlEnable(hDlg,IDC_LB_LVINFO,true);
						ControlEnable(hDlg,IDC_SLIDER_LEVEL,true);
						set_defaultpacklevel(expmode);
						Change_TrackBarForArchive(hDlg,expmode);
					}else{
						ControlEnable(hDlg,IDC_LB_LVINFO,false);
						ControlEnable(hDlg,IDC_SLIDER_LEVEL,false);
						set_packlvl(0);
						Change_TrackBarForArchive(hDlg,expmode);
					}
					break;
				case IDC_CHK_SILENT:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_SILENT) == BST_CHECKED) {
						set_smplgui(true);
					}else{
						set_smplgui(false);
					}
				default:
					break;
			}
	}
	return FALSE;
}

