///////////////////////////////////////////////////////////////////////////////
//
// dll for Meltice eXtenDing "DBLCLICK.MXD"
//
//   Meltice    : Meltice 2.2.x Copyright (C)2000-2024 Meltice Family Project.
//   Base Engine: None (Lzh and Zip and etc have Association to Meltice.)
//
///////////////////////////////////////////////////////////////////////////////
// DBLCLICK.CPP = Meltice Plug-ins / melt archive when DouBLe Click file icon.
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include ".\dlg\resource.h"

#if _MSC_VER >= 1000
#include "..\..\utl\u_util.h"
#elif __BORLANDC__ >= 1
#include ".\u_util.h"
#endif

#define EXPORT extern "C" __declspec(dllexport)

#define MXDVER				2261
	// MXD Ver.2.26.1 (Build 31)
#define MXD_PROTOCOL_VER	2000
	// MXD Protocol Ver.2.00.0, for Meltice. 2.0.0.57 or later.
#define OBJNAME				"DBLCLICKMxd"
	// This object is "DBLCLICKMxd".

//For DLL Dialog
HINSTANCE	hInstance;
HWND		hWnd; 

///////////////////////////////////////////////////////////////////////////////
//
// For switching Windows 9x/NT kernel.
//

#include <lm.h>
#include <tchar.h>

//IsPlatformWin32NT()
// ret : true  -> Windows NT, 2000, XP/2003, Vista, 7/2008, 8/2012, or later.
//       false -> Windows 9x, Me.
//
//http://www.nt.sakura.ne.jp/~miwaki/progtips/shell/getversionex.shtml
bool IsPlatformWin32NT(void)
{
  OSVERSIONINFO osVer;
  osVer.dwOSVersionInfoSize = sizeof(osVer);

  // Get Windows Version Information.
  GetVersionEx(&osVer);

  //Is this Windows NT kernel OS?
  if (osVer.dwPlatformId == VER_PLATFORM_WIN32_NT)
    return true;

  return false;
}

//GetOSVer for WinVista
int GetOSMajorVer()
{
	OSVERSIONINFO osVer;
	osVer.dwOSVersionInfoSize = sizeof(osVer);
	GetVersionEx(&osVer);
	return osVer.dwMajorVersion;
}

//IsAdmin(void)
//  ret : true  -> Current user is administrators. (include Win9x all users.)
//        false -> Current user is normal user at WinNT/2000/XP/2003/Vista/7/8.
//
bool IsAdmin(void)
{
	if(IsPlatformWin32NT()==false) return true; // All Win9x user is administrator!?
	bool isadmin = false;
	char *bufp; char buf[256]; bufp = &buf[0];
	char user[256];
	DWORD dwBuffer = 256;
	GetUserName(user,&dwBuffer);

	wchar_t *Username; 	wchar_t uname[256]; Username = &uname[0];
	wchar_t *Group_Name;
	LPBYTE	Buffptr;
	DWORD	Entriesread;
	DWORD	Totalentries;

	LPGROUP_INFO_0	GroupInfo;
	
	MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,user,-1,Username,255);

	//for Windows 9x.
	static char lpstrSystemDirDll[MAX_PATH+1];
	GetSystemDirectory(lpstrSystemDirDll, MAX_PATH);
	lstrcat(lpstrSystemDirDll, "\\NETAPI32.DLL");
	HINSTANCE  hInstDll = LoadLibrary(lpstrSystemDirDll);
	if(hInstDll == NULL) return false;
	typedef NET_API_STATUS (NET_API_FUNCTION *PNETUSRGETLCLGRP)(LPCWSTR,wchar_t *,DWORD,DWORD,VOID*,DWORD,LPDWORD,LPDWORD);
	PNETUSRGETLCLGRP pNetUserGetLocalGroups = (PNETUSRGETLCLGRP)GetProcAddress(hInstDll, "NetUserGetLocalGroups");
	if(pNetUserGetLocalGroups == NULL){
		SetLastError(1); //BadFunction!
		return false;
	}
	
	NET_API_STATUS iNAStat = (*pNetUserGetLocalGroups)(NULL,Username,0,0,&Buffptr,256*256, &Entriesread,&Totalentries);
	if( iNAStat == 0)  // NERR_Success = 0.
	{
		for(unsigned int i=0;i<Entriesread;i++){
			GroupInfo	=(LPGROUP_INFO_0)Buffptr;
			Group_Name	=_TEXT(GroupInfo[i].grpi0_name);
			wcstombs(bufp,Group_Name,256 );
			if( lstrcmp(buf,"Administrators") == 0) isadmin = true;
		}
	}else{
		SetLastError(iNAStat);
		return false;
	}

	return isadmin;
}
/*
//DEBUG Func.
int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	if(IsAdmin()==true) MessageBox(0,"You can permit Administrators group.","",0);
	else MessageBox(0,"You can't permit Administrators group.","",0);
	return 0;
}
*/

///////////////////////////////////////////////////////////////////////////////
//
// Extract engine Useable?
//

//Defines. (0-8 is Meltice Compatible.)
#define MODE_NOT_SUPPORT	0
#define MODE_LZH	1
#define MODE_ZIP	2
#define MODE_7Z		3
#define MODE_CAB	4
#define MODE_TAR	5
#define MODE_BGA	6
#define MODE_YZ1	7
#define MODE_ARJ	11
#define MODE_GCA	12
#define MODE_RAR	13
#define MODE_ACE	14
#define MODE_JAK	8
#define MODE_ETC	15
#define MODE_MXD	16

//isEngineUseable
// iMode <-  MODE_LZH, MODE_ZIP,... 
// ret    -> true : Useable  /  false : can't use.
bool isEngineUseable(int iMode)
{
	//Security Patch for DLL Preloading Remote Attack Vector
	static char lpstrSystemDirDll[MAX_PATH+1];
	GetSystemDirectory(lpstrSystemDirDll, MAX_PATH);
	//for Windows 9x/NT4.0/2k
	SetCurrentDirectory(lpstrSystemDirDll); 
	//for Windows 2000 SP4/Windows XP Golden (Safe DLL Search mode)
	#ifndef BASE_SEARCH_PATH_ENABLE_SAFE_SEARCHMODE
	#define BASE_SEARCH_PATH_ENABLE_SAFE_SEARCHMODE 0x1
	#endif
	lstrcat(lpstrSystemDirDll, "\\KERNEL32.DLL");
	HMODULE hKERNEL32 = GetModuleHandle(lpstrSystemDirDll);
	if(hKERNEL32)
	{
		BOOL(WINAPI * pfSetSearchPathMode)(DWORD) =
			(BOOL(WINAPI*)(DWORD)) GetProcAddress(hKERNEL32, "SetSearchPathMode");
		if(pfSetSearchPathMode != NULL)
		{
			pfSetSearchPathMode(BASE_SEARCH_PATH_ENABLE_SAFE_SEARCHMODE);
		}
	}

	//for Windows XP SP1+ / Vista / 7, Windows Server 2003+ (SetDllDirectory API Call)
	BOOL(WINAPI * pfSetDllDirectory)(LPCTSTR) =
			(BOOL(WINAPI*)(LPCTSTR)) GetProcAddress(hKERNEL32, "SetDllDirectoryA");
	if(pfSetDllDirectory != NULL)
	{
		pfSetDllDirectory("");
	}
	//Security Patch end.

	if(iMode <= MODE_NOT_SUPPORT || iMode > MODE_MXD) return false;
	bool ret;
	
	switch(iMode)
	{
		case MODE_LZH:
			if(LoadLibrary("UNLHA32.DLL")==NULL) ret=false;
			else ret=true;
			break;
		case MODE_ZIP:
			if(LoadLibrary("UNZIP32.DLL")==NULL &&
			   LoadLibrary("7-ZIP32.DLL")==NULL )
			{
				ret=false;
			}
			else ret=true;
			break;
		case MODE_7Z:
			if(LoadLibrary("7-ZIP32.DLL")==NULL) ret=false;
			else ret=true;
			break;
		case MODE_CAB:
			if(LoadLibrary("CAB32.DLL")==NULL) ret=false;
			else ret=true;
			break;
		case MODE_TAR:
			if(LoadLibrary("TAR32.DLL")==NULL) ret=false;
			else ret=true;
			break;
		case MODE_BGA:
			if(LoadLibrary("BGA32.DLL")==NULL) ret=false;
			else ret=true;
			break;
		case MODE_YZ1:
			if(LoadLibrary("YZ1.DLL")==NULL) ret=false;
			else ret=true;
			break;
		case MODE_JAK:
			if(LoadLibrary("JACK32.DLL")==NULL) ret=false;
			else ret=true;
			break;
		case MODE_ARJ:
		case MODE_GCA:
		case MODE_RAR:
		case MODE_ACE:
			if( LoadLibrary("MORECALD.MXD")==NULL ) ret=false;
			else ret=true;
			break;
		case MODE_ETC:
			if( LoadLibrary("XACRETT.MXD")==NULL ||
				LoadLibrary("MORECALD.MXD")==NULL ) ret=false;
			else ret=true;
			break;
		case MODE_MXD:
			ret=true;
			break;
		default:
			ret=false;
	}
	
	if(ret==false)
	{
		if(LoadLibrary("XacRett.mxd")==NULL) ret=false;
		else if(iMode != MODE_7Z && iMode != MODE_ETC) ret=true;
	}

	return ret;
}

///////////////////////////////////////////////////////////////////////////////
//
// Association.
//

// REGTREE.
//
// \HKCR
//   \.???
//   \PackMI.???
//     \DefaultIcon .... Icon Path   (CabView Icons.)
//     \Shell .......... DefaultTask (="Open")
//       \Open ......... Name when file open by meltice.
//         \Command  ... Meltice.exe Path.
//       \Explorer ......... Name when file open by explorer. (Zip / Cab)
//         \Command  ... Explorer + CLSID Path.


//// CheckAssociation
// exp    <- ".lzh" ".zip" ...
// family <- archive family (LHa, Zip, ...)
// ret    -> true:already associated. false:no association.
bool CheckAssociation(const char *exp, const char *family)
{
	bool ret;
	HKEY hkNow;
	DWORD dwType;

	DWORD dwByte=1024;
	char *szName   = new char[1024];
	char *szValue  = new char[1024];
	char *szBuffer = new char[1024];
	lstrcpy(szName,""); dwType = REG_SZ;

	ret=false;
  ////// .??? Open.
	if( RegOpenKeyEx(
		HKEY_CLASSES_ROOT,
		exp,
		0,
		KEY_ALL_ACCESS,
		&hkNow) != ERROR_SUCCESS )
	{
		ret=false; //No Assosiation
	}else{
		if(RegQueryValueEx(hkNow,szName,NULL,&dwType,(BYTE *)szValue,&dwByte)!= ERROR_SUCCESS)
		{
			ret=false; //No Assosiation
		}else{
			
			wsprintf(szBuffer,"PackMI.%s",family);
			if(lstrcmp(szValue,szBuffer) == 0)
			{
				ret=true;  //Association by Meltice!
			}else{
				ret=false; //Association by other software(Not meltice).
			}
		}
		RegCloseKey(hkNow);
	}
	
	delete[] szBuffer;
	delete[] szValue;
	delete[] szName;

	return ret;
}

//// CheckSubAssociation by explorer(Microsoft)
// exp    <- ".lzh" ".zip" ...
// family <- archive family (LHa, Zip, ...)
// ret    -> true:already associated. false:no association.
bool CheckSubAssociation(const char *exp, const char *family)
{
	bool ret;
	HKEY hkNow;
	DWORD dwType;

	DWORD dwByte=1024;
	char *szName   = new char[1024];
	char *szValue  = new char[1024];
	char *szBuffer = new char[1024];
	lstrcpy(szName,""); dwType = REG_SZ;

	ret=false;
	
	if( lstrcmp(family,"Zip") != 0 &&
	    lstrcmp(family,"LHa") != 0 &&
	    lstrcmp(family,"Cab") != 0  )
	{
		return false;  //no Compressed (Zipped/LZH) folder or cabview
	}
	else if(lstrcmp(exp   ,".lzh" ) != 0 && 
	        lstrcmp(family,"LHa"  ) == 0)
	{
		return false;  //.lzs / .lha is not Compressed (LZH) Folder
	} 

  ////// CLSID\{***} Open.
	if( lstrcmp(family,"Zip") == 0 )
	{
		//CLSID for Compressed (Zipped) Folder.
		wsprintf(szBuffer,"CLSID\\{E88DCCE0-B7B3-11d1-A9F0-00AA0060FA31}");
	}
	else if(lstrcmp(family,"LHa") == 0 )
	{
		//CLSID for Compressed (LZH) Folder.
		wsprintf(szBuffer,"CLSID\\{0B95D640-10C3-4FB1-867E-22A640C5C7AA}");
	}
	else if(lstrcmp(family,"Cab") == 0 )
	{
		//CLSID for CabView.
		wsprintf(szBuffer,"CLSID\\{0CD7A5C0-9F37-11CE-AE65-08002B2E1262}");
	}

	if( RegOpenKeyEx(
		HKEY_CLASSES_ROOT,
		szBuffer,
		0,
		KEY_ALL_ACCESS,
		&hkNow) != ERROR_SUCCESS )
	{
		ret=false; //No Assosiation
	}
	else
	{
		if(RegQueryValueEx(hkNow,szName,NULL,&dwType,(BYTE *)szValue,&dwByte)!= ERROR_SUCCESS)
		{
			ret=false; //No Assosiation
		}
		else
		{
			
			wsprintf(szBuffer,"",family);
			if(lstrcmp(szValue,szBuffer) == 0)
			{
				ret=false; //No Assosiation
			}
			else
			{
				ret=true;  //Association by Explorer (Compressed Folder or Cabview)
			}
		}
		RegCloseKey(hkNow);
	}

	delete[] szBuffer;
	delete[] szValue;
	delete[] szName;

	return ret;
}


//// SubAssociation (for RegistAssociation func.)
// exp           <- ".lzh" ".zip" ...
// family        <- archive family (LHa, Zip, ...)
void RegistSubAssociation(const char *exp, const char *family)
{
	if(! (lstrcmp(family,"Zip") == 0|| lstrcmp(family,"Cab")== 0 ))
		return; // Zip and Cab only.

	if( IsPlatformWin32NT() == true && lstrcmp(family,"Zip")== 0)
		return;	// Windows NT/2000 can't use Compressed Folder(Zip),
				// and Windows XP can double regist to context menu...

	//if "regsvr32 /u cabview.dll" or "regsvr32 /u zipfldr.dll" ...
	if(CheckSubAssociation(exp,family) == false)
		return;

	HKEY hkNow;
	DWORD dwPosition;

	//Cab for Explorer OK?
	if(lstrcmp(family,"Cab")== 0)
		if(RegOpenKeyEx(HKEY_CLASSES_ROOT,"CLSID\\{0CD7A5C0-9F37-11CE-AE65-08002B2E1262}",0,KEY_ALL_ACCESS,&hkNow) == ERROR_SUCCESS )
			RegCloseKey(hkNow);
		else
			return;
	//Zip for Explorer OK?
	if(lstrcmp(family,"Zip")== 0)
		if(RegOpenKeyEx(HKEY_CLASSES_ROOT,"CLSID\\{E88DCCE0-B7B3-11d1-A9F0-00AA0060FA31}",0,KEY_ALL_ACCESS,&hkNow) == ERROR_SUCCESS )
			RegCloseKey(hkNow);
		else
			return;

	char *szName   = new char[1024];
	char *szValue  = new char[1024];
	
  ////// PackMI.???\Shell\Explorer Registration.
	wsprintf(szName, "PackMI.%s\\Shell\\Explorer",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell\Open
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");
	if(GetACP()==932) //Japanese
		lstrcpy(szValue, "GNXv[(&X)");
	else
		lstrcpy(szValue, "e&Xplorer");
	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);

  ////// PackMI.???\Shell\Explorer\Command Registration.
	wsprintf(szName, "PackMI.%s\\Shell\\Explorer\\Command",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell\Open\Command
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");
	//Zip
	if(lstrcmp(family,"Zip") == 0)
		wsprintf(szValue, "explorer /e,/root,{E88DCCE0-B7B3-11d1-A9F0-00AA0060FA31},%%L\0");
	else if(lstrcmp(family,"Cab") == 0)
		wsprintf(szValue, "explorer /e,/root,{0CD7A5C0-9F37-11CE-AE65-08002B2E1262},%%L\0");

	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);

	delete[] szValue;
	delete[] szName;
}

//// Association
// exp      <- ".lzh" ".zip" ...
// family   <- archive family (LHa, Zip, ...)
// iconum <-  (ICO  num... LHa=4, zip=5, jak=2,mxd=3...)
// modesw   <- 0:Archive File. 1:Ripped File. 2:MXD File.
void RegistAssociation(const char *exp, const char *family, int iconum, int modesw)
{
	HKEY hkNow;
	DWORD dwPosition;

	bool bIniticon; //Assicuated icon Overwrite?
	if(CheckAssociation(exp,family)==false) bIniticon = true;
	else bIniticon = false;

	char *ExecPath = new char[MAX_PATH+1];
	char *IconPath = new char[MAX_PATH+10];
	char *szName   = new char[1024];
	char *szValue  = new char[1024];

  ////// .??? Registration.
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		exp,
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");
	wsprintf(szValue,"PackMI.%s",family);
	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);

  ////// PackMI.??? Registration.
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szValue, 		//PackMI.???
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");
	
	if(GetACP()==932) //Japanese
	{
		if(modesw==1)
			wsprintf(szValue," (%s `) t@C",family);
		else if(modesw==2)
			wsprintf(szValue,"Meltice g DLL (MXD)",family);
		else 
			wsprintf(szValue," (%s `) t@C",family);
	}else{
		if(modesw==1)
			wsprintf(szValue,"Ripped File (%s)",family);
		else if(modesw==2)
			wsprintf(szValue,"dll for Meltice eXtenDing (MXD)",family);
		else 
			wsprintf(szValue,"Archive file (%s)",family);
	}
	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);

  ////// PackMI.???\Shell Registration.
	wsprintf(szName, "PackMI.%s\\Shell",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");
	lstrcpy(szValue,"Open");
	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);

  ////// PackMI.???\Shell\Open Registration.
	wsprintf(szName, "PackMI.%s\\Shell\\Open",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell\Open
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");
	if(GetACP()==932) //Japanese
	{
		if(modesw==1)
			wsprintf(szValue,"Meltice Ō (&O)",family);
		else if(modesw==2)
			lstrcpy(szValue, "MXD ̃o[W (&O)");
		else 
			lstrcpy(szValue, "Meltice ŉ𓀂 (&O)");
	}else{
		if(modesw==1)
			lstrcpy(szValue, "&Open and combine files.");
		else if(modesw==2)
			lstrcpy(szValue, "&Open and view mxd version info.");
		else 
			lstrcpy(szValue, "&Open archive file.");
	}
	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);

  ////// PackMI.???\Shell\Open\Command Registration.
	GetModuleFileName(NULL, ExecPath, MAX_PATH); //Get Meltice.exe path.
	
	CharLower(ExecPath);

	//for WinVista UAC
	if(strcmp(get_filename(ExecPath),"dblclick.exe") == 0)
	{
		//DblClick.exe -> Meltice.exe
		get_dirname(ExecPath);
		path_add_backslash(ExecPath);
		lstrcat(ExecPath,"MELTICE.EXE");
	}

	wsprintf(szName, "PackMI.%s\\Shell\\Open\\Command",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell\Open\Command
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");
	wsprintf(szValue, "\"%s\" \"%%1\"\0", ExecPath);
	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);

  ////// PackMI.???\Shell\Explorer and  PackMI.???\Shell\Explorer\Command Registration.
	RegistSubAssociation(exp, family);

  ////// Preparation for PackMI.???\DefaultIcon Registration...
	if(bIniticon) //OverWrite icons.
	{

	  //Get IconPath.
		GetModuleFileName(NULL, ExecPath, MAX_PATH); //Get Meltice.exe path.
		lstrcpy(IconPath,ExecPath);
		int pt = lstrlen(IconPath);
		while(*(IconPath+pt) != '\\'){
			pt--;
			if(pt < 0) break;
		}
		*(IconPath+pt) = 0;
		lstrcat(IconPath,"\\DBLCLICK.MXD"); //DBLCLICK.MXD.

  ////// PackMI.???\DefaultIcon Registration.
		wsprintf(szName, "PackMI.%s\\DefaultIcon",family);
		RegCreateKeyEx(
			HKEY_CLASSES_ROOT,
			szName, 		//PackMI.???\DefaultIcon
			0,
			"",
			REG_OPTION_NON_VOLATILE,
			KEY_ALL_ACCESS,
			NULL,
			&hkNow,
			&dwPosition);
		lstrcpy(szName,"");
		wsprintf(szValue, "%s,%d\0", IconPath,iconum);
		RegSetValueEx(hkNow,szName,0,REG_SZ,
			(const unsigned char *)szValue,lstrlen(szValue));
		RegCloseKey(hkNow);
	}

	delete[] szValue;
	delete[] szName;
	delete[] IconPath;
	delete[] ExecPath;
}

//// ForgetAssociation
// exp    <- ".lzh" ".zip" ...
// family <- archive family (LHa, Zip, ...)
void ForgetAssociation(const char *exp, const char *family)
{
	if(CheckAssociation(exp,family)==false) return;

	HKEY hkNow;
	DWORD dwPosition;

	char *szName   = new char[1024];
	char *szValue  = new char[1024];
	
	//is delete HKEY_CLASSES_ROOT\.??? key?
	bool delexp = false;

  ////// .??? Forget.
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		exp,
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	lstrcpy(szName,"");

	//Associate to Explorer...
	if(CheckSubAssociation(exp,family) == true)
	{
		if(lstrcmp(family,"Zip") == 0)
			wsprintf(szValue,"CompressedFolder",family); //CompressedFolder (Explorer)
		else if(lstrcmp(family,"LHa") == 0)
			wsprintf(szValue,"LzhCompressedFolder",family); //LzhCompressedFolder (Explorer)
		else if(lstrcmp(family,"Cab") == 0)
			wsprintf(szValue,"CLSID\\{0CD7A5C0-9F37-11CE-AE65-08002B2E1262}",family); //CabView (Explorer)
	}
	else
	{
		wsprintf(szValue,"",family); //forget!!
		delexp = true;
	}
	RegSetValueEx(hkNow,szName,0,REG_SZ,
		(const unsigned char *)szValue,lstrlen(szValue));
	RegCloseKey(hkNow);
	
  ////// .PackMI.??? Key Delete!
	wsprintf(szName, "PackMI.%s\\Shell\\Open",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell\Open
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	RegDeleteKey(hkNow,"Command"); 
	RegCloseKey(hkNow);

	wsprintf(szName, "PackMI.%s\\Shell\\Explorer",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell\Explorer
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	RegDeleteKey(hkNow,"Command"); 
	RegCloseKey(hkNow);

	wsprintf(szName, "PackMI.%s\\Shell",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???\Shell
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	RegDeleteKey(hkNow,"Open"); 
	RegDeleteKey(hkNow,"Explorer"); 
	RegCloseKey(hkNow);

	wsprintf(szName, "PackMI.%s",family);
	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		szName, 		//PackMI.???
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	RegDeleteKey(hkNow,"Shell"); 
	RegDeleteKey(hkNow,"DefaultIcon"); 
	RegCloseKey(hkNow);

	RegCreateKeyEx(
		HKEY_CLASSES_ROOT,
		"",
		0,
		"",
		REG_OPTION_NON_VOLATILE,
		KEY_ALL_ACCESS,
		NULL,
		&hkNow,
		&dwPosition);
	RegDeleteKey(hkNow,szName);  //PackMI.??? deleted
	if(delexp == true)
	{
		RegDeleteKey(hkNow,exp);  //.??? deleted
	}
	
	RegCloseKey(hkNow);
}

///////////////////////////////////////////////////////////////////////////////
//
// Diarog routine.
//


//CheckBox, Button, TextBox Object is enabled/disabled.
//hDlg = Dialog hWnd.
//hCnt = Control code(int). (CheckBox, Button, TextBox, etc.)
//sw   = true ->enable / false->disable.
static void ControlEnable(HWND hDlg, int iCnt, bool sw)
{
	EnableWindow(GetDlgItem(hDlg,iCnt),sw);// hRec on hDlg enable or disable from sw.
}

//Dialog Procedure.
LRESULT CALLBACK ASSDLGProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		//////Load Dialog locate.
			RECT deskrc; //desktop rc.
			RECT rc;
			int x,y;

			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			x = (deskrc.right - (rc.right-rc.left)) / 2;
			y = (deskrc.bottom - (rc.bottom-rc.top)) /2;
			SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);

		//////Check useable extract engine...
			ControlEnable(hDlg, IDC_CHK_LZH, isEngineUseable(MODE_LZH));
			ControlEnable(hDlg, IDC_CHK_ZIP, isEngineUseable(MODE_ZIP));
			ControlEnable(hDlg, IDC_CHK_7Z,  isEngineUseable(MODE_7Z));
			ControlEnable(hDlg, IDC_CHK_CAB, isEngineUseable(MODE_CAB));
			ControlEnable(hDlg, IDC_CHK_TAR, isEngineUseable(MODE_TAR));
			ControlEnable(hDlg, IDC_CHK_BGA, isEngineUseable(MODE_BGA));
			ControlEnable(hDlg, IDC_CHK_YZ1, isEngineUseable(MODE_YZ1));
			ControlEnable(hDlg, IDC_CHK_ARJ, isEngineUseable(MODE_ARJ));
			ControlEnable(hDlg, IDC_CHK_GCA, isEngineUseable(MODE_GCA));
			ControlEnable(hDlg, IDC_CHK_RAR, isEngineUseable(MODE_RAR));
			ControlEnable(hDlg, IDC_CHK_ACE, isEngineUseable(MODE_ACE));
			ControlEnable(hDlg, IDC_CHK_JAK, isEngineUseable(MODE_JAK));
			ControlEnable(hDlg, IDC_CHK_ETC, isEngineUseable(MODE_ETC));
			ControlEnable(hDlg, IDC_CHK_MXD, isEngineUseable(MODE_MXD));

		//////if after associated then pushed button is default.
			SendMessage(GetDlgItem(hDlg, IDC_CHK_LZH), BM_SETCHECK, (WPARAM)CheckAssociation(".lzh","LHa"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_ZIP), BM_SETCHECK, (WPARAM)CheckAssociation(".zip","Zip"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_7Z),  BM_SETCHECK, (WPARAM)CheckAssociation(".7z", "7Zip"),0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_CAB), BM_SETCHECK, (WPARAM)CheckAssociation(".cab","Cab"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_TAR), BM_SETCHECK, (WPARAM)CheckAssociation(".tgz","Tar"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_BGA), BM_SETCHECK, (WPARAM)CheckAssociation(".bza","Bga"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_YZ1), BM_SETCHECK, (WPARAM)CheckAssociation(".yz1","Yz1"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_ARJ), BM_SETCHECK, (WPARAM)CheckAssociation(".arj","Arj"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_GCA), BM_SETCHECK, (WPARAM)CheckAssociation(".gca","Gca"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_RAR), BM_SETCHECK, (WPARAM)CheckAssociation(".rar","Rar"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_ACE), BM_SETCHECK, (WPARAM)CheckAssociation(".ace","Ace"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_JAK), BM_SETCHECK, (WPARAM)CheckAssociation(".jak","Jak"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_ETC), BM_SETCHECK, (WPARAM)CheckAssociation(".arc","Arc"), 0L);
			SendMessage(GetDlgItem(hDlg, IDC_CHK_MXD), BM_SETCHECK, (WPARAM)CheckAssociation(".mxd","Mxd"), 0L);


			return true;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
			////// button
				case IDOK:
					if(IsDlgButtonChecked(hDlg, IDC_CHK_LZH) == BST_CHECKED)
					{
						RegistAssociation(".lzh","LHa",3,0);
						RegistAssociation(".lzs","LHa",3,0);
						RegistAssociation(".lha","LHa",3,0);
					}else{
						ForgetAssociation(".lzh","LHa");
						ForgetAssociation(".lzs","LHa");
						ForgetAssociation(".lha","LHa");
					}

					if(IsDlgButtonChecked(hDlg, IDC_CHK_ZIP) == BST_CHECKED)
					{
						RegistAssociation(".zip","Zip",4,0);
					}else{
						ForgetAssociation(".zip","Zip");
					}

					if(IsDlgButtonChecked(hDlg, IDC_CHK_7Z) == BST_CHECKED)
					{
						RegistAssociation(".7z","7Zip",13,0);
					}else{
						ForgetAssociation(".7z","7Zip");
					}

					if(IsDlgButtonChecked(hDlg, IDC_CHK_CAB) == BST_CHECKED)
					{
						RegistAssociation(".cab","Cab",5,0);
					}else{
						ForgetAssociation(".cab","Cab");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_TAR) == BST_CHECKED)
					{
						RegistAssociation(".tgz","Tar",6,0);
						RegistAssociation(".gz" ,"Tar",6,0);
						RegistAssociation(".tbz","Tar",6,0);
						RegistAssociation(".bz2","Tar",6,0);
						RegistAssociation(".taz","Tar",6,0);
						RegistAssociation(".Z",  "Tar",6,0);
						RegistAssociation(".rpm","Tar",6,0);
						RegistAssociation(".deb","Tar",6,0);
						RegistAssociation(".tar","Tar",6,0);

						//Ver.2.22.1 (2012/09/11 Beta) 4ǉ (tar.xzn)
						RegistAssociation(".xz","Tar",6,0);
						RegistAssociation(".txz","Tar",6,0);
						RegistAssociation(".lzma","Tar",6,0);
						RegistAssociation(".tlz","Tar",6,0);

						//Ver.2.26.0 (2024/01/01) ǉ (tar.zstn)
						RegistAssociation(".zstd","Tar",6,0);
						RegistAssociation(".tzst","Tar",6,0);
						RegistAssociation(".tzs","Tar",6,0);
						//Ver.2.26.1 (2024/06/07) ǉ (tar.zstn zsto^Rǉ)
						RegistAssociation(".zst","Tar",6,0);
					}else{
						ForgetAssociation(".tgz","Tar");
						ForgetAssociation(".gz" ,"Tar");
						ForgetAssociation(".tbz","Tar");
						ForgetAssociation(".bz2","Tar");
						ForgetAssociation(".taz","Tar");
						ForgetAssociation(".Z",  "Tar");
						ForgetAssociation(".rpm","Tar");
						ForgetAssociation(".deb","Tar");
						ForgetAssociation(".tar","Tar");

						//Ver.2.22.1 (2012/09/11 Beta) 4ǉ (tar.xzn)
						ForgetAssociation(".xz","Tar");
						ForgetAssociation(".txz","Tar");
						ForgetAssociation(".lzma","Tar");
						ForgetAssociation(".tlz","Tar");
						//Ver.2.26.0 (2024/01/01) ǉ (tar.zstn)
						ForgetAssociation(".zstd","Tar");
						ForgetAssociation(".tzst","Tar");
						ForgetAssociation(".tzs","Tar");
						//Ver.2.26.1 (2024/06/07) ǉ (tar.zstn zsto^Rǉ)
						ForgetAssociation(".zst","Tar");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_BGA) == BST_CHECKED)
					{
						RegistAssociation(".bza","Bga",7,0);
						RegistAssociation(".gza","Bga",7,0);
					}else{
						ForgetAssociation(".bza"  ,"Bga");
						ForgetAssociation(".gza"  ,"Bga");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_YZ1) == BST_CHECKED)
					{
						RegistAssociation(".yz1","Yz1",8,0);
					}else{
						ForgetAssociation(".yz1"  ,"Yz1");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_ARJ) == BST_CHECKED)
					{
						RegistAssociation(".arj","Arj",9,0);
					}else{
						ForgetAssociation(".arj"  ,"Arj");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_GCA) == BST_CHECKED)
					{
						RegistAssociation(".gca","Gca",10,0);
					}else{
						ForgetAssociation(".gca"  ,"Gca");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_RAR) == BST_CHECKED)
					{
						RegistAssociation(".rar","Rar",11,0);
					}else{
						ForgetAssociation(".rar"  ,"Rar");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_ACE) == BST_CHECKED)
					{
						RegistAssociation(".ace","Ace",12,0);
					}else{
						ForgetAssociation(".ace"  ,"Ace");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_JAK) == BST_CHECKED)
					{
						RegistAssociation(".jak","Jak",1,1);
					}else{
						ForgetAssociation(".jak"  ,"Jak");
					}
					if(IsDlgButtonChecked(hDlg, IDC_CHK_ETC) == BST_CHECKED)
					{
						RegistAssociation(".arc","Arc",0,0);
//						RegistAssociation(".imp","Imp",0,0);		//disabled by Ver.2.20.0; 20060102
						RegistAssociation(".zoo","Zoo",0,0);
						RegistAssociation(".cpt","Cpt",0,0);
						RegistAssociation(".pit","Pit",0,0);
						RegistAssociation(".arg","Arg",0,0);
						RegistAssociation(".asd","Asd",0,0);
						RegistAssociation(".bel","Belon",0,0);
						RegistAssociation(".jam","Jam",0,0);
						RegistAssociation(".bh" ,"BlackHole",0,0);
						RegistAssociation(".dz" ,"Dz",0,0);
//						RegistAssociation(".ha" ,"Ha",0,0);			//disabled by Ver.2.20.0; 20060102
						RegistAssociation(".hki","Hki",0,0);
						RegistAssociation(".noa","Noa",0,0);
						RegistAssociation(".yz2","Yz2",0,0);
						RegistAssociation(".yz2a6","Yz2",0,0);
						RegistAssociation(".ish","Ish",0,0);
					}else{
						ForgetAssociation(".arc","Arc");
						ForgetAssociation(".imp","Imp");
						ForgetAssociation(".zoo","Zoo");
						ForgetAssociation(".cpt","Cpt");
						ForgetAssociation(".pit","Pit");
						ForgetAssociation(".arg","Arg");
						ForgetAssociation(".asd","Asd");
						ForgetAssociation(".bel","Belon");
						ForgetAssociation(".jam","Jam");
						ForgetAssociation(".bh" ,"BlackHole");
						ForgetAssociation(".dz" ,"Dz");
						ForgetAssociation(".ha" ,"Ha");
						ForgetAssociation(".hki","Hki");
						ForgetAssociation(".noa","Noa");
						ForgetAssociation(".yz2","Yz2");
						ForgetAssociation(".yz2a6","Yz2");
						ForgetAssociation(".ish","Ish");
					}

					if(IsDlgButtonChecked(hDlg, IDC_CHK_MXD) == BST_CHECKED)
					{
						RegistAssociation(".mxd","Mxd",2,2);
					}else{
						ForgetAssociation(".mxd"  ,"Mxd");
					}
						
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case IDCANCEL:
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case IDC_BTN_ALL:
					if(
						IsDlgButtonChecked(hDlg, IDC_CHK_LZH) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_ZIP) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_7Z)  == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_CAB) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_TAR) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_BGA) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_YZ1) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_ARJ) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_GCA) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_RAR) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_ACE) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_JAK) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_ETC) == BST_CHECKED ||
						IsDlgButtonChecked(hDlg, IDC_CHK_MXD) == BST_CHECKED)
					{
						SendMessage(GetDlgItem(hDlg, IDC_CHK_LZH), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ZIP), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_7Z),  BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_CAB), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_TAR), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_BGA), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_YZ1), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ARJ), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_GCA), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_RAR), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ACE), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_JAK), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ETC), BM_SETCHECK, (WPARAM)false, 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_MXD), BM_SETCHECK, (WPARAM)false, 0L);
					}else{
						SendMessage(GetDlgItem(hDlg, IDC_CHK_LZH), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_LZH), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ZIP), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_ZIP), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_7Z),  BM_SETCHECK, (WPARAM)isEngineUseable(MODE_7Z), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_CAB), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_CAB), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_TAR), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_TAR), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_BGA), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_BGA), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_YZ1), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_YZ1), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ARJ), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_ARJ), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_GCA), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_GCA), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_RAR), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_RAR), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ACE), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_ACE), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_JAK), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_JAK), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_ETC), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_ETC), 0L);
						SendMessage(GetDlgItem(hDlg, IDC_CHK_MXD), BM_SETCHECK, (WPARAM)isEngineUseable(MODE_MXD), 0L);
						
					}
				default:
					return FALSE;
			}
		default:
			return FALSE;
	}
}


///////////////////////////////////////////////////////////////////////////////
//
// Main routine.
//


int WINAPI DllMain(HINSTANCE hInst, DWORD fdReason, PVOID)
{
	switch (fdReason) 
	{
		case DLL_PROCESS_ATTACH:
			hInstance = hInst;
			hWnd = (HWND) CreateFileMapping((HANDLE)0xFFFFFFFF, NULL, 
				PAGE_READWRITE, 0, 1024, OBJNAME);
			break;
		case DLL_PROCESS_DETACH:
			CloseHandle(hWnd);
			break;
		default:
			break;
	}
	return TRUE;
};
// DLL Version.
EXPORT int WINAPI MxdGetVersion(void)
{
	return MXDVER;
};

// DLL Protocol Version.
EXPORT int  WINAPI MxdGetProtocolVersion(void)
{
	return MXD_PROTOCOL_VER;
};


EXPORT bool WINAPI MxdConfigName(char *szbuf, const int iMode, const int iLang)
{
	bool ret=IsAdmin();
	DWORD dwErr=GetLastError();
	if(iLang==932 && iMode==1) //Japanese, and Unpack settings.
	{
		if(ret==true)	lstrcpy(szbuf, "֘At̐ݒ");
		else{
			if(dwErr==NERR_UserNotFound)
			{
				lstrcpy(szbuf, "֘At (s)");
				if(GetKeyState(VK_SHIFT) < 0)			//if SHIFT keydown then allow configure.
				{
					ret=true;
					lstrcpy(szbuf, "֘At (s)");
				}
			}
			else if(dwErr==1) //BadFunction
				lstrcpy(szbuf, "֘At (APIError)");
			else
				lstrcpy(szbuf, "֘At ()");
		}
	}else if(iMode==1) //Japanese, and Unpack settings.
	{
		if(ret==true)	lstrcpy(szbuf, "Associate to Meltice");
		else{
			if(dwErr==NERR_UserNotFound)
			{
				lstrcpy(szbuf, "Associate (DomUser)");
				if(GetKeyState(VK_SHIFT) < 0)			//if SHIFT keydown then allow configure.
				{
					ret=true;
					lstrcpy(szbuf, "Associate (Trial)");
				}
			}
			else if(dwErr==1) //BadFunction
				lstrcpy(szbuf, "Associate (API Err)");
			else
				lstrcpy(szbuf, "Associate (NoAllow)");
		}
	}
	return ret;
}


EXPORT bool WINAPI MxdConfigDialog(const HWND hWnd, LPSTR, const int iMode)
{
	char buf[2048];
	
	if(iMode==0)
	{
		if(GetACP()==932){ //Japanese
		wsprintf(buf, 
			"DBLCLICK.MXD Ver.%d.%02d.%d (MXD Protocol v%d.%02d.%d)\n\n  MXD t@C͊֘AtS܂B\n\nWindows NT/2000/XP/2003 ṕ̕A֘Ats߂ɁAǗҌKvłB\n(ADBLCLICK.MXD ̓hC [U[̊ǗҌɂ֘Atɂ͑ΉĂ܂B)\n\nWindows Vista / Windows 7 / Windows Server 2008 ܂͂ȍ~̃o[W\nWindows ṕ̕ADblClick.exe oRŊǗҌ̏iKvłB",
			MXDVER/1000, (MXDVER%1000)/10, MXDVER%10,	// mxd ver.
			MXD_PROTOCOL_VER/1000, (MXD_PROTOCOL_VER%1000)/10, MXD_PROTOCOL_VER%10);
														// MXD Protocol ver.
		}else{
		wsprintf(buf, 
			"DBLCLICK.MXD Ver.%d.%02d.%d (MXD Protocol v%d.%02d.%d)\n\n This MXD file associate to Meltice when you want to associate settings.",
			MXDVER/1000, (MXDVER%1000)/10, MXDVER%10,	// mxd ver.
			MXD_PROTOCOL_VER/1000, (MXD_PROTOCOL_VER%1000)/10, MXD_PROTOCOL_VER%10);
														// MXD Protocol ver.
		}
		MessageBox(hWnd, buf,
			"DBLCLICK.MXD Version information.", 
			MB_ICONINFORMATION);
	}else if(iMode==1)
	{
		if(GetOSMajorVer() >= 6)
		{
			//must use UAC...
			int uacExec = (int)ShellExecute(hWnd, "open", "DblClick.exe", NULL,NULL, SW_SHOW);
			if( uacExec == 0 ||						//\[XȂ
				uacExec == ERROR_FILE_NOT_FOUND ||	//t@CȂ
				uacExec == ERROR_PATH_NOT_FOUND ||	//pXȂ
				uacExec == ERROR_BAD_FORMAT		||	//EXE
				uacExec == SE_ERR_FNF			||	//t@CȂ
				uacExec == SE_ERR_OOM			||	//s
				uacExec == SE_ERR_PNF			||	//pXȂ
				uacExec == SE_ERR_SHARE				//Lᔽ

				)
			{
				//炩̎sɎsƂӖB
				if(GetACP()==932){ //Japanese
					wsprintf(buf, "ǗҌ̏iɕKvȃt@Csł܂łB\nG[R[h : 0x%08x");
					MessageBox(hWnd, 
						buf,
						"DBLCLICK.MXD sG[", 
						MB_ICONERROR);
				}else{
					wsprintf(buf, "Dblclick.exe call failed.\nError code : 0x%08x");
					MessageBox(hWnd, 
						buf,
						"DBLCLICK.MXD run error", 
						MB_ICONERROR);
				}
			}
			else if( 
				uacExec == SE_ERR_ACCESSDENIED	||	//ANZX
				uacExec == SE_ERR_ACCESSDENIED		//ANZX

				)
			{
				//i[U[ۂꍇB
				if(GetACP()==932){ //Japanese
					wsprintf(buf, "ǗҌ̏iLZADBLCLICK.EXE sɎs܂B\nWindows Vista ȍ~ (Windows 7 / Windows 8 ܂) OS ł́A֘At̑ɂ͊ǗҌւ̏iK{ƂȂ܂B\n\n֘At_CAO̕\𒆎~܂B");
					MessageBox(hWnd, 
						buf,
						"DBLCLICK.MXD s(֘At)̃LZ", 
						MB_ICONWARNING);
				}else{
					wsprintf(buf, "Dblclick.exe (for associate to Meltice) cancel by user.\nError code : 0x%08x");
					MessageBox(hWnd, 
						buf,
						"DBLCLICK.MXD run warning", 
						MB_ICONWARNING);
				}
			}
		}
		else
		{
			if(GetACP()==932){ //Japanese
				DialogBox(hInstance, "IDD_ASSDLG_JP", hWnd, (DLGPROC)ASSDLGProc);
			}else{
				DialogBox(hInstance, "IDD_ASSDLG_US", hWnd, (DLGPROC)ASSDLGProc);
			}
		}
	}else if(iMode==2)
	{
		return false;
	}
	else if(iMode==60)
	{
		//for WinVista Mode...
		if(GetACP()==932){ //Japanese
			DialogBox(hInstance, "IDD_ASSDLG_JP", hWnd, (DLGPROC)ASSDLGProc);
		}else{
			DialogBox(hInstance, "IDD_ASSDLG_US", hWnd, (DLGPROC)ASSDLGProc);
		}
	}
	return false; // No config...
}


//Check Archive.
EXPORT bool WINAPI MxdCheckArchive(const char * /*filename*/)
{
	return false; //Not Supported.
}

EXPORT bool  WINAPI MxdUnpackArchive(const char * /*filename*/,const char * /*outputdir*/)
{
	return false;
}

EXPORT bool WINAPI MxdPackArchive(const char * /*filename*/,const char * /*outputdir*/)
{
	return false;
}
