///////////////////////////////////////////////////////////////////////////////
//
// Meltice Family Version dialog Ex "MIFVEREX.DLL"
//
//   Meltice Family : Meltice 2.2.x Copyright (C)2000-2019 Meltice Family Project.
//
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h> //For ListView
#include "resource.h"

#define EXPORT extern "C" __declspec(dllexport)

#define MIFVEREX_VER			2261
	//     DLL Version    : 2.26.1  (x.y.z : xyyz)
#define MIFVEREX_PROTOCOL_VER	2203
	//Protocol Version    : 2.20.3  (x.y.z : xyyz)

#define SUPPORT_MXD_NUM	8
	//MXD T|[g̍ő吔
#define MXD_PROTOCOL_VER 2000
	//MXDvgR̃o[WBVer.2.2.x  2.00.0 Ӗ 2000B

//Meltice Family ̃o[W (Frostice.mxd Ăяoꂽꍇp)
#define MELTICE_VERSION_DEFAULT	"Ver.2.2.x"
//Meltice.exe ̃o[W (Meltice.exe Ăяoꂽꍇ̂)
static char strMelticeVersion[256] = "";

#define OBJNAME				"MIFVEREX_Dll"

#define DLLNUM_FOR_UNPACK	11	//UNPACK_DLLNUM
#define DLLNUM_FOR_PACK		8	//PACK_DLLNUM
#define DLLNUM_FOR_EXT		16	//EXT_DLLNUM
#define DLL_NOT_FOUND_MSG	"o" //DLL NOT FOUND MESSAGE.

//DLL for XacRett
#define DLL_NAME_FOR_XACRETT	"XacRett.DLL"
#define DLL_NUM_FOR_XACRETT		11

//API's
typedef WORD (WINAPI *PGETVERFUNC)();

#define MAX_BUF			4096

//Nbv{[hɊi[o[W
char *strVerBufForClip;
#define CLIPBRD_BUF		32*1024		//32KB

//for Windows Versions (Visual Studio 6.0)
typedef struct _OSVERSIONINFO_VS60 {
    DWORD dwOSVersionInfoSize;  // structure size
    DWORD dwMajorVersion;       // major version
    DWORD dwMinorVersion;       // minor version
    DWORD dwBuildNumber;        // build number
    DWORD dwPlatformId;         // platform ID
    TCHAR szCSDVersion[128];    // additional string
    WORD  wServicePackMajor;    // SP major version
    WORD  wServicePackMinor;    // SP minor version
    WORD  wSuiteMask;           // product suites
    BYTE  wProductType;         // additional information
    BYTE  wReserved;            // reserved
} OSVERSIONINFOEX_VS60, *POSVERSIONINFOEX_VS60, *LPOSVERSIONINFOEX_VS60;

//For DLL Dialog
HINSTANCE	hInstance;
HWND		hWnd; 

int WINAPI DllMain(HINSTANCE hInst, DWORD fdReason, PVOID)
{
	switch (fdReason) 
	{
		case DLL_PROCESS_ATTACH:
			hInstance = hInst;
			hWnd = (HWND) CreateFileMapping((HANDLE)0xFFFFFFFF, NULL, 
				PAGE_READWRITE, 0, 1024, OBJNAME);
			break;
		case DLL_PROCESS_DETACH:
			CloseHandle(hWnd);
			break;
		default:
			break;
	}
	return TRUE;
};

//---------------------------------------------------------------------------------------------------------------------
////st@C̃tH_߂B
//obNXbVpX̍ŌɒǉBU_STRING.CPP ̈ڐAB
char *path_add_backslash(char *lpszPath)
{
	char *p; p = lpszPath;
	return (*CharPrev( p,p+lstrlen(p) )=='\\' ? p : lstrcat(p,"\\"));
//	return PathAddBackslash(lpszPath);
}
//U_SYSTEM.CPP ̈ڐAB
//get_exec_dir split directory from Meltice's full path.
char *get_exec_dir(char *path, int pathlen)
{
	char *p, *r;
	static char lpstrAppName[MAX_PATH]; // for argv[0].

	GetModuleFileName(NULL, lpstrAppName, MAX_PATH);
	p = lpstrAppName;
	r = lpstrAppName + MAX_PATH - 1;    // argv[0] last char.
	while(*p != '\0'){
		if(IsDBCSLeadByte((BYTE)*p) == TRUE){
			p++;
		}else if(*p == '\\'){
			r = p;
		}
		p++;
	}
	*r = '\0';

	lstrcpyn( path, lpstrAppName, pathlen );
	path_add_backslash(path);
	return path;
}


//---------------------------------------------------------------------------------------------------------------------
//Windows Vista ȍ~̃v_NV擾 API R[B
//Windows XP/2003 ȑOɂ API ݂Ȃ߁ADLL INŌĂяoĂB
//BOOL ^Aɂ FALSE 萔lƂȂ̂ŒӁB
BOOL GetWindowsProductInfo()
{
	BOOL		bRet = FALSE;
	HINSTANCE	hKernelDll = LoadLibrary("KERNEL32.DLL");
	DWORD		dwType = 0;
	if(hKernelDll != NULL)
	{
		BOOL (CALLBACK* pfnGetProductInfo)(DWORD dwOSMajorVersion,DWORD dwOSMinorVersion,DWORD dwSpMajorVersion,DWORD dwSpMinorVersion,PDWORD pdwReturnedProductType);
		(*(FARPROC*)&pfnGetProductInfo) = ::GetProcAddress(hKernelDll,"GetProductInfo");

		if(pfnGetProductInfo != NULL)
		{
			//RsyR[hĔ߂ǁAWindows Vista ȍ~Ή̂߂ނȂB
			OSVERSIONINFOEX_VS60 osVer;   memset(&osVer,   0, sizeof(OSVERSIONINFOEX_VS60));
			BOOL bOsVersionInfoEx;
			osVer.dwOSVersionInfoSize = sizeof(osVer);
			osVer.dwBuildNumber = 0;
			bOsVersionInfoEx = GetVersionEx((OSVERSIONINFO *)&osVer);

			if(bOsVersionInfoEx != FALSE)
			{
				BOOL bGetWindowsProduct = 
					pfnGetProductInfo(
						osVer.dwMajorVersion,
						osVer.dwMinorVersion,
						osVer.wServicePackMajor,
						osVer.wServicePackMinor,
						&dwType);
				if(bGetWindowsProduct != FALSE)
				{
					//dwType ɒlĂB
					bRet = dwType;
				}
			}
		}
	}
	return bRet;
}

//---------------------------------------------------------------------------------------------------------------------
//Xgr[o[Wŏ
void InitListView(
	HWND hLVForUnpack, 
	HWND hLVForPack,
	HIMAGELIST hImgLstForUnpack,
	HIMAGELIST hImgLstForPack)
{
	int i;

	LV_COLUMN lvcol;
	LV_ITEM item;

	HINSTANCE hInstDll;

	bool bIsFrosticeEnable = false;

	////DLLv[hU΍ŁAJgfBNg̋ړȂтɂ̑֘A΍
	////̃pb`Xg`ɔz邱ƂɂADLL/mxd̑΍ɂȂ錩݁B
	//VXefBNgɃJgfBNgړ
	static char lpstrSystemDirDll[MAX_PATH+1];
	GetSystemDirectory(lpstrSystemDirDll, MAX_PATH);
	SetCurrentDirectory(lpstrSystemDirDll);
	//for Windows 2000 SP4/Windows XP Golden (Safe DLL Search mode)
	#ifndef BASE_SEARCH_PATH_ENABLE_SAFE_SEARCHMODE
	#define BASE_SEARCH_PATH_ENABLE_SAFE_SEARCHMODE 0x1
	#endif
	GetSystemDirectory(lpstrSystemDirDll, MAX_PATH);
	lstrcat(lpstrSystemDirDll, "\\KERNEL32.DLL");
	HMODULE hKERNEL32 = GetModuleHandle(lpstrSystemDirDll);
	if(hKERNEL32)
    {
        BOOL(WINAPI * pfSetSearchPathMode)(DWORD) =
            (BOOL(WINAPI*)(DWORD)) GetProcAddress(hKERNEL32, "SetSearchPathMode");
        if(pfSetSearchPathMode != NULL)
        {
            pfSetSearchPathMode(BASE_SEARCH_PATH_ENABLE_SAFE_SEARCHMODE);
		}
	}

	//for Windows XP SP1+ / Vista / 7, Windows Server 2003+ (SetDllDirectory API Call)
	BOOL(WINAPI * pfSetDllDirectory)(LPCTSTR) =
            (BOOL(WINAPI*)(LPCTSTR)) GetProcAddress(hKERNEL32, "SetDllDirectoryA");
	if(pfSetDllDirectory != NULL)
	{
		pfSetDllDirectory("");
	}
	////ȏADLLv[hU΍IB2010/11/25 ǉB

	#define IMG_EXE_MAIN	0
	#define IMG_ERR_FILE	1		//~G[ (DLL/MXD𖢌o)
	#define IMG_QTN_FILE	2		//Hs   (INI t@CɃo[WLڂȂƂ)
	#define IMG_EXC_FILE	3		//IΉ (ƂƖΉ DLL. UNKANJ.DLL ƂBĂȂꍇ́~œĂĂIAb܂Ȃ^^;)
	#define IMG_ARC_FILE	4		//oOK (o[WAɏp)
	#define IMG_JAK_FILE	5		//oOK (o[WAp)
	#define IMG_MXD_FILE	6		//oOK (MXD t@C)

	char strClipBrdImg[IMG_MXD_FILE+1][4] = 
	{
		"|",
		"~|",
		"H|",
		"I|",
		"|",
		"|",
		"|"
	};
	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ ACR̓o^
	ListView_SetImageList(hLVForUnpack, hImgLstForUnpack, LVSIL_SMALL);
	ImageList_AddIcon(hImgLstForUnpack, LoadIcon(hInstance, MAKEINTRESOURCE(ICON_0_MELTICE))); //Meltice {
	ImageList_AddIcon(hImgLstForUnpack, LoadIcon(NULL, IDI_ERROR));      //G[(~)
	ImageList_AddIcon(hImgLstForUnpack, LoadIcon(NULL, IDI_QUESTION));   //s(H)
	ImageList_AddIcon(hImgLstForUnpack, LoadIcon(NULL, IDI_EXCLAMATION));//Ή(I)
	ImageList_AddIcon(hImgLstForUnpack, LoadIcon(hInstance, MAKEINTRESOURCE(ICON_2_ARCHIVEF)));
	ImageList_AddIcon(hImgLstForUnpack, LoadIcon(hInstance, MAKEINTRESOURCE(ICON_3_SPLITEDF)));
	ImageList_AddIcon(hImgLstForUnpack, LoadIcon(hInstance, MAKEINTRESOURCE(ICON_4_MXDFILES)));

	ListView_SetImageList(hLVForPack, hImgLstForPack, LVSIL_SMALL);
	ImageList_AddIcon(hImgLstForPack, LoadIcon(hInstance, MAKEINTRESOURCE(ICON_1_FROSTICE))); //Frostice{
	ImageList_AddIcon(hImgLstForPack, LoadIcon(NULL, IDI_ERROR));      //G[(~)
	ImageList_AddIcon(hImgLstForPack, LoadIcon(NULL, IDI_QUESTION));   //s(H)
	ImageList_AddIcon(hImgLstForPack, LoadIcon(NULL, IDI_EXCLAMATION));//Ή(I)
	ImageList_AddIcon(hImgLstForPack, LoadIcon(hInstance, MAKEINTRESOURCE(ICON_2_ARCHIVEF)));
	ImageList_AddIcon(hImgLstForPack, LoadIcon(hInstance, MAKEINTRESOURCE(ICON_3_SPLITEDF)));

	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Xgr[ōsPʂ̑I
	ListView_SetExtendedListViewStyle(hLVForUnpack, LVS_EX_FULLROWSELECT);
	ListView_SetExtendedListViewStyle(hLVForPack, LVS_EX_FULLROWSELECT);

	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Xgr[ڂB
	#define LVCOL_CX_SIZE 100
	lvcol.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	lvcol.fmt = LVCFMT_LEFT;
	lvcol.cx = LVCOL_CX_SIZE;
	lvcol.pszText = "";
	lvcol.iSubItem = 0;
	ListView_InsertColumn(hLVForUnpack, 0, &lvcol);
	ListView_InsertColumn(hLVForPack, 0, &lvcol);

	lvcol.cx = LVCOL_CX_SIZE;
	lvcol.pszText = "t@C";
	ListView_InsertColumn(hLVForUnpack, 1, &lvcol);
	ListView_InsertColumn(hLVForPack, 1, &lvcol);

	lvcol.cx = LVCOL_CX_SIZE;
	lvcol.pszText = "o[W";
	ListView_InsertColumn(hLVForUnpack, 2, &lvcol);
	ListView_InsertColumn(hLVForPack, 2, &lvcol);

	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ DLL ̏

	//XacRett.dllǂݍ߂ȂtOAFALSE (ǂ߂)ƂB
	unsigned int iXacRettUnknownFlag = FALSE;

	//ACR^Cv (ǂݍݗp)
	int IconTypeForUnPack[DLLNUM_FOR_UNPACK+1]=
	{
		IMG_EXE_MAIN,
		IMG_ARC_FILE,  IMG_ARC_FILE, IMG_ARC_FILE, IMG_ARC_FILE, IMG_ARC_FILE,
		IMG_ARC_FILE, IMG_ARC_FILE, IMG_ARC_FILE, IMG_ARC_FILE, IMG_JAK_FILE,
		IMG_ARC_FILE
	};
	char TypeNameForUnPack[DLLNUM_FOR_UNPACK+1][12] = 
	{
		"𓀖{",
		"LZH ", "ZIP  A", "ZIP  B", "7Z ",  "CAB ",
		"TAR ", "BGA ",   "YZ1 ",   "RAR ", "JAK ",
		"𓀎x"
	};
	char FileNameForUnPack[DLLNUM_FOR_UNPACK+1][16] = 
	{
		"MELTICE.EXE",
		"UNLHA32.DLL", "7-ZIP32.DLL", "UNZIP32.DLL", "7-ZIP32.DLL", "CAB32.DLL",
		"TAR32.DLL",   "BGA32.DLL",   "YZ1.DLL",     "UNRAR32.DLL", "JACK32.DLL",
		DLL_NAME_FOR_XACRETT
	};
	char FileVerGetApiForUnpack[DLLNUM_FOR_UNPACK+1][20] =
	{
		"",
		"UnlhaGetVersion", "SevenZipGetVersion", "UnZipGetVersion", "SevenZipGetVersion", "CabGetVersion",
		"TarGetVersion",   "BgaGetVersion",      "Yz1GetVersion",   "UnrarGetVersion",    "JackGetVersion",
		"XacRettGetVersion"
	};
	char FileSubVerGetApiForUnpack[DLLNUM_FOR_UNPACK+1][22] =
	{
			"",
			"UnlhaGetSubVersion", "SevenZipGetSubVersion", "UnZipGetSubVersion", "SevenZipGetSubVersion", "CabGetSubVersion",
			"TarGetSubVersion",   "BgaGetSubVersion",      "Yz1GetSubVersion",   "UnrarGetSubVersion",    "JackGetSubVersion",
			"XacRettGetSubVersion",
	};

	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ DLL 擾Xgɓo^
	lstrcat(strVerBufForClip,"\r\n[𓀃GW̃o[W]\r\n");

	for(i=0; i<=DLLNUM_FOR_UNPACK; i++)
	{


		hInstDll = LoadLibrary( FileNameForUnPack[i] );
		int DllVersion=0;
		int DllSubVersion=0;
		if(hInstDll != NULL)
		{
			PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll, FileVerGetApiForUnpack[i]);
			if(GetVer != NULL)
			{
				DllVersion = (int)(*GetVer)();
				PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll, FileSubVerGetApiForUnpack[i]);
				if(GetVer != NULL)
				{
					DllSubVersion = (int)(*GetVer)();
				}
				else
				{
					DllSubVersion = 0;
				}
			}else{
				DllVersion = 0;
				DllSubVersion = 0;
			}
			FreeLibrary(hInstDll);
		}else{
			 DllVersion = 0;
			 DllSubVersion = 0;
			if(i==DLL_NUM_FOR_XACRETT)
			{
				//XacRett.dll  Caldix œȂꍇ̂ŁAXacRettŃXg쐬ƂB
				iXacRettUnknownFlag = TRUE;
				continue;
			}
		}

		//烊Xgr[ɓo^
		item.mask = LVIF_TEXT|LVIF_IMAGE;
		if(DllVersion != 0 || i== 0)
		{
			item.iImage = IconTypeForUnPack[i];//펞̃ACR^Cv
			if(lstrcmp(strMelticeVersion,"") == 0 && i==0)
			{
				item.iImage = IMG_QTN_FILE;		//H(o[Ws)
			}
		}else{
			item.iImage = IMG_ERR_FILE;			//~(ĂȂ)
		}
		item.pszText = TypeNameForUnPack[i];
		item.iItem   = i;
		item.iSubItem = 0;
		lstrcat(strVerBufForClip,strClipBrdImg[item.iImage]);
		lstrcat(strVerBufForClip,item.pszText);
		lstrcat(strVerBufForClip,"\t");
		ListView_InsertItem(hLVForUnpack, &item);

		item.pszText = FileNameForUnPack[i];
		item.iSubItem = 1;
		lstrcat(strVerBufForClip,item.pszText);
		lstrcat(strVerBufForClip,"  \t");
		ListView_SetItem(hLVForUnpack, &item);

		if(DllVersion == 0)
		{
			if(i==0)
			{
				if(lstrcmp(strMelticeVersion,"") != 0)
				{
					item.pszText = strMelticeVersion;
				}else{
					item.pszText = MELTICE_VERSION_DEFAULT;
				}
			}else{
				item.pszText = DLL_NOT_FOUND_MSG;
			}
		}else{
			if(DllSubVersion == 0)
			{
				wsprintf(item.pszText,"Ver.%d.%02d", DllVersion/100,DllVersion%100);
			}else{
				wsprintf(item.pszText,"Ver.%d.%02d.%d.%d", DllVersion/100,DllVersion%100,DllSubVersion/100,DllSubVersion%100);
			}
		}
		item.iSubItem = 2;
		lstrcat(strVerBufForClip,item.pszText);
		lstrcat(strVerBufForClip,"\r\n");
		ListView_SetItem(hLVForUnpack, &item);
	 }

	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ MXD 擾Xgɓo^
	//Mxdŏ̐lZ
	i=DLLNUM_FOR_UNPACK+1;
	//XacRettȂ΁A̕Xgo͂Ȃ̂iB
	if(iXacRettUnknownFlag == TRUE) i--;
	int DllVersion=0;
	char *buf = new char[MAX_PATH*4];
	int j=0;
	get_exec_dir(buf, MAX_PATH);
	wsprintf(buf,"%s*.mxd", buf);

	hInstDll = NULL;
	PGETVERFUNC GetVer = NULL;
	PGETVERFUNC GetProtocolVer = NULL;

	WIN32_FIND_DATA  *mxd_findfile = new WIN32_FIND_DATA;
	HANDLE	hFndfst = FindFirstFile(buf, mxd_findfile);

	if(  hFndfst!= INVALID_HANDLE_VALUE )
	{
		j=1;

		do
		{
			GetVer=NULL; GetProtocolVer = NULL;
			hInstDll = LoadLibrary( (*mxd_findfile).cFileName );
			if(hInstDll != NULL)
			{
				GetVer = (PGETVERFUNC)GetProcAddress(hInstDll, "MxdGetVersion");
				GetProtocolVer = (PGETVERFUNC)GetProcAddress(hInstDll, "MxdGetProtocolVersion");
			}
			if(hInstDll==NULL || GetVer == NULL || GetProtocolVer == NULL)
			{
				//mxd ƂĖ
				item.iImage = IMG_EXC_FILE;
				lstrcat(strVerBufForClip,strClipBrdImg[item.iImage]);
			}
			else if((*GetProtocolVer)() != MXD_PROTOCOL_VER)
			{
				//mxd ƂĖ (vgRo[WႢ)
				item.iImage = IMG_EXC_FILE;
				lstrcat(strVerBufForClip,strClipBrdImg[item.iImage]);
			}
			else
			{
				//mxd ƂėL
				item.iImage = IMG_MXD_FILE;
				lstrcat(strVerBufForClip,strClipBrdImg[item.iImage]);
			}
			item.pszText = "MXD g";
			item.iItem   = i;
			item.iSubItem = 0;
			lstrcat(strVerBufForClip,item.pszText);
			lstrcat(strVerBufForClip,"\t");
			ListView_InsertItem(hLVForUnpack, &item);

			item.pszText = (*mxd_findfile).cFileName;
			item.iSubItem = 1;
			lstrcat(strVerBufForClip,item.pszText);
			lstrcat(strVerBufForClip,"  \t");
			ListView_SetItem(hLVForUnpack, &item);

			if(GetVer != NULL)
			{	
				int ver=(*GetVer)();
				wsprintf(item.pszText,"Ver.%d.%02d.%d",ver/1000,ver/10%100,ver%10);
			}
			else
			{
				item.pszText="";
			}
			item.iSubItem = 2;
			lstrcat(strVerBufForClip,item.pszText);
			lstrcat(strVerBufForClip,"\r\n");
			ListView_SetItem(hLVForUnpack, &item);

			i++;
			if( j >= SUPPORT_MXD_NUM ) break; //MXD_MAX!

			j++;
		}while(FindNextFile(hFndfst,mxd_findfile));
	}

	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ ACR^Cv (ǂݍݗp) for k
	lstrcat(strVerBufForClip,"\r\n[kGW̃o[W]\r\n");

	int IconTypeForPack[DLLNUM_FOR_PACK+1]=
	{
		IMG_EXE_MAIN,
		IMG_ARC_FILE,  IMG_ARC_FILE, IMG_ARC_FILE, IMG_ARC_FILE, IMG_ARC_FILE,
		IMG_ARC_FILE, IMG_ARC_FILE, IMG_JAK_FILE
	};
	char TypeNameForPack[DLLNUM_FOR_PACK+1][12] = 
	{
		"k{",
		"LZH k", "ZIP k", "7Z k",  "CAB k", "TAR k",
		"BGA k",   "YZ1 k", 	 "JAK "
	};
	char FileNameForPack[DLLNUM_FOR_UNPACK+1][16] = 
	{
		"FROSTICE.MXD",
		"UNLHA32.DLL", "ZIP32J.DLL",   "7-ZIP32.DLL", "CAB32.DLL", "TAR32.DLL",
		"BGA32.DLL",   "YZ1.DLL",     "JACK32.DLL"
	 };
	char FileVerGetApiForPack[DLLNUM_FOR_UNPACK+1][20] =
	{
		"MxdGetVersion",
		"UnlhaGetVersion", 	"ZipGetVersion", "SevenZipGetVersion", "CabGetVersion", "TarGetVersion",
		"BgaGetVersion",	"Yz1GetVersion",	"JackGetVersion"
	};
	char FileSubVerGetApiForPack[DLLNUM_FOR_UNPACK+1][22] =
	{
		"",
		"UnlhaGetSubVersion", "ZipGetSubVersion","SevenZipGetSubVersion", "CabGetSubVersion", "TarGetSubVersion",
		"BgaGetSubVersion",	"Yz1GetSubVersion",	"JackGetSubVersion"
	};

	for(i=0; i<=DLLNUM_FOR_PACK; i++)
	{
		HINSTANCE  hInstDll = LoadLibrary( FileNameForPack[i] );
		int DllVersion=0;
		int DllSubVersion=0;
		if(hInstDll != NULL)
		{
			PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll, FileVerGetApiForPack[i]);
			if(GetVer != NULL)
			{
				DllVersion = (int)(*GetVer)();
				PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll, FileSubVerGetApiForPack[i]);
				if(GetVer != NULL)
				{
					DllSubVersion = (int)(*GetVer)();
				}else
				{
					DllSubVersion = 0;
				}
			}else{
				DllVersion = 0;
				DllSubVersion = 0;
			}
			FreeLibrary(hInstDll);
		}else{
			 DllVersion = 0;
			 DllSubVersion = 0;
		}

	//烊Xgr[ɓo^
		if(i==0) bIsFrosticeEnable = false;
		 item.mask = LVIF_TEXT|LVIF_IMAGE;
		if(DllVersion != 0)
		{
			item.iImage = IconTypeForPack[i];//펞̃ACR^Cv
			if(i==0) bIsFrosticeEnable = true;
			else if(bIsFrosticeEnable == false)
			{
				item.iImage = IMG_EXC_FILE; //Frostice.mxd ȂƈkłȂ̂ŁB
			}
			
			hInstDll = LoadLibrary("ZIP32.DLL");
			if(i==2 && hInstDll==NULL)      //ZIP32J.DLL (i2) ̏
			{
				item.iImage = IMG_EXC_FILE; //ZIP32.DLL Ȃ ZIP32J.DLL ͈kłȂ̂ŁB
			}else
			{
				FreeLibrary(hInstDll);
			}
			
		}else{
			item.iImage = IMG_ERR_FILE;
		}
		item.pszText = TypeNameForPack[i];
		item.iItem   = i;
		item.iSubItem = 0;
		lstrcat(strVerBufForClip,strClipBrdImg[item.iImage]);
		lstrcat(strVerBufForClip,item.pszText);
		lstrcat(strVerBufForClip,"\t");
		ListView_InsertItem(hLVForPack, &item);

		item.pszText = FileNameForPack[i];
		item.iSubItem = 1;
		lstrcat(strVerBufForClip,item.pszText);
		lstrcat(strVerBufForClip,"  \t");
		ListView_SetItem(hLVForPack, &item);

		if(DllVersion == 0)
		{
			item.pszText = DLL_NOT_FOUND_MSG;
		}else{
			if(i != 0)
			{
				if(DllSubVersion == 0)
				{
					wsprintf(item.pszText,"Ver.%d.%02d", DllVersion/100,DllVersion%100);
				}else{
					wsprintf(item.pszText,"Ver.%d.%02d.%d.%d", DllVersion/100,DllVersion%100,DllSubVersion/100,DllSubVersion%100);
				}
			}else{
				wsprintf(item.pszText,"Ver.%d.%02d.%d", DllVersion/1000,DllVersion/10%100,DllVersion%10);
			}
		}
		item.iSubItem = 2;
		lstrcat(strVerBufForClip,item.pszText);
		lstrcat(strVerBufForClip,"\r\n");
		ListView_SetItem(hLVForPack, &item);
	}
}

//---------------------------------------------------------------------------------------------------------------------
//_CAȌ[`B
LRESULT CALLBACK MIFVEREXDLGProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
	//////Load Dialog locate.
			RECT deskrc; //desktop rc.
			RECT rc;
			int x,y;

			GetWindowRect(hDlg, (LPRECT)&rc);
			SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
			x = (deskrc.right - (rc.right-rc.left)) / 2;
			y = (deskrc.bottom - (rc.bottom-rc.top)) /2;
			SetWindowPos(hDlg, HWND_TOP, x, y, (rc.right-rc.left), (rc.bottom-rc.top),SWP_SHOWWINDOW);

	//////eo[W (Meltice Family / Windows)
			char strVerInfo[MAX_BUF];
	//////Meltice Family o[W
			lstrcpy(strVerInfo,"Meltice Family ");

			WIN32_FIND_DATA FindFileData; //f[^obt@
			//t@C
			static char CaldixFileName[MAX_PATH];
			static char ExecDir[MAX_PATH];

			lstrcat(strVerInfo,"AwaawaCL Core Pack ");


			if(lstrcmp(strMelticeVersion,"")==0)
			{
				lstrcat(strVerInfo,MELTICE_VERSION_DEFAULT);
			}
			else
			{
				lstrcat(strVerInfo,strMelticeVersion);
			}
			lstrcat(strVerInfo, "\r\nCopyright (C)2000-2025 킠킢vWFNg\r\n");
			lstrcat(strVerInfo, "  SNS : @asaasa@misskey.io\r\n");
			lstrcat(strVerInfo, "  E-Mail : meltice@asaasa.tk\r\n");
			lstrcat(strVerInfo, "  Web URL : https://asaasa.tk/awa/");
			
			lstrcat(strVerBufForClip,strVerInfo);
			lstrcat(strVerBufForClip,"\r\n\r\n[VXe]");
			Static_SetText(GetDlgItem(hDlg, IDC_STATIC_VERINFO), strVerInfo);
		//////CALDIX L
			HANDLE ExistFileForCaldix;
			get_exec_dir(ExecDir,MAX_PATH);
			lstrcpy(CaldixFileName,ExecDir);
			lstrcat(CaldixFileName,"CALDIX.EXE");
			ExistFileForCaldix = FindFirstFile(CaldixFileName,&FindFileData);
			if(ExistFileForCaldix != INVALID_HANDLE_VALUE )
			{
				// WinExec -> ShellExecute ւ̒u񂾂߁ARgAEgB(WinVista łƓ悤ɂȂ܂)
				////Caldix ݂{^p (Windows Server XP/2003 ȑOɌAWindows Vista ł͐ɓȂ)B
				//if(GetWindowsProductInfo() == FALSE)	//GetWindowsProductInfo  Windows Vista ȍ~ FALSE ԂB
				//{
					ShowWindow(GetDlgItem(hDlg,ID_BTN_CALDIX),SW_SHOW);
				//}

				//V[ht{^ɂ (WinVista ȍ~)
				const UINT BCM_SETSHIELD = 0x0000160C;
				SendMessage(GetDlgItem(hDlg,ID_BTN_CALDIX), BCM_SETSHIELD, 0, TRUE);

				FindClose(ExistFileForCaldix);
			}

		//////Windows o[W
			char strWinVerInfo[MAX_BUF];
			lstrcpy(strVerInfo,"\r\nVXe :\tWindows ");

			//o[W߂B
			OSVERSIONINFOEX_VS60 osVer;   memset(&osVer,   0, sizeof(OSVERSIONINFOEX_VS60));
			BOOL bOsVersionInfoEx;
			osVer.dwOSVersionInfoSize = sizeof(osVer);
			osVer.dwBuildNumber = 0;
			bOsVersionInfoEx = GetVersionEx((OSVERSIONINFO *)&osVer);

			//rhԍ 0 ƂƂ́AGetVersionEx ɎsƂƁB
			//Windows 95/98/NT4 ƂƂl̂ŁAOSVERSIONINFO ̑傫ςăgCB
			if(osVer.dwBuildNumber == 0)
			{
				//for Windows 9x o[W
				//(Windows 98 ȑOł OSVERSIONINFOEX ɑΉĂȂ̂ōēxo[W߂)
				memset(&osVer,   0, sizeof(OSVERSIONINFOEX_VS60));
				osVer.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
				GetVersionEx ((OSVERSIONINFO *)&osVer);
			}

			//Windows NT nȂ
			if (osVer.dwPlatformId == VER_PLATFORM_WIN32_NT)
			{
				//Windows 8.x/10 or Windows Server 2012 (NT6.2+) ܂͂ȏ
				if( (osVer.dwMajorVersion >= 7) ||
					(osVer.dwMajorVersion == 6 && osVer.dwMinorVersion >= 2) )
				{
					if(osVer.wProductType == 0x0000001) //0x0000001 = VER_NT_WORKSTATION
					{
						//rhԍɂςɔʁB
						//dwBuildNumber ŔʁB
						if(osVer.dwBuildNumber >= 8102 && osVer.dwBuildNumber <= 8400)
						{
							wsprintf(strWinVerInfo,"8.0 ");
						}else if(osVer.dwBuildNumber > 8400 && osVer.dwBuildNumber <= 9840)
						{	
							wsprintf(strWinVerInfo,"8.1 ");
						}else if(osVer.dwBuildNumber > 9840)
						{
							// --- Windows 10
							if(osVer.dwBuildNumber < 10240)
							{	//炭v[XȂǂ̃o[WAtȂ
								wsprintf(strWinVerInfo,"10 ");
							}else if(osVer.dwBuildNumber == 10240){	wsprintf(strWinVerInfo,"10 Golden [15.07]");
							}else if(osVer.dwBuildNumber <= 10586){	wsprintf(strWinVerInfo,"10 TH2 [15.11]");
							}else if(osVer.dwBuildNumber <= 14393){	wsprintf(strWinVerInfo,"10 RS1 [16.07]");
							}else if(osVer.dwBuildNumber <= 15063){	wsprintf(strWinVerInfo,"10 RS2 [17.03] ");
							}else if(osVer.dwBuildNumber <= 16299){	wsprintf(strWinVerInfo,"10 RS3 [17.09] ");
							}else if(osVer.dwBuildNumber <= 17134){	wsprintf(strWinVerInfo,"10 RS4 [18.03] ");
							}else if(osVer.dwBuildNumber <= 17763){	wsprintf(strWinVerInfo,"10 RS5 [18.09] ");
							}else if(osVer.dwBuildNumber <= 18362){	wsprintf(strWinVerInfo,"10 19H1 [19.03] ");
							}else if(osVer.dwBuildNumber <= 18363){	wsprintf(strWinVerInfo,"10 19H2 [19.09] ");
							}else if(osVer.dwBuildNumber <= 19041){	wsprintf(strWinVerInfo,"10 20H1 [20.04] ");
							}else if(osVer.dwBuildNumber <= 19042){	wsprintf(strWinVerInfo,"10 20H2 ");
							}else if(osVer.dwBuildNumber <= 19043){	wsprintf(strWinVerInfo,"10 21H1 ");
							}else if(osVer.dwBuildNumber <= 19044){	wsprintf(strWinVerInfo,"10 21H2 ");
							}else if(osVer.dwBuildNumber <= 19045){	wsprintf(strWinVerInfo,"10 22H2 ");
							}else if(osVer.dwBuildNumber <  22000){	wsprintf(strWinVerInfo,"10 Unknown ");
							// --- Windows 11
							}else if(osVer.dwBuildNumber <= 22000){	wsprintf(strWinVerInfo,"11 21H2 ");
							}else if(osVer.dwBuildNumber <= 22621){	wsprintf(strWinVerInfo,"11 2022 Update [22H2] ");
							}else if(osVer.dwBuildNumber <= 22631){	wsprintf(strWinVerInfo,"11 2023 Update [23H2] ");
							}else if(osVer.dwBuildNumber <= 26100){	wsprintf(strWinVerInfo,"11 2024 Update [24H2] ");
							}else if(osVer.dwBuildNumber <= 26200){	wsprintf(strWinVerInfo,"11 2025 Update [25H2] ");
							}else
							{
								//Windows 11 25H2? Ȃȍ~BĂȂɂtȂB
								wsprintf(strWinVerInfo,"11 or later ");
								;
							}
						}
					}else
					{ 
						// 2012 R2 / 2016 / ȍ~B
						wsprintf(strWinVerInfo,"Server 20xx or later ");
					}
				}

				//Windows 7 / 2008 R2 (NT Ver.6.1)
				else if(osVer.dwMajorVersion == 6 && osVer.dwMinorVersion == 1)
				{
					if(osVer.wProductType == 0x0000001) //0x0000001 = VER_NT_WORKSTATION
						wsprintf(strWinVerInfo,"7 ");
					else 
						wsprintf(strWinVerInfo,"Server 2008 R2 ");
				}
				//Windows Vista
				else if(osVer.dwMajorVersion == 6 && osVer.dwMinorVersion == 0)
				{
					if(osVer.wProductType == 0x0000001) //0x0000001 = VER_NT_WORKSTATION
						wsprintf(strWinVerInfo,"Vista ");
					else 
						wsprintf(strWinVerInfo,"Server 2008 ");
				//Windows 2003 or Windows XP Professional x64 Edition 
				}
				else if(osVer.dwMajorVersion == 5 && osVer.dwMinorVersion == 2)
				{
					if(osVer.wProductType == 0x0000001) //0x0000001 = VER_NT_WORKSTATION
						wsprintf(strWinVerInfo,"XP ");
					else
						wsprintf(strWinVerInfo,"Server 2003 ");
				}
				//Windows XP
				else if(osVer.dwMajorVersion == 5 && osVer.dwMinorVersion == 1)
					wsprintf(strWinVerInfo,"XP ");
				//Windows 2000
				else if(osVer.dwMajorVersion == 5 && osVer.dwMinorVersion == 0)
					wsprintf(strWinVerInfo,"2000 ");
				else
					wsprintf(strWinVerInfo,"NT %d.%d ",osVer.dwMajorVersion,osVer.dwMinorVersion);

				//"Windows قɂ"
				lstrcat(strVerInfo, strWinVerInfo);
				
				if(bOsVersionInfoEx)
				{
					lstrcpy(strWinVerInfo,"");
					if(osVer.wProductType == 0x0000001)		//0x0000001 = VER_NT_WORKSTATION
					{
						if(osVer.dwMajorVersion == 4);
						else if(osVer.dwMajorVersion == 5)	//Ver.5.x = Windows 2000/XP/2003
						{
							if(osVer.wSuiteMask & 0x00000200) //0x00000200 = VER_SUITE_PERSONAL
								wsprintf(strWinVerInfo,"Home Edition ");
							else
								wsprintf(strWinVerInfo,"Professional ");
						}
						else if(osVer.dwMajorVersion == 6 && 
							(osVer.dwMinorVersion == 0) || (osVer.dwMinorVersion == 1))	//Ver.6.0 = Windows Vista / Ver.6.1 = Windows 7
						{
							//Windows Vista  osVer.wSuiteMask  VER_SUITE_PERSONAL Ă
							//Home Basic, Home Premium  Business, Enterprise, Ultimate 킩Ȃ̂ŐV API gƂɂȂ
							switch(GetWindowsProductInfo())
							{
							case 0x00000001:	//PRODUCT_ULTIMATE
								wsprintf(strWinVerInfo,"Ultimate ");
								break;
							case 0x00000002:	//PRODUCT_HOME_BASIC
							case 0x00000005:	//PRODUCT_HOME_BASIC_N 
								//Windows Vista pBWindows 7 Home Basic ͓{ł͔Ȃ͂B
								wsprintf(strWinVerInfo,"Home Basic ");
								break;
							case 0x00000003:	//PRODUCT_HOME_PREMIUM 
								wsprintf(strWinVerInfo,"Home Premium ");
								break;
							case 0x00000004:	//PRODUCT_ENTERPRISE 
								wsprintf(strWinVerInfo,"Enterprise ");
								break;
							case 0x00000006:	//PRODUCT_BUSINESS
							case 0x00000010:	//PRODUCT_BUSINESS_N
								if(osVer.dwMinorVersion == 0)
									//Ver.6.0 = Windows Vista Business
									wsprintf(strWinVerInfo,"Business ");
								else if(osVer.dwMinorVersion == 1)
									//Ver.6.1 = Windows 7 Professional
									wsprintf(strWinVerInfo,"Pro. ");
								break;
							case 0x0000000B:	//PRODUCT_STARTER ({ł݂͑Ȃ)
								wsprintf(strWinVerInfo,"Starter ");
								break;
							default:
								//v_Ng̕s (WORKSTATION n̂͂Ȃ̂ Server nԂP[X)̏ꍇ͓ɒǋLȂB
								break;

							}
						}
					}else
					{
						//"Windows NT 4.0 Server" or "Windows 2000 Server"s
						if( (osVer.dwMajorVersion == 4 && osVer.dwMinorVersion == 0) ||
						    (osVer.dwMajorVersion == 5 && osVer.dwMinorVersion == 0) )
							wsprintf(strWinVerInfo,"Server ");
					}
					// Windows NT 4.0  :                                   "Server"
					// Windows 2000    :                  "Professional" / "Server"
					// Windows XP      : "Home Edition" / "Professional"            (Tablet PC  / Media Center / x64  Proł)
					// Windows 2003    :  (Windows Server 2003 )
					// Windows Vista   : "Starter" / "Home Basic" / "Home Premium" / "Business" / "Enterprise" / "Ultimate"
					lstrcat(strVerInfo, strWinVerInfo);
				}
				//"Service Pack n"
				char WinOSSvcPck[16]; ZeroMemory(&WinOSSvcPck[0], 16);
				lstrcpyn(&WinOSSvcPck[0], osVer.szCSDVersion, 15);
				lstrcat(strVerInfo, WinOSSvcPck);

				//(Version n.nn Build nnnn)
				wsprintf(strWinVerInfo,"\r\n\t\t(NT n/Ver.%d.%d Build %d)\r\n",osVer.dwMajorVersion,osVer.dwMinorVersion,osVer.dwBuildNumber & 0xFFFF);
				lstrcat(strVerInfo, strWinVerInfo);
			}
			//Win32s (̂H)
			else if (osVer.dwPlatformId == VER_PLATFORM_WIN32s)
			{
				wsprintf(strWinVerInfo,"Ver.3.1 + Win32s Ver.%d.%d\r\n",osVer.dwMajorVersion,osVer.dwMinorVersion);
			}
			//Windows 9x ̏ꍇ
			else if(osVer.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
			{
				//Windows Me
				if(osVer.dwMajorVersion == 4 && osVer.dwMinorVersion == 90)
					wsprintf(strWinVerInfo,"Millennium Edition (Windows Me)\r\n");
				//Windows 98
				else if(osVer.dwMajorVersion == 4 && osVer.dwMinorVersion == 10)
				{
					if(LOWORD(osVer.dwBuildNumber & 0xFFFF) >= 2222)
						wsprintf(strWinVerInfo,"98 Second Edition\r\n");
					else
						wsprintf(strWinVerInfo,"98 \r\n");
				//Windows 95
				}else if(osVer.dwMajorVersion == 4 && osVer.dwMinorVersion == 0)
					if(     (osVer.dwBuildNumber & 0xFFFF) >=1214)
						wsprintf(strWinVerInfo,"95 OSR 2.5\r\n");
					else if((osVer.dwBuildNumber & 0xFFFF) >=1212)
						wsprintf(strWinVerInfo,"95 OSR 2.1\r\n");
					else if((osVer.dwBuildNumber & 0xFFFF) >=1111)
						wsprintf(strWinVerInfo,"95 OSR 2.0\r\n");
					else
						wsprintf(strWinVerInfo,"95\r\n");
				else if(osVer.dwMajorVersion == 0 && osVer.dwMinorVersion == 0)
				{
					wsprintf(strWinVerInfo,"9x\r\n");
				}
				else
					wsprintf(strWinVerInfo,"Ver.%d.%d\r\n",osVer.dwMajorVersion,osVer.dwMinorVersion);

				//"Windows 9x"
				lstrcat(strVerInfo, strWinVerInfo);
				//(Version n.nn Build nnnn)
				if(osVer.dwMajorVersion != 0)
				{
					wsprintf(strWinVerInfo,"\t\t(9x n/Ver.%d.%d Build %u)\r\n",osVer.dwMajorVersion,osVer.dwMinorVersion,osVer.dwBuildNumber & 0xFFFF/*LOWORD(osVer9x.dwBuildNumber)*/);
					lstrcat(strVerInfo, strWinVerInfo);
				}
			}

		//////󂫃+[U[pϐ
			char buf[256],buf2[256]; unsigned long buflen;buflen=255;
			//2GB I[o[tO (0 Ȃ璴ߖ)
			int mem2g_over_flag;mem2g_over_flag = 0;

		//////󂫃
			lstrcpyn(buf,"󂫃 :\t",buflen);
			MEMORYSTATUS  MemoryStatus;
			GlobalMemoryStatus(&MemoryStatus);
			if(MemoryStatus.dwAvailPhys == -1)
			{
				wsprintf(buf2,"4GB over");
				lstrcat(buf,buf2);
				mem2g_over_flag++;
			}
			else if(((MemoryStatus.dwAvailPhys+1) / 1024 / 1024 / 1024) == 2)
			{
				//2GB-1byte Ȓl̏ꍇ́A2-4GB ܂͂̒߂̉\
				//(Visual Studio ̌Â߂̃o[W Borland C++ Ńrh exe/dll ƂȂ)
				wsprintf(buf2,"2GB or 2GB over");
				lstrcat(buf,buf2);
				mem2g_over_flag++;
			}
			else
			{
				wsprintf(buf2,"%d KB", MemoryStatus.dwAvailPhys / 1024);
				lstrcat(buf,buf2);
			}

			wsprintf(buf2," /  : ");
			lstrcat(buf,buf2);

			if(MemoryStatus.dwTotalPhys == -1)
			{
				wsprintf(buf2,"4GB over\r\n");
				lstrcat(buf,buf2);
				mem2g_over_flag++;
			}
			else if(((MemoryStatus.dwTotalPhys+1) / 1024 / 1024 / 1024) == 2)
			{
				//2GB-1byte Ȓl̏ꍇ́A2-4GB ܂͂̒߂̉\
				//(Visual Studio ̌Â߂̃o[W Borland C++ Ńrh exe/dll ƂȂ)
				wsprintf(buf2,"2GB or 2GB\r\n");
				lstrcat(buf,buf2);
				mem2g_over_flag++;
			}
			else
			{
				wsprintf(buf2,"%d KB\r\n", MemoryStatus.dwTotalPhys / 1024);
				lstrcat(buf,buf2);
			}
			
			if(mem2g_over_flag == 0)
			{
				// 2GB ȓ̏ꍇ̂ݕ\ (2GB over ɂ͋󂫃\͈ӖȂ)
				lstrcat(strVerInfo,buf);
			}

		//////[U[
			if(GetUserName(buf,&buflen))
			{
				wsprintf(buf2,"[U[ :\t%s\r\n",buf);
				lstrcat(strVerInfo,buf2);
			}

			lstrcat(strVerBufForClip,strVerInfo);
			Static_SetText(GetDlgItem(hDlg, IDC_STATIC_OSINFO), strVerInfo);

		//////ListView
			static HWND hLVForUnpack, hLVForPack;						//Xgr[
			static HIMAGELIST hImgLstForUnpack, hImgLstForPack;				//C[WXgnh
			hImgLstForUnpack = NULL; hImgLstForPack = NULL;
			hLVForUnpack		= GetDlgItem(hDlg, IDC_LIST_FOR_MELTICE);
			hLVForPack			= GetDlgItem(hDlg, IDC_LIST_FOR_FROSTICE);
			hImgLstForUnpack	= ImageList_Create(16, 16, ILC_COLORDDB, 7, 0);	//DLLpC[WXgm
   			hImgLstForPack		= ImageList_Create(16, 16, ILC_COLORDDB, 6, 0);	//kDLLpC[WXgm
			InitListView(hLVForUnpack, hLVForPack, hImgLstForUnpack, hImgLstForPack);				//Xgr[B

			SetActiveWindow(hDlg);
			SetForegroundWindow(hDlg);
		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDOK:
				case IDCANCEL:
					//if(hImgLstForUnpack != NULL) ImageList_Destroy(hImgLstForUnpack);
					//if(hImgLstForPack   != NULL) ImageList_Destroy(hImgLstForPack);
					EndDialog(hDlg, IDCANCEL); //end.
					break;
				case ID_BTN_CALDIX:
					//WinExec -> ShellExecute  API ύX(for WinVista Suport)
					//WinExec(CaldixFileName,SW_SHOW);
					ShellExecute(hDlg,"open", CaldixFileName, NULL, NULL, SW_SHOW);
					break;
				case ID_BTN_COPY:
					//Nbv{[hɊi[s
					{
						HGLOBAL hClipBrd;
						char    *pstrClip;
						hClipBrd = GlobalAlloc(GHND, lstrlen(strVerBufForClip)+1);
						pstrClip = (char *)GlobalLock(hClipBrd);

						lstrcpy(pstrClip,strVerBufForClip);

						GlobalUnlock(hClipBrd);
						OpenClipboard(hDlg);
						EmptyClipboard();
						SetClipboardData(CF_TEXT, hClipBrd);
						CloseClipboard();
					}
					break;
				default:
					break;
			}
		default:
			break;
	}
	return FALSE;
}

//---------------------------------------------------------------------------------------------------------------------
//DLL̃o[WԂ(ԂgȂ)
EXPORT int WINAPI MveGetVersion(void)
{
	return MIFVEREX_VER;
}
//---------------------------------------------------------------------------------------------------------------------
//DLL̃vgRo[WԂBvȂ΃NVbNȃo[W\ƂȂB
EXPORT int WINAPI MveGetProtocolVer(void)
{
#ifdef _DEBUG
#else
	//𑜓x擾...
	RECT deskrc; //desktop rc.
	SystemParametersInfo(SPI_GETWORKAREA,0,&deskrc,0);//Desktop size without taskbar.
	if(deskrc.right < 800) return 0;				  //𑜓x 800x600 ̏ꍇ͕\ȂB
#endif
	//ꃂ[h擾
	UINT CodePage = GetACP();
	if(CodePage != 932) return 0;	//{ꃂ[hȊȌꍇ͋ہB

	return MIFVEREX_PROTOCOL_VER;
}
//---------------------------------------------------------------------------------------------------------------------
//Meltice ̃o[W (Frostice.mxd ͂̊֐Ă΂Ȃ)
//vernum : Ver.x.y.zz (2.2.1 Ȃ 2201)
EXPORT void WINAPI MveSetMelticeVer(LPCSTR verstr)
{
	lstrcpyn(strMelticeVersion,verstr,MAX_BUF);
}

//---------------------------------------------------------------------------------------------------------------------
//o[W\B
EXPORT void WINAPI MvePutVersionDialog(HWND hDlg)
{
	//mۂƃbN
	HGLOBAL hGlobal;
	hGlobal          = GlobalAlloc(GHND, sizeof(char) * CLIPBRD_BUF); 
	strVerBufForClip = (char *)GlobalLock(hGlobal);

	//_CAO\
	DialogBox(hInstance, "IDD_DLG_MIFVEREX_JP", hDlg, (DLGPROC)MIFVEREXDLGProc);

	//
	GlobalUnlock(hGlobal);
	GlobalFree(hGlobal);
}
